/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.config;

import java.util.Dictionary;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, label="Forms Portal Draft and Submission Configuration", description="Forms Portal Draft and Submission Configuration")
@Service(value={FormsPortalDraftsandSubmissionConfigService.class})
public class FormsPortalDraftsandSubmissionConfigService {
    private static final String DEFAULT_DRAFT_DATA_SERVICE = "com.adobe.fd.fp.service.impl.DraftDataServiceImpl";
    private static final String DEFAULT_SUBMIT_DATA_SERVICE = "com.adobe.fd.fp.service.impl.SubmitDataServiceImpl";
    private static final String DEFAULT_PENDING_SIGN_DATA_SERVICE = "com.adobe.fd.fpaddon.service.impl.PendingSignDataServiceImpl";
    private static final String DEFAULT_DRAFT_METADATA_SERVICE = "com.adobe.fd.fp.service.impl.DraftMetadataServiceImpl";
    private static final String DEFAULT_SUBMIT_METADATA_SERVICE = "com.adobe.fd.fp.service.impl.SubmitMetadataServiceImpl";
    private static final String DEFAULT_PENDING_SIGN_METADATA_SERVICE = "com.adobe.fd.fpaddon.service.impl.PendingSignMetadataServiceImpl";
    private static final String[] DEFAULT_FP_OUTBOXES = new String[]{"outbox"};
    private static final String DEFAULT_FP_ROOT = "/content/forms/fp";
    @Property(cardinality=2000, value={"outbox"}, label="Outboxes to be used for Reverse Replication in Forms Portal", description="To configure outboxes for Forms Portal Draft Save and Submit Options")
    private static final String FP_OUTBOXES = "portal.outboxes";
    private String[] fpOutboxes = DEFAULT_FP_OUTBOXES;
    @Property(value={"com.adobe.fd.fp.service.impl.DraftDataServiceImpl"}, label="Forms Portal Draft Data Service", description="Identifier for draft data service")
    private static final String FP_DRAFT_DATA_SERVICE = "draft.data.service";
    private String draftDataService = "com.adobe.fd.fp.service.impl.DraftDataServiceImpl";
    @Property(value={"com.adobe.fd.fp.service.impl.DraftMetadataServiceImpl"}, label="Forms Portal Draft Metadata Service", description="Identifier for draft metadata service")
    private static final String FP_DRAFT_METADATA_SERVICE = "draft.metadata.service";
    private String draftMetadataService = "draft.metadata.service";
    @Property(value={"com.adobe.fd.fp.service.impl.SubmitDataServiceImpl"}, label="Forms Portal Submit Data Service", description="Identifier for submit data service")
    private static final String FP_SUBMIT_DATA_SERVICE = "submit.data.service";
    private String submitDataService = "com.adobe.fd.fp.service.impl.SubmitDataServiceImpl";
    @Property(value={"com.adobe.fd.fp.service.impl.SubmitMetadataServiceImpl"}, label="Forms Portal Submit Metadata Service", description="Identifier for submit metadata service")
    private static final String FP_SUBMIT_METADATA_SERVICE = "submit.metadata.service";
    private String submitMetadataService = "draft.metadata.service";
    @Property(value={"com.adobe.fd.fpaddon.service.impl.PendingSignDataServiceImpl"}, label="Forms Portal Pending Sign Data Service", description="Identifier for pending sign data service")
    private static final String FP_PENDING_SIGN_DATA_SERVICE = "pendingSign.data.service";
    private String pendingSignDataService = "com.adobe.fd.fpaddon.service.impl.PendingSignDataServiceImpl";
    @Property(value={"com.adobe.fd.fpaddon.service.impl.PendingSignMetadataServiceImpl"}, label="Forms Portal Pending Sign Metadata Service", description="Identifier for pending sign metadata service")
    private static final String FP_PENDING_SIGN_METADATA_SERVICE = "pendingSign.metadata.service";
    private String pendingSignMetadataService = "com.adobe.fd.fpaddon.service.impl.PendingSignMetadataServiceImpl";

    protected void activate(ComponentContext context) {
        Dictionary<String, Object> props = context.getProperties();
        this.fpOutboxes = OsgiUtil.toStringArray(props.get(FP_OUTBOXES), DEFAULT_FP_OUTBOXES);
        this.draftDataService = OsgiUtil.toString(props.get(FP_DRAFT_DATA_SERVICE), DEFAULT_DRAFT_DATA_SERVICE);
        this.draftMetadataService = OsgiUtil.toString(props.get(FP_DRAFT_METADATA_SERVICE), DEFAULT_DRAFT_METADATA_SERVICE);
        this.submitDataService = OsgiUtil.toString(props.get(FP_SUBMIT_DATA_SERVICE), DEFAULT_SUBMIT_DATA_SERVICE);
        this.submitMetadataService = OsgiUtil.toString(props.get(FP_SUBMIT_METADATA_SERVICE), DEFAULT_SUBMIT_METADATA_SERVICE);
        this.pendingSignDataService = OsgiUtil.toString(props.get(FP_PENDING_SIGN_DATA_SERVICE), DEFAULT_PENDING_SIGN_DATA_SERVICE);
        this.pendingSignMetadataService = OsgiUtil.toString(props.get(FP_PENDING_SIGN_METADATA_SERVICE), DEFAULT_PENDING_SIGN_METADATA_SERVICE);
    }

    public String getDraftDataService() {
        return this.draftDataService;
    }

    public String getSubmitDataService() {
        return this.submitDataService;
    }

    public String getDraftMetadataService() {
        return this.draftMetadataService;
    }

    public String getSubmitMetadataService() {
        return this.submitMetadataService;
    }

    public String getFormsPortalRoot() {
        return DEFAULT_FP_ROOT;
    }

    public String[] getFormsPortalOutboxes() {
        return this.fpOutboxes;
    }

    public String getPendingSignDataService() {
        return this.pendingSignDataService;
    }

    public String getPendingSignMetadataService() {
        return this.pendingSignMetadataService;
    }
}

