/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.fp.common;

import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.fd.fp.common.FPSubmitHandler;
import com.adobe.fd.fp.exception.FormsPortalException;
import com.adobe.fd.fp.util.RepositoryUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.commons.json.JSONObject;

@Component
public abstract class AdaptiveFormSubmissionBase
extends FPSubmitHandler {
    private static final long serialVersionUID = 4916445735602389229L;
    @Reference
    protected ResourceResolverHelper resourceResolverHelper;

    protected Map<String, Object> getOptionsFromSubmitInfo(FormSubmitInfo formSubmitInfo, Map<String, Object> options) throws FormsPortalException {
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        try {
            options.put("attachments", formSubmitInfo.getFileAttachments());
            options.put("owner", formSubmitInfo.getFormSubmitter());
            if (formSubmitInfo.getDocumentOfRecord() != null) {
                options.put("pdf", this.getDorBytes(formSubmitInfo));
                options.put("pdfName", formSubmitInfo.getDocumentOfRecord().getFileName());
            }
            options.put("formType", "af");
            options.put("formContainerPath", formSubmitInfo.getFormContainerPath());
            options.put("contentType", formSubmitInfo.getContentType());
            options.put("formData", formSubmitInfo.getData());
            options.put("fileAttachmentMap", formSubmitInfo.getFileAttachmentMap());
            options.put("locale", formSubmitInfo.getLocale());
            String fpAllowedMetadata = (String)options.get("fpAllowedMetadata");
            if (!StringUtils.isEmpty(fpAllowedMetadata)) {
                this.filterAllowedMetadata(options, options);
                fpAllowedMetadata = fpAllowedMetadata + ",fileAttachmentMap";
            } else {
                fpAllowedMetadata = "fileAttachmentMap";
            }
            PortalRecordInfo portalInfo = formSubmitInfo.getPortalRecordInfo();
            if (portalInfo != null && StringUtils.isNotEmpty(portalInfo.getPendingSignId())) {
                options.put("pendingSignID", portalInfo.getPendingSignId());
            }
            options.put("fpAllowedMetadata", fpAllowedMetadata);
            this.addAgreementsRelatedInfo(formSubmitInfo, options);
        }
        catch (Exception e) {
            throw new FormsPortalException(e);
        }
        return options;
    }

    private void addAgreementsRelatedInfo(FormSubmitInfo formSubmitInfo, Map<String, Object> options) {
        if (formSubmitInfo != null) {
            PortalRecordInfo portalRecordInfo = formSubmitInfo.getPortalRecordInfo();
            if (portalRecordInfo != null && StringUtils.isNotEmpty(portalRecordInfo.getPendingSignId())) {
                options.put("pendingSignID", portalRecordInfo.getPendingSignId());
            }
            if (StringUtils.isNotEmpty(formSubmitInfo.getAgreementId())) {
                options.put("agreementId", formSubmitInfo.getAgreementId());
            }
            if (formSubmitInfo.getSignData() != null) {
                options.put("agreementData", new String(formSubmitInfo.getSignData()));
            }
            String fpAllowedMetadata = (String)options.get("fpAllowedMetadata");
            fpAllowedMetadata = fpAllowedMetadata + "," + "pendingSignID" + "," + "agreementId" + "," + "agreementData";
            options.put("fpAllowedMetadata", fpAllowedMetadata);
        }
    }

    protected Node getFormNodeFromPath(String formPath) throws RepositoryException {
        Session currentSession;
        Node formNode = null;
        RepositoryUtils repUtils = RepositoryUtils.getInstance(this.draftsandSubmissionConfiguration);
        String parentCQPage = repUtils.findParentCQPage(formPath, currentSession = this.resourceResolverHelper.getResourceResolverAs(Session.class));
        String string = formPath = parentCQPage != null ? parentCQPage : formPath;
        if (formPath != null && formPath.startsWith("/content/forms/af")) {
            formPath = "/content/dam/formsanddocuments" + formPath.substring("/content/forms/af".length());
        }
        if (currentSession.nodeExists(formPath)) {
            formNode = currentSession.getNode(formPath);
        }
        return formNode;
    }

    protected JSONObject submitFormInternal(FormSubmitInfo formSubmitInfo, Map<String, Object> options) throws FormsPortalException {
        try {
            if (options == null) {
                options = new HashMap<String, Object>();
            }
            return this.submitForm(this.getOptionsFromSubmitInfo(formSubmitInfo, options), this.getFormNodeFromPath(formSubmitInfo.getFormContainerPath()));
        }
        catch (RepositoryException e) {
            throw new FormsPortalException(e);
        }
    }

    protected byte[] getDorBytes(FormSubmitInfo formSubmitInfo) throws Exception {
        return IOUtils.toByteArray(formSubmitInfo.getDocumentOfRecord().getInputStream());
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }
}

