/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.upgradesexecutor;

import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.day.cq.compat.codeupgrade.CodeUpgradeTask;
import com.day.cq.compat.codeupgrade.CodeUpgradeTaskFilter;
import com.day.cq.compat.codeupgrade.MigrationModeCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.CollectionUtils;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.api.execution.HealthCheckExecutionResult;
import org.apache.sling.hc.api.execution.HealthCheckExecutor;
import org.apache.sling.installer.api.info.Resource;
import org.apache.sling.installer.api.info.ResourceGroup;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.launchpad.api.StartupHandler;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.settings.SlingSettingsService;
import org.apache.sling.startupfilter.StartupInfoProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String FORCE_UPGRADES_PATH = "/var/upgrade/status/upgradesExecutor.forceUpgrades";
    private ExecutionConditionCodeUpgradeTaskServiceTracker st;
    final List<CodeUpgradeTask> tasks = new ArrayList<CodeUpgradeTask>();
    private Set<String> cachedActiveResourceURLSet = new HashSet<String>();
    private static final int OSGI_INSTALLER_NO_ACTIVITY_TIMEOUT = 60000;
    private long cachedNoActivityOsgiInstallerTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        block22: {
            ServiceReference ref = context.getServiceReference(StartupHandler.class.getName());
            if (ref == null) {
                throw new IllegalStateException("StartupHandler not found, cannot decide whether to run upgrade code or not");
            }
            StartupHandler sh = (StartupHandler)context.getService(ref);
            StartupMode sm = sh.getMode();
            ServiceReference migCheckRef = context.getServiceReference(MigrationModeCheck.class.getName());
            ServiceTracker migCheckTracker = new ServiceTracker(context, migCheckRef, null);
            migCheckTracker.open();
            MigrationModeCheck checker = null;
            try {
                checker = (MigrationModeCheck)migCheckTracker.waitForService(120000L);
            }
            catch (Exception exception) {
            }
            finally {
                migCheckTracker.close();
            }
            if (checker == null) {
                this.log.error("Could not get MigrationModeCheck service, execution of CodeUpgradeTasks aborted");
                return;
            }
            boolean delayedMigrationActive = checker.isDelayedMigrationActive();
            if (!delayedMigrationActive && sm != StartupMode.UPDATE) {
                boolean force = false;
                ServiceReference repoRef = context.getServiceReference(SlingRepository.class.getName());
                if (repoRef != null) {
                    SlingRepository repo = (SlingRepository)context.getService(repoRef);
                    Session s = repo.loginAdministrative(repo.getDefaultWorkspace());
                    try {
                        Item it;
                        if (s.itemExists(FORCE_UPGRADES_PATH) && !(it = s.getItem(FORCE_UPGRADES_PATH)).isNode()) {
                            force = s.getProperty(FORCE_UPGRADES_PATH).getBoolean();
                            this.log.warn("{}=true will force upgrade code to run every time this bundle is started -  if this is not desired, remove that property", (Object)FORCE_UPGRADES_PATH);
                        }
                    }
                    finally {
                        s.logout();
                    }
                }
                if (force) {
                    this.log.info("StartupMode is {} but {} is true, executing upgrade tasks", (Object)sm, (Object)FORCE_UPGRADES_PATH);
                } else {
                    this.log.info("UPGRADE NOT NEEDED - StartupMode is {}", (Object)sm);
                    return;
                }
            }
            this.log.info("UPGRADE / Content Migration STARTS - StartupMode is {}", (Object)sm);
            InfoProvider ip = new InfoProvider();
            ServiceRegistration reg = null;
            try {
                reg = context.registerService(StartupInfoProvider.class.getName(), (Object)ip, null);
                ServiceReference slingInfoProviderServiceRef = context.getServiceReference(org.apache.sling.installer.api.info.InfoProvider.class.getName());
                org.apache.sling.installer.api.info.InfoProvider slingInfoProvider = slingInfoProviderServiceRef != null ? (org.apache.sling.installer.api.info.InfoProvider)context.getService(slingInfoProviderServiceRef) : null;
                this.st = new ExecutionConditionCodeUpgradeTaskServiceTracker(context);
                this.st.open();
                do {
                    Thread.sleep(1000L);
                    if (!this.st.isCodeUpgradeExecutionConditonSatisfied()) continue;
                    this.finishUpgradeExecution(context, ip);
                    break block22;
                } while (!this.timeout(slingInfoProvider));
                this.log.error("OSGI installer finished and the upgrade task condition was not satisfied. Executing installed upgrade tasks but most likely one of the mandatory upgrade tasks was not executed. Please check the log file.");
                this.finishUpgradeExecution(context, ip);
            }
            finally {
                if (reg != null) {
                    reg.unregister();
                }
                this.st.close();
            }
        }
    }

    private boolean timeout(org.apache.sling.installer.api.info.InfoProvider slingInfoProvider) throws InterruptedException {
        if (slingInfoProvider != null) {
            List<ResourceGroup> currentActiveResources = slingInfoProvider.getInstallationState().getActiveResources();
            Set<String> currentActiveResourceURLSet = this.extractResourceURLSet(currentActiveResources);
            if (CollectionUtils.isEqualCollection(currentActiveResourceURLSet, this.cachedActiveResourceURLSet)) {
                long currentTime = System.currentTimeMillis();
                if (this.cachedNoActivityOsgiInstallerTime == 0L) {
                    this.cachedNoActivityOsgiInstallerTime = currentTime;
                } else if (currentTime - this.cachedNoActivityOsgiInstallerTime > 60000L) {
                    return true;
                }
            } else {
                this.cachedNoActivityOsgiInstallerTime = 0L;
            }
            this.cachedActiveResourceURLSet = currentActiveResourceURLSet;
            return false;
        }
        this.log.error("Could not obtain OSGI installer state. Waiting 2 minutes for the upgrade tasks to install and then execute them.");
        Thread.sleep(120000L);
        return true;
    }

    private Set<String> extractResourceURLSet(List<ResourceGroup> currentActiveResources) {
        HashSet<String> resources = new HashSet<String>();
        for (ResourceGroup resourceGroup : currentActiveResources) {
            for (Resource resource : resourceGroup.getResources()) {
                resources.add(resource.getURL());
            }
        }
        return resources;
    }

    private void finishUpgradeExecution(BundleContext context, InfoProvider ip) {
        this.runUpgradeTasks(context, ip);
        this.invalidateCaches(context);
        this.executePostUpgradeHC(context);
        this.updateInstallPropertiesFile(context);
    }

    private void updateInstallPropertiesFile(BundleContext context) {
        File installFile;
        ServiceReference ref = context.getServiceReference(SlingSettingsService.class.getName());
        if (ref == null) {
            throw new IllegalStateException("SlingSettingsService not found.");
        }
        SlingSettingsService slingSettings = (SlingSettingsService)context.getService(ref);
        File confFolder = new File(slingSettings.getSlingHomePath(), "conf");
        File tmpInstallFile = new File(confFolder, "quickstart.properties_tmp");
        if (tmpInstallFile.exists() && (installFile = new File(confFolder, "quickstart.properties")).exists() && installFile.delete()) {
            tmpInstallFile.renameTo(installFile);
        }
    }

    private void executePostUpgradeHC(BundleContext context) {
        this.log.info("Start executing post-upgrade health checks.");
        ServiceReference ref = context.getServiceReference(HealthCheckExecutor.class.getName());
        if (ref == null) {
            throw new IllegalStateException("HealthCheckExecutor not found.");
        }
        HealthCheckExecutor healthCheckExecutor = (HealthCheckExecutor)context.getService(ref);
        for (HealthCheckExecutionResult healthCheckExecutionResult : healthCheckExecutor.execute("post-upgrade")) {
            Result result = healthCheckExecutionResult.getHealthCheckResult();
            String hcName = healthCheckExecutionResult.getHealthCheckMetadata().getName();
            if (!result.isOk()) {
                this.log.error("{} health check failed:", (Object)hcName);
                for (ResultLog.Entry logEntry : result) {
                    Result.Status status = logEntry.getStatus();
                    if (Result.Status.INFO == status || Result.Status.DEBUG == status) continue;
                    this.log.error(logEntry.getMessage());
                }
                continue;
            }
            this.log.info("{} health check ran successfully.", (Object)hcName);
        }
        this.log.info("Finished executing post-upgrade health checks.");
    }

    public void stop(BundleContext context) throws Exception {
        if (this.st != null) {
            this.st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpgradeTasks(BundleContext context, InfoProvider ip) {
        ip.say("Collecting CodeUpgradeTasks");
        try {
            Object[] filterRefs = context.getServiceReferences(CodeUpgradeTaskFilter.class.getName(), null);
            this.log.info("UPGRADE TASK FILTERS - {} {} services found", (Object)filterRefs.length, (Object)CodeUpgradeTaskFilter.class.getName());
            if (filterRefs != null && filterRefs.length > 0) {
                Arrays.sort(filterRefs);
            }
            LinkedList<CodeUpgradeTaskFilter> filters = new LinkedList<CodeUpgradeTaskFilter>();
            for (Object filterRef : filterRefs) {
                filters.add((CodeUpgradeTaskFilter)context.getService((ServiceReference)filterRef));
            }
            Object[] refs = context.getServiceReferences(CodeUpgradeTask.class.getName(), null);
            if (refs == null || refs.length < 1) {
                this.log.info("NO UPGRADE TASKS - no {} services found, nothing to do", (Object)CodeUpgradeTask.class.getName());
                return;
            }
            Arrays.sort(refs);
            ArrayList<CodeUpgradeTask> tasks = new ArrayList<CodeUpgradeTask>();
            for (Object ref : refs) {
                CodeUpgradeTask cut = (CodeUpgradeTask)context.getService((ServiceReference)ref);
                boolean isSkipped = false;
                Iterator filterIt = filters.iterator();
                while (filterIt.hasNext() && !isSkipped) {
                    CodeUpgradeTaskFilter filter = (CodeUpgradeTaskFilter)filterIt.next();
                    this.log.debug("Checking CodeUpgradeTask {} with CodeUpgradeTaskFilter {}", (Object)cut.getClass().getSimpleName(), (Object)filter.getClass().getSimpleName());
                    if (!(isSkipped |= filter.isSkipped(cut))) continue;
                    this.log.info("Skipped CodeUpgradeTask {} due to CodeUpgradeTaskFilter {}", (Object)cut.getClass().getSimpleName(), (Object)filter.getClass().getSimpleName());
                }
                if (isSkipped) continue;
                tasks.add(cut);
            }
            long startTime = System.currentTimeMillis();
            ip.say("Checking " + refs.length + " candidate CodeUpgradeTasks: " + tasks);
            int successful = 0;
            int failed = 0;
            int skipped = 0;
            for (CodeUpgradeTask t : tasks) {
                try {
                    if (t.upgradeNeeded()) {
                        ip.say("UPGRADE TASK STARTING: " + t);
                        ip.setTask(t);
                        t.run();
                        ip.setTask(null);
                        ip.say("UPGRADE TASK DONE: " + t);
                        ++successful;
                        continue;
                    }
                    ++skipped;
                    ip.say("UPGRADE TASK SKIPPED: " + t);
                }
                catch (RuntimeException e) {
                    ++failed;
                    ip.say("UPGRADE TASK FAILED: " + t);
                }
                finally {
                    ip.setTask(null);
                }
            }
            long elapsed = System.currentTimeMillis() - startTime;
            this.log.info("UPGRADE FINISHED: From a total of {} CodeUpgradeTasks: {} were successfully executed, {} failed and {} skipped. Total execution time about {} seconds", refs.length, successful, failed, skipped, elapsed / 1000L);
        }
        catch (InvalidSyntaxException e) {
            this.log.error("Could not get ServiceReferences", e);
        }
    }

    private void invalidateCaches(BundleContext context) {
        ServiceReference ref = context.getServiceReference(HtmlLibraryManager.class);
        if (ref != null) {
            HtmlLibraryManager mgr = (HtmlLibraryManager)context.getService(ref);
            try {
                mgr.invalidateOutputCache();
                this.log.info("Cleaned HtmlLibraryManager output cache.");
            }
            catch (RepositoryException e) {
                this.log.error("Can't clean HtmlLibraryManager output cache.");
            }
        } else {
            this.log.error("Reference to HtmlLibraryManager not found - couldn't clean output cache.");
        }
    }

    private class ExecutionConditionCodeUpgradeTaskServiceTracker<S, T>
    extends ServiceTracker<S, T> {
        private boolean codeUpgradeExecutionConditonSatisfied;

        public ExecutionConditionCodeUpgradeTaskServiceTracker(BundleContext context) {
            super(context, CodeUpgradeTask.class.getName(), null);
        }

        public T addingService(ServiceReference<S> reference) {
            Object service = super.addingService(reference);
            if ("com.day.cq.compat.codeupgrade.impl.ExecutionConditionCodeUpgradeTask".equals(service.getClass().getName())) {
                this.codeUpgradeExecutionConditonSatisfied = true;
            }
            return (T)service;
        }

        public boolean isCodeUpgradeExecutionConditonSatisfied() {
            return this.codeUpgradeExecutionConditonSatisfied;
        }
    }

    class InfoProvider
    implements StartupInfoProvider {
        private String progressInfo = "Initializing";
        private volatile CodeUpgradeTask task;

        InfoProvider() {
        }

        public String getProgressInfo() {
            if (this.task != null) {
                String info = this.task.getProgressInfo();
                if (info == null) {
                    info = "No info yet";
                }
                return "Running " + this.task + ": " + info;
            }
            return this.progressInfo;
        }

        void say(String info) {
            Activator.this.log.info(info);
            this.progressInfo = info;
        }

        void setTask(CodeUpgradeTask t) {
            this.task = t;
        }
    }
}

