/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.internal;

import com.adobe.cq.social.badging.api.UserBadge;
import com.adobe.cq.social.user.internal.UserProfileBadge;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class UserProfileBadgeImpl
implements UserProfileBadge {
    protected String id;
    protected String title;
    protected String imageUrl;
    protected String dateAssigned;
    protected boolean isAssigned;
    protected int earnedScore;
    private Resource userBadgeResource;
    protected final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    public UserProfileBadgeImpl() {
        this.id = null;
        this.title = null;
        this.imageUrl = null;
        this.dateAssigned = null;
        this.isAssigned = false;
        this.userBadgeResource = null;
        this.earnedScore = 0;
    }

    public UserProfileBadgeImpl(String title, String imageUrl, boolean isAssigned) {
        this(title, imageUrl, isAssigned, null);
    }

    public UserProfileBadgeImpl(String title, String imageUrl, boolean isAssigned, String dateAssigned) {
        this.id = imageUrl.substring(0, imageUrl.lastIndexOf("/"));
        this.title = title;
        this.imageUrl = imageUrl;
        this.dateAssigned = dateAssigned;
        this.isAssigned = isAssigned;
        this.earnedScore = 0;
        this.userBadgeResource = null;
    }

    public UserProfileBadgeImpl(UserBadge userBadge) {
        this();
        Resource badgeResource = this.getBaseBadgeResource(userBadge);
        if (badgeResource != null) {
            ValueMap badgeMap = badgeResource.adaptTo(ValueMap.class);
            this.userBadgeResource = userBadge.getResource();
            this.id = badgeResource.getPath();
            this.title = this.getBadgeDisplayName(badgeMap);
            this.imageUrl = badgeMap.get("image", "");
            ValueMap userBadgeMap = this.userBadgeResource.adaptTo(ValueMap.class);
            this.dateAssigned = this.getBadgeEarnedDate(userBadgeMap);
            this.isAssigned = userBadge.isAssigned();
            this.earnedScore = userBadgeMap.get("earnedScore", 0);
        }
    }

    private String getBadgeEarnedDate(ValueMap badgeMap) {
        if (badgeMap.containsKey("earnedDate_dt")) {
            Calendar calendar = (Calendar)badgeMap.get("earnedDate_dt");
            return this.dateFormat.format(calendar.getTime());
        }
        return "";
    }

    private String getBadgeDisplayName(ValueMap badgeMap) {
        String displayName = "";
        if (badgeMap.containsKey("displayName")) {
            displayName = badgeMap.get("displayName", "");
        } else if (badgeMap.containsKey("jcr:title")) {
            displayName = badgeMap.get("jcr:title", "");
        }
        return displayName;
    }

    private Resource getBaseBadgeResource(UserBadge userBadge) {
        String badgePath = userBadge.getBadgePath();
        Resource badgeResource = userBadge.getResource().getResourceResolver().getResource(badgePath);
        if (badgeResource != null && !badgeResource.getResourceType().equals("social/gamification/components/hbs/badgecollection/badge")) {
            badgeResource = badgeResource.getParent();
        }
        return badgeResource;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDateAssigned() {
        return this.dateAssigned;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    public boolean getIsAssigned() {
        return this.isAssigned;
    }

    @Override
    public int getEarnedScore() {
        return this.earnedScore;
    }

    @Override
    @JsonIgnore
    public Resource getUserBadgeResource() {
        return this.userBadgeResource;
    }
}

