/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.user.internal;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.community.api.CommunityUserGroup;
import com.adobe.cq.social.console.utils.api.UserUtils;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialAuthorizable;
import com.adobe.cq.social.scf.SocialGroup;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.community.CommunityUser;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.user.endpoints.impl.CommunityUserImpl;
import com.adobe.granite.security.user.UserPropertiesManager;
import com.day.cq.replication.ReplicationStatus;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunityAuthorizableManager {
    protected final UserManager userManager;
    protected final ClientUtilities clientUtils;
    protected final ResourceResolver resolver;
    protected final CommunityContext context;
    protected final String userResourceType;
    protected static final String DEFAULT_TYPE = "users";
    private static final String PROP_COMMUNITY_GROUP_INVITE = "invite";
    private final String delimiters = "[\\s,;]";
    private static final Logger LOG = LoggerFactory.getLogger(CommunityAuthorizableManager.class);
    protected final UserUtils userUtils;

    public CommunityAuthorizableManager(CommunityContext context, ClientUtilities clientUtils, ResourceResolver resolver) {
        this(context, clientUtils, resolver, "social/console/components/hbs/users/user", resolver.adaptTo(UserManager.class));
    }

    public CommunityAuthorizableManager(Resource resource, ClientUtilities clientUtils) {
        this(resource.adaptTo(CommunityContext.class), clientUtils, resource.getResourceResolver());
    }

    public CommunityAuthorizableManager(CommunityContext context, ClientUtilities clientUtils, ResourceResolver resourceResolver, String userResourceType, UserManager userManager) {
        this.userManager = userManager;
        this.resolver = resourceResolver;
        this.clientUtils = clientUtils;
        this.context = context;
        this.userUtils = this.resolver.adaptTo(UserUtils.class);
        this.userResourceType = userResourceType;
    }

    public List<CommunityUser> getCommunityUsers(CollectionPagination pagination, CollectionSortedOrder sortOrder) {
        if (this.userUtils == null) {
            return new ArrayList<CommunityUser>();
        }
        return this.getSocialAuthorizables(this.userUtils.getCommunityGroupName(this.context, CommunityUserGroup.MEMBER), pagination, sortOrder, null, DEFAULT_TYPE, false);
    }

    public List<?> getCommunityUsers(CollectionPagination pagination, CollectionSortedOrder sortOrder, Map<String, String[]> predicates, String type, String groupId, Boolean includeSubGroups) {
        if (groupId == null && this.userUtils == null) {
            return new ArrayList();
        }
        return this.getSocialAuthorizables(groupId != null ? groupId : this.userUtils.getGroupNamefromContext(this.context, CommunityUserGroup.MEMBER), pagination, sortOrder, predicates, type, includeSubGroups);
    }

    public List<?> getCommunityUsers(CollectionPagination pagination, CollectionSortedOrder sortOrder, Map<String, String[]> predicates, String type, String siteId, String groupId, Boolean includeSubGroups) {
        if (groupId == null && this.userUtils == null) {
            return new ArrayList();
        }
        return this.getSocialAuthorizables(groupId != null ? groupId : this.userUtils.getCommunitySiteGroupName(this.context, siteId, CommunityUserGroup.MEMBER), pagination, sortOrder, predicates, type, includeSubGroups);
    }

    protected SocialAuthorizable createSocialGroup(String authId) throws RepositoryException {
        SocialGroup group = this.clientUtils.getGroup(authId, this.resolver, "social/commons/components/group");
        return group;
    }

    public List<CommunityUser> getAdminUsers(CollectionPagination pagination, CollectionSortedOrder sortOrder) {
        if (this.userUtils == null) {
            return new ArrayList<CommunityUser>();
        }
        return this.getSocialAuthorizables(this.userUtils.getCommunityGroupName(this.context, CommunityUserGroup.ADMINISTRATOR), pagination, sortOrder, null, DEFAULT_TYPE, false);
    }

    public List<CommunityUser> getModeratorUsers(String siteId, CollectionPagination pagination, CollectionSortedOrder sortOrder) {
        if (siteId == null && this.userUtils == null) {
            return new ArrayList<CommunityUser>();
        }
        return this.getSocialAuthorizables(this.userUtils.getCommunitySiteGroupName(this.context, siteId, CommunityUserGroup.MODERATOR), pagination, sortOrder, null, DEFAULT_TYPE, false);
    }

    public List<CommunityUser> getGroupAdminUsers(String siteId, CollectionPagination pagination, CollectionSortedOrder sortOrder) {
        if (siteId == null || this.userUtils == null) {
            return new ArrayList<CommunityUser>();
        }
        return this.getSocialAuthorizables(this.userUtils.getCommunitySiteGroupName(this.context, siteId, CommunityUserGroup.GROUP_ADMIN), pagination, sortOrder, null, DEFAULT_TYPE, false);
    }

    public CommunityUser getUser(String userId) throws RepositoryException {
        return this.isValidAuthorizableId(userId) ? this.createCommunityUser(userId) : null;
    }

    private boolean isValidAuthorizableId(String userId) {
        Resource resource = this.resolver.getResource(this.context.getSitePath());
        Session session = this.resolver.adaptTo(Session.class);
        if (resource != null && session != null) {
            try {
                return this.userUtils.isValidAuthorizableId(resource, session, userId);
            }
            catch (OperationException e) {
                LOG.error("Failed to validate authorizable Id " + userId, e);
            }
        }
        return false;
    }

    public List<String> getGroupAdminUserIds(String siteId) {
        List<String> ids = new ArrayList<String>();
        Resource resource = this.resolver.getResource(this.context.getSitePath());
        Session session = this.resolver.adaptTo(Session.class);
        if (resource != null && session != null && this.userUtils != null) {
            try {
                ids = this.userUtils.getCommunitySiteUserGroupMemberIds(resource, CommunityUserGroup.GROUP_ADMIN, session, true);
            }
            catch (OperationException e) {
                LOG.error("Failed to get site {} group admin user Ids ", (Object)siteId, (Object)e);
            }
        }
        return ids;
    }

    protected CommunityUser createCommunityUser(String authId) throws RepositoryException {
        CommunityUser user = (CommunityUser)this.clientUtils.getUser(authId, this.resolver, this.userResourceType);
        return user;
    }

    protected User createSimpleUser(String authId) throws RepositoryException {
        User user = this.clientUtils.getUser(authId, this.resolver, this.userResourceType);
        return user;
    }

    protected List<?> getSocialAuthorizables(String groupName, CollectionPagination pagination, CollectionSortedOrder sortOrder, Map<String, String[]> predicates, String type, Boolean includeSubGroups) {
        ArrayList<SocialAuthorizable> users = new ArrayList<SocialAuthorizable>();
        try {
            String[] filters = null;
            if (predicates != null && predicates.containsKey("filter")) {
                filters = predicates.get("filter");
            }
            Class authorizable = null;
            if (type != null && (Type.USERS.getType().equalsIgnoreCase(type) || Type.SIMPLEUSERS.getType().equalsIgnoreCase(type))) {
                authorizable = org.apache.jackrabbit.api.security.user.User.class;
            } else if (type != null && Type.GROUPS.getType().equalsIgnoreCase(type)) {
                authorizable = Group.class;
            }
            Resource resource = this.resolver.resolve(this.context.getSitePath());
            Session session = this.resolver.adaptTo(Session.class);
            List<String> result = this.userUtils.getAuthorizableIds(groupName, pagination, sortOrder, authorizable, filters, includeSubGroups, resource, session);
            if (result != null && !result.isEmpty()) {
                for (String authId : result) {
                    User user;
                    if (authorizable == org.apache.jackrabbit.api.security.user.User.class) {
                        LOG.debug(authId);
                        user = Type.USERS.getType().equalsIgnoreCase(type) ? this.createCommunityUser(authId) : this.createSimpleUser(authId);
                        if (StringUtils.equals(user.getName(), "Unknown")) continue;
                        users.add(user);
                        continue;
                    }
                    if (authorizable == Group.class) {
                        LOG.debug(authId);
                        users.add(this.createSocialGroup(authId));
                        continue;
                    }
                    if (Type.USER_AND_GROUPS.getType().equalsIgnoreCase(type)) {
                        SocialAuthorizable socialAuthorizable = this.userUtils.isAuthorizableGroup(authId) ? this.createSocialGroup(authId) : this.createSimpleUser(authId);
                        if (socialAuthorizable == null) continue;
                        users.add(socialAuthorizable);
                        continue;
                    }
                    LOG.debug(authId);
                    user = this.createSimpleUser(authId);
                    if (StringUtils.equals(user.getName(), "Unknown")) continue;
                    users.add(user);
                }
            }
            if (Type.ALLUSERSGROUPS.getType().equalsIgnoreCase(type) || Type.GROUPS.getType().equalsIgnoreCase(type)) {
                users.add(0, this.createSocialGroup(groupName));
            }
            return users;
        }
        catch (RepositoryException e) {
            LOG.error("error fetching users", e);
            return users;
        }
        catch (OperationException e) {
            LOG.error("error fetching users", e);
            return users;
        }
        catch (LoginException e) {
            LOG.error("error fetching users", e);
            return users;
        }
    }

    private List<?> getMembersFromGroupAndConfig(CommunityUserGroup userGroup) {
        List<CommunityUser> users = new ArrayList<CommunityUser>();
        Resource resource = this.resolver.getResource(this.context.getSitePath());
        if (resource != null) {
            try {
                if (this.isPublished(resource) && CommunityUserGroup.ADMINISTRATOR != userGroup) {
                    users = this.userUtils.getCommunitySiteUserGroupMembers(resource, userGroup);
                } else {
                    this.getLocalConfigUsers(resource, users, userGroup.getName(), true);
                }
            }
            catch (OperationException e) {
                LOG.error("Error while fetching members from the group {}", (Object)userGroup, (Object)e);
            }
        }
        return users;
    }

    private boolean isPublished(Resource resource) {
        if (resource == null) {
            return false;
        }
        ReplicationStatus resourceReplicationStatus = resource.adaptTo(ReplicationStatus.class);
        Calendar modified = (Calendar)((Object)resource.getValueMap().get("jcr:lastModified", Calendar.class));
        Calendar lastPublished = resourceReplicationStatus.getLastPublished();
        return modified != null && lastPublished != null && modified.before(lastPublished);
    }

    private String[] getUserIds(ValueMap propMap, String groupName, boolean isMultiValue) {
        if (isMultiValue) {
            return (String[])propMap.get(groupName, String[].class);
        }
        String userlist = (String)((Object)propMap.get(groupName, String.class));
        if (StringUtils.isNotBlank(userlist)) {
            return userlist.split("[\\s,;]");
        }
        return new String[0];
    }

    public void getLocalConfigUsers(Resource resource, List<CommunityUser> users, String userGroupName, boolean isMultiValue) {
        ValueMap propMap = resource.adaptTo(ValueMap.class);
        UserPropertiesManager upm = resource.getResourceResolver().adaptTo(UserPropertiesManager.class);
        String[] configMembers = StringUtils.equals(userGroupName, CommunityUserGroup.ADMINISTRATOR.getName()) ? this.getUserIds(propMap, "admins", isMultiValue) : (StringUtils.equals(userGroupName, CommunityUserGroup.GROUP_ADMIN.getName()) ? (String[])propMap.get("groupAdmin", String[].class) : (StringUtils.equals(userGroupName, CommunityUserGroup.COMMUNITY_MANAGER.getName()) ? (String[])propMap.get("communitymanagers", String[].class) : (StringUtils.equals(userGroupName, CommunityUserGroup.PRIVILEGED_MEMBER.getName()) ? (String[])propMap.get("privilegedmembers", String[].class) : (StringUtils.equals(userGroupName, PROP_COMMUNITY_GROUP_INVITE) ? this.getUserIds(propMap, PROP_COMMUNITY_GROUP_INVITE, isMultiValue) : this.getUserIds(propMap, "moderators", isMultiValue)))));
        if (configMembers != null && configMembers.length > 0) {
            for (String configMemberUserId : configMembers) {
                try {
                    SyntheticResource userResource = new SyntheticResource(this.resolver, configMemberUserId, "social/console/components/hbs/users/user");
                    CommunityUserImpl user = new CommunityUserImpl((Resource)userResource, this.clientUtils, upm, null, null);
                    if (user == null) continue;
                    users.add((CommunityUser)user);
                }
                catch (RepositoryException e) {
                    LOG.error("Not able to create a fake user using synthetic resource", e);
                }
            }
        }
    }

    public List<CommunityUser> getGroupAdminUsers(String siteId) {
        return this.getMembersFromGroupAndConfig(CommunityUserGroup.GROUP_ADMIN);
    }

    public List<CommunityUser> getAdminUsers(String siteId) {
        return this.getMembersFromGroupAndConfig(CommunityUserGroup.ADMINISTRATOR);
    }

    public List<CommunityUser> getModeratorUsers(String siteId) {
        return this.getMembersFromGroupAndConfig(CommunityUserGroup.MODERATOR);
    }

    public List<CommunityUser> getComunityManagerUsers(String siteId) {
        return this.getMembersFromGroupAndConfig(CommunityUserGroup.COMMUNITY_MANAGER);
    }

    public List<CommunityUser> getPrivilegedMemberUsers(String siteId) {
        return this.getMembersFromGroupAndConfig(CommunityUserGroup.PRIVILEGED_MEMBER);
    }

    public static enum Type {
        USERS("users"),
        GROUPS("groups"),
        ALLUSERSGROUPS("allusersgroups"),
        SIMPLEUSERS("simpleusers"),
        USER_AND_GROUPS("userandgroups");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum Operations {
        LIKE("like"),
        EQUAL("equal"),
        CONTAINS("contains"),
        EXIST("exist"),
        FIND("find");

        private final String operation;

        private Operations(String operation) {
            this.operation = operation;
        }

        public String getOperation() {
            return this.operation;
        }
    }
}

