/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.translation;

import com.adobe.granite.translation.api.TranslationConfig;
import com.adobe.granite.translation.api.TranslationException;
import java.util.Map;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationVariables {
    private static final Logger LOG = LoggerFactory.getLogger(TranslationVariables.class);
    private static String clientID = "";
    private static String[] languageCode = new String[0];
    private static LEVEL level = LEVEL.COMMENT;
    private static DISPLAY display = DISPLAY.REPLACE;
    private static CACHE caching = CACHE.NO_CACHING;
    private static int cachingDuration = 1;
    private static long sessionSaveInterval = 2L;
    private static int translationSaveBatchLimit = 250;
    private static SEARCH search = SEARCH.NO_SEARCHING;
    private static boolean edit;
    private static boolean metrics;
    private static Map<String, String> resourcePropertyMappings;
    private static boolean enableAttribution;
    private static boolean enableSmartRendering;
    private static RENDER rendering;
    @Reference
    private static TranslationConfig translationConfig;

    @Deprecated
    public static void setClientID(String clientId) {
        clientID = clientId;
    }

    public static void setLanguageCode(String[] lanCode) {
        languageCode = lanCode;
    }

    public static void setLevel(LEVEL lvl) {
        level = lvl;
    }

    public static void setDisplay(DISPLAY dis) {
        display = dis;
    }

    public static void setCaching(CACHE cachingLevel) {
        caching = cachingLevel;
    }

    public static void setCachingDuration(int duration) {
        cachingDuration = duration;
    }

    public static void setSessionSaveInterval(long interval) {
        sessionSaveInterval = interval;
    }

    @Deprecated
    public static void setSearch(SEARCH searchOption) {
        search = searchOption;
    }

    @Deprecated
    public static void setEdit(boolean editOption) {
        edit = editOption;
    }

    @Deprecated
    public static boolean isEdit() {
        return edit;
    }

    @Deprecated
    public static boolean isMetrics() {
        return metrics;
    }

    public static boolean isEnableAttribution() {
        return enableAttribution;
    }

    @Deprecated
    public static void setMetrics(boolean metricsOption) {
        metrics = metricsOption;
    }

    public static void setEnableAttribution(boolean enabled) {
        enableAttribution = enabled;
    }

    @Deprecated
    public static String getClientID() {
        return clientID;
    }

    public static String[] getLanguageCode() {
        return languageCode;
    }

    public static String getLevel() {
        return level.getLeve();
    }

    public static String getDisplay() {
        return display.getDisplay();
    }

    @Deprecated
    public static String[][] getSupportedLanguages() {
        String[][] languages;
        int len = languageCode.length;
        if (len > 0) {
            languages = new String[len][2];
            for (int i = 0; i < len; ++i) {
                languages[i][0] = languageCode[i];
                languages[i][1] = TranslationVariables.getLanguageName(languageCode[i]);
            }
        } else {
            languages = new String[0][0];
        }
        return languages;
    }

    @Deprecated
    private static String getLanguageName(String langCode) {
        String strLangName = null;
        try {
            Map<String, String> languageCodeNames = translationConfig.getLanguages();
            strLangName = languageCodeNames.get(langCode);
        }
        catch (TranslationException te) {
            LOG.trace("Error getting language name for language code.", te);
        }
        return strLangName;
    }

    public static Map<String, String> getResourcePropertyMappings() {
        return resourcePropertyMappings;
    }

    public static void setResourcePropertyMappings(Map<String, String> rpMappings) {
        resourcePropertyMappings = rpMappings;
    }

    public static String getCaching() {
        return caching.getCache();
    }

    public static int getCachingDuration() {
        return cachingDuration;
    }

    public static long getSessionSaveInterval() {
        return sessionSaveInterval;
    }

    @Deprecated
    public static String getSearch() {
        return search.getSearch();
    }

    public static int getTranslationSaveBatchLimit() {
        return translationSaveBatchLimit;
    }

    public static void setTranslationSaveBatchLimit(int translationSaveBatchLimit) {
        TranslationVariables.translationSaveBatchLimit = translationSaveBatchLimit;
    }

    public static String getRendering() {
        return rendering.getRender();
    }

    public static void setRendering(RENDER renderlevel) {
        rendering = renderlevel;
    }

    public static boolean isEnableSmartRendering() {
        return enableSmartRendering;
    }

    public static void setEnableSmartRendering(boolean enabled) {
        enableSmartRendering = enabled;
    }

    static {
        rendering = RENDER.OFF;
    }

    public static enum RENDER {
        OFF("false"),
        ON("true"),
        LOGGED_IN_USER("logged_in_user");

        private final String render;

        private RENDER(String renderOption) {
            this.render = renderOption;
        }

        public String getRender() {
            return this.render;
        }
    }

    @Deprecated
    public static enum SEARCH {
        NO_SEARCHING("no_searching"),
        ONE_INDEX("one_index"),
        SEPERATE_INDEX("separate_index");

        private final String search;

        private SEARCH(String searchOption) {
            this.search = searchOption;
        }

        public String getSearch() {
            return this.search;
        }
    }

    public static enum CACHE {
        NO_CACHING("no_caching"),
        CACHE_WHEN_POST("cache_when_post"),
        CACHE_WHEN_CALL("cache_when_call");

        private final String cache;

        private CACHE(String cacheOption) {
            this.cache = cacheOption;
        }

        public String getCache() {
            return this.cache;
        }
    }

    public static enum DISPLAY {
        SIDE("side"),
        REPLACE("replace");

        private final String display;

        private DISPLAY(String dis) {
            this.display = dis;
        }

        public String getDisplay() {
            return this.display;
        }
    }

    public static enum LEVEL {
        COMMENT("comment"),
        THREAD("thread");

        private final String level;

        private LEVEL(String lvl) {
            this.level = lvl;
        }

        String getLeve() {
            return this.level;
        }
    }
}

