/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.tally.client.api;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.tally.Liking;
import com.adobe.cq.social.tally.client.api.AbstractTally;
import com.adobe.cq.social.tally.client.api.Like;
import com.adobe.cq.social.tally.client.api.LikingSocialComponent;
import com.adobe.cq.social.tally.client.api.Response;
import com.adobe.cq.social.tally.client.api.TallyException;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;

public class AbstractLiking
extends AbstractTally
implements LikingSocialComponent {
    private Liking likingComponent;

    public AbstractLiking(Resource resource) {
        this(resource, null);
    }

    public AbstractLiking(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.initComponent();
    }

    private void initComponent() {
        this.likingComponent = this.getResource().adaptTo(Liking.class);
        this.tally = this.likingComponent;
    }

    @Override
    public long getLikeCount() {
        return this.likingComponent.getLikeCount();
    }

    @Override
    public boolean isCurrentUserLike() {
        try {
            if (this.clientUtils.userIsAnonymous()) {
                return false;
            }
            Response resp = this.likingComponent.getUserResponse(this.currentUser);
            if (resp == null) {
                return false;
            }
            return Like.LIKE.equals(resp.getResponseValue());
        }
        catch (RepositoryException e) {
            return false;
        }
        catch (TallyException e) {
            return false;
        }
    }
}

