/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FacetResults {
    private Map<String, Object> facetFieldsFromResults;
    private final List<Map<String, Object>> documents;
    private Map<String, Object> facetAggregations;
    private final List<String> facetFields;
    private Map<String, Map<String, FacetPivotResults>> pivotAggregations;
    private final List<String> facetPivotFields;

    public FacetResults(List<Map<String, Object>> docs, List<String> facetFields, List<String> pivotFields, Map<String, Object> facetFieldsFromResults, Map<String, Object> facetPivotFromResults) {
        this.documents = docs;
        this.facetFields = facetFields;
        this.facetPivotFields = pivotFields;
        this.facetFieldsFromResults = facetFields != null && !facetFields.isEmpty() ? facetFieldsFromResults : Collections.emptyMap();
        if (pivotFields != null && !pivotFields.isEmpty()) {
            this.pivotAggregations = this.getForEachFacetPivotField(pivotFields, facetPivotFromResults);
        }
    }

    private Map<String, Map<String, FacetPivotResults>> getForEachFacetPivotField(List<String> pivotFields, Map<String, Object> facetPivotNode) {
        HashMap<String, Map<String, FacetPivotResults>> pivotAggregate = new HashMap<String, Map<String, FacetPivotResults>>();
        for (String facetPivotField : pivotFields) {
            Object[] facetPivotResults = (Object[])facetPivotNode.get(facetPivotField);
            pivotAggregate.put(facetPivotField, this.getPivot(facetPivotField, facetPivotResults));
        }
        return pivotAggregate;
    }

    private Map<String, FacetPivotResults> getPivot(String pivotField, Object[] pivotArray) {
        HashMap<String, FacetPivotResults> pivotAggregate = new HashMap<String, FacetPivotResults>();
        int numOfResults = pivotArray == null ? 0 : pivotArray.length;
        for (int i = 0; i < numOfResults; ++i) {
            Map result = (Map)pivotArray[i];
            String value = (String)result.get("value");
            Object c = result.get("count");
            Integer count = 0;
            if (c instanceof Long) {
                count = ((Long)c).intValue();
            } else if (c instanceof Integer) {
                count = (Integer)c;
            }
            Object[] pivot = (Map[])result.get("pivot");
            if (pivot == null) {
                pivotAggregate.put(value, new FacetPivotResults(value, count, null));
                continue;
            }
            pivotAggregate.put(value, new FacetPivotResults(value, count, this.getPivot(StringUtils.substringAfter(pivotField, ","), pivot)));
        }
        return pivotAggregate;
    }

    public Map<String, Object> getPivotAggregation() {
        return this.getPivotAggregation(this.facetPivotFields.get(0));
    }

    public Map<String, Object> getPivotAggregation(String fpf) {
        Map<String, FacetPivotResults> pivotList = this.pivotAggregations.get(fpf);
        HashMap<String, Object> pivotAggregate = new HashMap<String, Object>();
        if (pivotList != null) {
            for (Map.Entry<String, FacetPivotResults> entry : pivotList.entrySet()) {
                pivotAggregate.put(entry.getKey(), this.pivotToMap(entry.getValue().getPivot()));
            }
        }
        return pivotAggregate;
    }

    public Map<String, Integer> getPivotAggregation(String fpf, List<String> fieldsFilter) {
        String[] fields = StringUtils.split(fpf, ",");
        Map<String, FacetPivotResults> pivotList = this.pivotAggregations.get(fpf);
        if (pivotList != null && fieldsFilter != null && fieldsFilter.size() < fields.length) {
            Map<String, FacetPivotResults> pivot = pivotList;
            boolean found = true;
            for (String filter : fieldsFilter) {
                FacetPivotResults result = pivot.get(filter);
                if (!result.getValue().equalsIgnoreCase(filter)) {
                    found = false;
                    break;
                }
                pivot = result.getPivot();
            }
            if (found) {
                return this.pivotToMap(pivot);
            }
        }
        return Collections.emptyMap();
    }

    private Map<String, Integer> pivotToMap(Map<String, FacetPivotResults> listOfResults) {
        HashMap<String, Integer> aggregate = new HashMap<String, Integer>();
        for (Map.Entry<String, FacetPivotResults> entry : listOfResults.entrySet()) {
            aggregate.put(entry.getKey(), entry.getValue().getCount());
        }
        return aggregate;
    }

    public Map<String, Object> getAggregation() {
        if (this.facetAggregations == null) {
            this.facetAggregations = new HashMap<String, Object>();
            for (String field : this.facetFields) {
                Object[] fieldValues = (Object[])this.facetFieldsFromResults.get(field);
                if (fieldValues == null) continue;
                for (int i = 0; i < fieldValues.length; i += 2) {
                    this.facetAggregations.put((String)fieldValues[i], fieldValues[i + 1]);
                }
            }
        }
        return this.facetAggregations;
    }

    public List<Map<String, Object>> getDocs() {
        return this.documents;
    }

    public static FacetResults emptyResults() {
        return new FacetResults(Collections.<Map<String, Object>>emptyList(), Collections.<String>emptyList(), Collections.<String>emptyList(), Collections.<String, Object>emptyMap(), Collections.<String, Object>emptyMap());
    }

    private static class FacetPivotResults {
        private final String value;
        private final Integer count;
        private final Map<String, FacetPivotResults> pivot;

        FacetPivotResults(String value, Integer count, Map<String, FacetPivotResults> pivot) {
            this.value = value;
            this.count = count;
            this.pivot = pivot;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getCount() {
            return this.count;
        }

        public Map<String, FacetPivotResults> getPivot() {
            return this.pivot;
        }
    }
}

