/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.srp.internal;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaMapper {
    public static final String AS_ACCEPTFILETYPES = "acceptFileTypes";
    public static final String AS_ALLOWFILEUPLOADS = "allowFileUploads";
    public static final String AS_ALLOW_REPLIES = "allowRepliesToComments";
    public static final String AS_APPROVED = "approved_b";
    public static final String AS_AUTHOR = "author_username";
    public static final String AS_AUTHORIZABLE_ID = "authorizableId_t";
    public static final String AS_AUTHOR_DISPLAY_NAME = "author_display_name";
    public static final String AS_AUTHOR_DISPLAY_NAME_CI = "author_display_name_ci";
    public static final String AS_AUTHOR_PROFILE_URL = "author_profile_url";
    public static final String AS_AUTHOR_CI = "author_username_ci";
    public static final String AS_AUTHOR_IMAGE_URL = "author_image_url";
    public static final String AS_BASE_TYPE = "base_type_s";
    public static final String AS_IS_CLOSED = "is_closed_b";
    public static final String AS_COMPANY_ID = "company_db_id";
    public static final String AS_COMPOSED_BY = "composedBy_t";
    public static final String AS_CQ_DATA = "cqdata";
    public static final String AS_CQTAGS = "cqtags_ss";
    public static final String AS_CREATED = "timestamp";
    public static final String AS_ENTITY_URL = "entity_url";
    public static final String AS_FEATURES = "features";
    public static final String AS_ID = "_id";
    public static final String AS_IS_DRAFT = "is_draft_b";
    public static final String AS_IS_FLAGGED = "is_flagged_b";
    public static final String AS_IS_FLAGGED_HIDDEN = "is_flaggedHidden_b";
    public static final String AS_IS_REPLY = "is_reply_b";
    public static final String AS_MAXFILESIZE = "maxFileSize";
    public static final String AS_MAXIMAGEFILESIZE = "maxImageFileSize";
    public static final String AS_MODERATE_COMMENTS = "moderateComments";
    public static final String AS_PARENT_ID = "parent_id_s";
    public static final String AS_PINNED = "pinned_b";
    public static final String AS_PROVIDER_ID = "provider_id";
    public static final String AS_PUBLISH_DATE = "publishDate_dt";
    public static final String AS_PUBLISH_JOB_ID = "publishJobId_s";
    public static final String AS_REPORT_SUITE = "report_suite";
    public static final String AS_REQUIRELOGIN = "requireLogin";
    public static final String AS_RESOURCE_TYPE = "resource_type_s";
    public static final String AS_ROOT_COMMENT_SYSTEM = "thread_id_s";
    public static final String AS_RTEENABLED = "rteEnabled";
    public static final String AS_TALLY_RESPONSE = "response_s";
    public static final String AS_TITLE = "title_t";
    public static final String AS_VERBATIM = "verbatim";
    public static final String AS_VERBATIM_LANGUAGE_INDEX = "verbatim_";
    public static final String AS_ATTACHMENT_LENGTH = "length";
    public static final String AS_UPLOADDATE = "uploadDate";
    public static final String AS_ADDRESS = "address_s";
    public static final String SOLR_ID = "id";
    public static final String AS_SENTIMENT = "sentiment";
    public static final String AS_CONTENT_TYPE = "content-type";
    public static final String AS_ATTACHMENT = "attachment";
    public static final String AS_VERB = "verb_s";
    public static final String AS_ACTOR_ID = "actorid_s";
    public static final String AS_MENTIONS = "mentions_ss";
    private static final String CQ_ACCEPTFILETYPES = "acceptFileTypes";
    public static final String CQ_ADDED = "added";
    public static final String CQ_ALLOWFILEUPLOADS = "allowFileUploads";
    public static final String CQ_ALLOW_REPLIES = "allowRepliesToComments";
    public static final String CQ_APPROVED = "approved";
    public static final String CQ_AUTHORIZABLE_ID = "authorizableId";
    public static final String CQ_AUTHOR_IMAGE_URL = "author_image_url";
    public static final String CQ_AUTHOR_PROFILE_URL = "author_profile_url";
    public static final String CQ_AUTHOR_DISPLAY_NAME = "author_display_name";
    public static final String CQ_AUTHOR_EMAIL = "author_display_name";
    public static final String CQ_BASE_TYPE = "social:baseType";
    public static final String CQ_COMPOSED_BY = "composedBy";
    public static final String CQ_DRAFT = "isDraft";
    public static final String CQ_IS_CLOSED = "isClosed";
    public static final String CQ_ENTITY_URL = "entity_url";
    public static final String CQ_IS_FLAGGED = "isFlagged";
    public static final String CQ_FLAGGED_HIDDEN = "isFlaggedHidden";
    public static final String CQ_IS_REPLY = "social:isReply";
    public static final String CQ_KEY = "social:key";
    public static final String CQ_MAXFILESIZE = "maxFileSize";
    public static final String CQ_MAXIMAGEFILESIZE = "maxImageFileSize";
    public static final String CQ_MODERATE_COMMENTS = "moderateComments";
    public static final String CQ_PARENT_ID = "social:parentid";
    public static final String CQ_PINNED = "pinned";
    public static final String CQ_PUBLISH_DATE = "publishDate";
    public static final String CQ_PUBLISH_JOB_ID = "publishJobId";
    public static final String CQ_REQUIRELOGIN = "requireLogin";
    public static final String CQ_RESOURCE_TYPE = "sling:resourceType";
    public static final String CQ_ROOT_COMMENT_SYSTEM = "social:rootCommentSystem";
    public static final String CQ_RTEENABLED = "rteEnabled";
    public static final String CQ_SPAM = "isSpam";
    public static final String CQ_TAGS = "cq:tags";
    public static final String CQ_TALLY_RESPONSE = "response";
    public static final String CQ_TALLY_TIMESTAMP = "timestamp";
    public static final String CQ_TITLE = "jcr:title";
    public static final String CQ_USER_IDENTIFIER = "userIdentifier";
    public static final String CQ_DESCRIPTION = "jcr:description";
    public static final String CQ_LAST_MODIFIED = "cq:lastModified";
    public static final String CQ_SENTIMENT = "sentiment";
    public static final String CQ_MENTIONS = "mentions";
    public static final String CQ_ATTACHMENT = "nt:file";
    public static final String CQ_CONTENT_TYPE = "mimetype";
    public static final String CQ_SEARCH_PATH = ":path";
    public static final String CQ_SEARCH_TAG_NAME = "cq:tags";
    public static final String CQ_SEARCH_PARENT_ID = ":parent";
    public static final String CQ_MT_TRANS_DATE = "translationDate";
    public static final String CQ_MT_TRANSLATION = "translation";
    protected static final String CQ_MT_LANGAUGE = "mtlanguage";
    public static final String CQ_AS_VERB = "verb";
    public static final String CQ_AS_ACTOR_ID = "actorId";
    private static final String SEARCHABLE_SUFFIX = "s|ss|t|ts|b|bs|i|is|tl|tls|f|fs|d|ds|dt|dts|tf|tfs|td|tds|tdt|tdts|latlong|latlongs|tg|tgs|en|ens|ja|jas";
    private static final String SUFFIX_PATTERN = "([^\\s]+(\\_(?i)(s|ss|t|ts|b|bs|i|is|tl|tls|f|fs|d|ds|dt|dts|tf|tfs|td|tds|tdt|tdts|latlong|latlongs|tg|tgs|en|ens|ja|jas))$)";
    private static final Pattern PATTERN = Pattern.compile("([^\\s]+(\\_(?i)(s|ss|t|ts|b|bs|i|is|tl|tls|f|fs|d|ds|dt|dts|tf|tfs|td|tds|tdt|tdts|latlong|latlongs|tg|tgs|en|ens|ja|jas))$)");
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String CQ_DATE_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSchemaMapper.class);
    private final Set<String> CQ_ATTACHMENT_KEYS;
    private final Set<String> AS_ATTACHMENT_KEYS;
    private final Map<String, String> TOP_LEVEL_TO_SCHEMA_KEYS;
    private final Map<String, String> TOP_LEVEL_TO_CQ_KEYS = new HashMap<String, String>();
    private final Map<String, String> TRANSLATION_TO_SCHEMA_KEYS;
    private static final List<String> SUBHASH_DATE_FIELDS = Arrays.asList("cq:lastModified", "timestamp", "translationDate", "jcr:created", "jcr:lastModified");
    public static final String AS_CQ_SUBHASH_DATE = "SRP_CQ_SUBHASH_123098_DATE_";

    public AbstractSchemaMapper() {
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_APPROVED, CQ_APPROVED);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_CQTAGS, "cq:tags");
        this.TOP_LEVEL_TO_CQ_KEYS.put("timestamp", CQ_ADDED);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_IS_DRAFT, CQ_DRAFT);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_PINNED, CQ_PINNED);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_RESOURCE_TYPE, CQ_RESOURCE_TYPE);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_TITLE, CQ_TITLE);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_PARENT_ID, CQ_PARENT_ID);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_PROVIDER_ID, CQ_KEY);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_AUTHOR, CQ_USER_IDENTIFIER);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_AUTHORIZABLE_ID, CQ_AUTHORIZABLE_ID);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_COMPOSED_BY, CQ_COMPOSED_BY);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_ROOT_COMMENT_SYSTEM, CQ_ROOT_COMMENT_SYSTEM);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_TALLY_RESPONSE, CQ_TALLY_RESPONSE);
        this.TOP_LEVEL_TO_CQ_KEYS.put("author_image_url", "author_image_url");
        this.TOP_LEVEL_TO_CQ_KEYS.put("author_profile_url", "author_profile_url");
        this.TOP_LEVEL_TO_CQ_KEYS.put("author_display_name", "author_display_name");
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_BASE_TYPE, CQ_BASE_TYPE);
        this.TOP_LEVEL_TO_CQ_KEYS.put("entity_url", "entity_url");
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_IS_REPLY, CQ_IS_REPLY);
        this.TOP_LEVEL_TO_CQ_KEYS.put("moderateComments", "moderateComments");
        this.TOP_LEVEL_TO_CQ_KEYS.put("allowRepliesToComments", "allowRepliesToComments");
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_IS_CLOSED, CQ_IS_CLOSED);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_IS_FLAGGED, CQ_IS_FLAGGED);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_IS_FLAGGED_HIDDEN, CQ_FLAGGED_HIDDEN);
        this.TOP_LEVEL_TO_CQ_KEYS.put("allowFileUploads", "allowFileUploads");
        this.TOP_LEVEL_TO_CQ_KEYS.put("maxFileSize", "maxFileSize");
        this.TOP_LEVEL_TO_CQ_KEYS.put("acceptFileTypes", "acceptFileTypes");
        this.TOP_LEVEL_TO_CQ_KEYS.put("rteEnabled", "rteEnabled");
        this.TOP_LEVEL_TO_CQ_KEYS.put("requireLogin", "requireLogin");
        this.TOP_LEVEL_TO_CQ_KEYS.put("maxImageFileSize", "maxImageFileSize");
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_PUBLISH_DATE, CQ_PUBLISH_DATE);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_PUBLISH_JOB_ID, CQ_PUBLISH_JOB_ID);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_ACTOR_ID, CQ_AS_ACTOR_ID);
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_VERB, CQ_AS_VERB);
        this.TOP_LEVEL_TO_CQ_KEYS.put("sentiment", "sentiment");
        this.TOP_LEVEL_TO_CQ_KEYS.put(AS_MENTIONS, CQ_MENTIONS);
        Map<String, String> mapperKeys = this.getMapperSpecificKeys();
        this.TOP_LEVEL_TO_CQ_KEYS.putAll(mapperKeys);
        this.TOP_LEVEL_TO_SCHEMA_KEYS = new HashMap<String, String>(this.TOP_LEVEL_TO_CQ_KEYS.size());
        for (Map.Entry<String, String> entry : this.TOP_LEVEL_TO_CQ_KEYS.entrySet()) {
            this.TOP_LEVEL_TO_SCHEMA_KEYS.put(entry.getValue(), entry.getKey());
        }
        this.AS_ATTACHMENT_KEYS = new HashSet<String>();
        this.AS_ATTACHMENT_KEYS.add(AS_CONTENT_TYPE);
        this.AS_ATTACHMENT_KEYS.add(AS_ATTACHMENT);
        this.AS_ATTACHMENT_KEYS.add(AS_PROVIDER_ID);
        this.AS_ATTACHMENT_KEYS.add(AS_UPLOADDATE);
        this.CQ_ATTACHMENT_KEYS = new HashSet<String>();
        this.CQ_ATTACHMENT_KEYS.add(CQ_CONTENT_TYPE);
        this.CQ_ATTACHMENT_KEYS.add(CQ_ATTACHMENT);
        this.TRANSLATION_TO_SCHEMA_KEYS = new HashMap<String, String>();
        this.updateTranslationSchemaKeys(this.TRANSLATION_TO_SCHEMA_KEYS);
    }

    protected void updateTranslationSchemaKeys(Map<String, String> translationSchmeKeys) {
    }

    public abstract Map<String, String> getMapperSpecificKeys();

    public abstract String getReportSuite();

    public abstract void setReportSuite(String var1);

    public static String getSchemaDescriptionKey() {
        return AS_VERBATIM;
    }

    public static String getSchemaResourceTypeKey() {
        return AS_RESOURCE_TYPE;
    }

    public static String getSchemaRootCommentSystemKey() {
        return AS_ROOT_COMMENT_SYSTEM;
    }

    public static String getSocoAuthorDisplayNameKey() {
        return "author_display_name";
    }

    public static String getSocoAuthorImageUrlKey() {
        return "author_image_url";
    }

    public static String getSocoAuthorProfileUrlKey() {
        return "author_profile_url";
    }

    public static String getSocoEntityUrlKey() {
        return "entity_url";
    }

    public static String getSocoApprovedKey() {
        return CQ_APPROVED;
    }

    public static String getSocoFlaggedHiddenKey() {
        return CQ_FLAGGED_HIDDEN;
    }

    public static String getSocoDraftKey() {
        return CQ_DRAFT;
    }

    public static String getSchemaApprovedKey() {
        return AS_APPROVED;
    }

    public static String getSchemaFlaggedHiddenKey() {
        return AS_IS_FLAGGED_HIDDEN;
    }

    public static String getSchemaIsDraftKey() {
        return AS_IS_DRAFT;
    }

    public static String getSchemaParentIdKey() {
        return AS_PARENT_ID;
    }

    public static String getSchemaProviderIdKey() {
        return AS_PROVIDER_ID;
    }

    public static String getSchemaTimestampKey() {
        return "timestamp";
    }

    public static String getSchemaAttachmentLengthKey() {
        return AS_ATTACHMENT_LENGTH;
    }

    public static String getSchemaAttachmentUploadDateKey() {
        return AS_UPLOADDATE;
    }

    public static String getSocoAddedKey() {
        return CQ_ADDED;
    }

    public static String getSocoParentIdKey() {
        return CQ_PARENT_ID;
    }

    public static String getSocoTallyTimestampKey() {
        return "timestamp";
    }

    public static String getSocoLastModifiedKey() {
        return CQ_LAST_MODIFIED;
    }

    public static String getSchemaAttachmentKey() {
        return AS_ATTACHMENT;
    }

    public static String getSocoKey() {
        return CQ_KEY;
    }

    public static String getSocoDescriptionKey() {
        return CQ_DESCRIPTION;
    }

    public static String escapeForSolr(String base) {
        return StringUtils.replace(base, ":", "\\:");
    }

    public static String getUserDatePrefix() {
        return AS_CQ_SUBHASH_DATE;
    }

    public static String getSchemaBaseType() {
        return AS_BASE_TYPE;
    }

    public static String getBaseType() {
        return CQ_BASE_TYPE;
    }

    public static String getSchemaCQData() {
        return AS_CQ_DATA;
    }

    public static String getTranslationFolderName() {
        return CQ_MT_TRANSLATION;
    }

    private static Long toSchemaDate(String key, Map<String, Object> asMap) {
        Object time = asMap.get(key);
        if (time instanceof Date) {
            return ((Date)time).getTime();
        }
        if (time instanceof Calendar) {
            return ((Calendar)time).getTimeInMillis();
        }
        if (time == null) {
            LOGGER.error("Date property {} doesn't exist or is null. Dropping it.", (Object)key);
            return null;
        }
        LOGGER.error("Date property {} in unexpected format. Dropping it. Timestamp: {}. Class: {}", key, time, time.getClass());
        return null;
    }

    private static Long toSchemaDate(Object time) {
        if (time instanceof Date) {
            return ((Date)time).getTime();
        }
        if (time instanceof Calendar) {
            return ((Calendar)time).getTimeInMillis();
        }
        if (time == null) {
            return null;
        }
        return null;
    }

    private static void spamFlagsToSchema(Map<String, Object> cqMap, Map<String, Object> asMap) {
        Boolean spam = (Boolean)cqMap.get(CQ_SPAM);
        Boolean approved = (Boolean)cqMap.get(CQ_APPROVED);
        if (spam == null && approved == null) {
            return;
        }
        if (spam != null) {
            asMap.put(AS_APPROVED, spam == false);
        } else {
            asMap.put(AS_APPROVED, approved);
        }
    }

    private void setSolrId(Map<String, Object> cqFormat, String key, Map<String, Object> asMap) {
        String solrId = (String)cqFormat.get(SOLR_ID);
        if (solrId == null || solrId.isEmpty()) {
            LOGGER.trace("Mandatory unique solr id field is missing for provider_id={}", (Object)key);
            asMap.put(SOLR_ID, key);
        }
    }

    public Map<String, Object> toSchema(Map<String, Object> cqFormat, String key) {
        Object timestamp;
        HashMap<String, Object> asMap = new HashMap<String, Object>();
        HashMap<String, Object> cqDataMap = new HashMap<String, Object>();
        boolean bTranslationProcessingRequired = this.isTranslationProcessingRequired(key);
        String strTranslationLanguageKey = null;
        if (cqFormat.containsKey("timestamp") && !cqFormat.containsKey(AbstractSchemaMapper.getSocoAddedKey())) {
            if (!(cqFormat.get("timestamp") instanceof Calendar)) {
                timestamp = (String)cqFormat.get("timestamp");
                SimpleDateFormat dateFormat = new SimpleDateFormat(CQ_DATE_FORMAT);
                try {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(dateFormat.parse((String)timestamp));
                    cqFormat.put(AbstractSchemaMapper.getSocoAddedKey(), cal);
                }
                catch (ParseException e) {
                    LOGGER.error("Could not parse timestamp. Dropping it. Key: {}, timestamp: {}", (Object)key, timestamp);
                }
            } else {
                cqFormat.put(AbstractSchemaMapper.getSocoAddedKey(), cqFormat.get("timestamp"));
            }
        }
        AbstractSchemaMapper.spamFlagsToSchema(cqFormat, asMap);
        for (Map.Entry<String, Object> entry : cqFormat.entrySet()) {
            Object obj;
            if (bTranslationProcessingRequired && this.TRANSLATION_TO_SCHEMA_KEYS.containsKey(entry.getKey())) {
                if (strTranslationLanguageKey == null) {
                    strTranslationLanguageKey = this.getTranslationLanguageFromKey(key);
                }
                String strNewKey = this.TRANSLATION_TO_SCHEMA_KEYS.get(entry.getKey()) + strTranslationLanguageKey;
                asMap.put(strNewKey, entry.getValue());
                continue;
            }
            if (this.TOP_LEVEL_TO_SCHEMA_KEYS.containsKey(entry.getKey())) {
                if (entry.getKey().equals(CQ_APPROVED)) continue;
                if (entry.getKey().equals(CQ_PUBLISH_DATE)) {
                    asMap.put(this.TOP_LEVEL_TO_SCHEMA_KEYS.get(entry.getKey()), AbstractSchemaMapper.toSchemaDate(entry.getValue()));
                    continue;
                }
                asMap.put(this.TOP_LEVEL_TO_SCHEMA_KEYS.get(entry.getKey()), entry.getValue());
                continue;
            }
            if (entry.getKey().equals(CQ_SPAM)) continue;
            Matcher matcher = PATTERN.matcher(entry.getKey());
            if (matcher.matches()) {
                obj = entry.getValue();
                if (obj instanceof Calendar || obj instanceof Date) {
                    asMap.put(entry.getKey(), AbstractSchemaMapper.toSchemaDate(entry.getKey(), cqFormat));
                    continue;
                }
                if (obj instanceof Calendar[] || obj instanceof Date[]) {
                    LOGGER.debug("toSchema Cal/Date array {} - {}", (Object)entry.getKey(), entry.getValue());
                    int len = ((Object[])obj).length;
                    Long[] milisArray = new Long[len];
                    for (int i = 0; i < len; ++i) {
                        milisArray[i] = AbstractSchemaMapper.toSchemaDate(((Object[])obj)[i]);
                    }
                    asMap.put(entry.getKey(), milisArray);
                    continue;
                }
                asMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            if ("$inc".equals(entry.getKey()) && entry.getValue() instanceof Map) {
                Map incMap = (Map)entry.getValue();
                HashMap mainIncMap = new HashMap();
                HashMap subIncMap = new HashMap();
                for (Map.Entry incEntry : incMap.entrySet()) {
                    if (this.TOP_LEVEL_TO_SCHEMA_KEYS.containsKey(incEntry.getKey())) {
                        mainIncMap.put(this.TOP_LEVEL_TO_SCHEMA_KEYS.get(incEntry.getKey()), incEntry.getValue());
                        continue;
                    }
                    Matcher incMatcher = PATTERN.matcher((CharSequence)incEntry.getKey());
                    if (incMatcher.matches()) {
                        mainIncMap.put((String)incEntry.getKey(), incEntry.getValue());
                        continue;
                    }
                    subIncMap.put(incEntry.getKey(), incEntry.getValue());
                }
                if (!mainIncMap.isEmpty()) {
                    asMap.put("$inc", mainIncMap);
                }
                if (subIncMap.isEmpty()) continue;
                cqDataMap.put("$inc", subIncMap);
                continue;
            }
            if (entry.getKey().indexOf(AS_VERBATIM_LANGUAGE_INDEX) == 0) {
                LOGGER.trace("Adding {} to hash.", (Object)entry.getKey());
                asMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            LOGGER.trace("Adding {} to sub hash.", (Object)entry.getKey());
            obj = entry.getValue();
            String fieldName = entry.getKey();
            if (obj instanceof Calendar || obj instanceof Date) {
                LOGGER.debug("Have date/calendar field: {}", (Object)fieldName);
                Long tstamp = AbstractSchemaMapper.toSchemaDate(fieldName, Collections.singletonMap(fieldName, obj));
                if (tstamp != null) {
                    if (SUBHASH_DATE_FIELDS.contains(fieldName)) {
                        cqDataMap.put(fieldName, tstamp);
                        continue;
                    }
                    cqDataMap.put(AbstractSchemaMapper.getUserDatePrefix() + fieldName, tstamp);
                    continue;
                }
                LOGGER.warn("Invalid date format for {}.  Field ignored", (Object)fieldName);
                continue;
            }
            if (obj instanceof Calendar[] || obj instanceof Date[]) {
                LOGGER.debug("Non dynamic date array {}", (Object)fieldName);
                int len = ((Object[])obj).length;
                Long[] milisArray = new Long[len];
                for (int i = 0; i < len; ++i) {
                    milisArray[i] = AbstractSchemaMapper.toSchemaDate(((Object[])obj)[i]);
                }
                cqDataMap.put(AbstractSchemaMapper.getUserDatePrefix() + fieldName, milisArray);
                continue;
            }
            cqDataMap.put(fieldName, entry.getValue());
        }
        if (!cqDataMap.isEmpty()) {
            asMap.put(AS_CQ_DATA, cqDataMap);
        }
        asMap.put(AS_PROVIDER_ID, key);
        this.setSolrId(cqFormat, key, asMap);
        if (this.getReportSuite() != null) {
            asMap.put(AS_REPORT_SUITE, this.getReportSuite());
        }
        timestamp = System.currentTimeMillis();
        if (asMap.containsKey("timestamp")) {
            Object time = asMap.get("timestamp");
            if (time instanceof Date) {
                timestamp = ((Date)time).getTime();
            } else if (time instanceof Calendar) {
                timestamp = ((Calendar)time).getTimeInMillis();
            }
        }
        asMap.put("timestamp", timestamp);
        this.finalizeSchemaMapping(cqFormat, asMap);
        return asMap;
    }

    private String getTranslationKeyEntry(String strInputkey, String strTranslationLanuage) {
        for (Map.Entry<String, String> subEntry : this.TRANSLATION_TO_SCHEMA_KEYS.entrySet()) {
            if (!strInputkey.equals(subEntry.getValue() + strTranslationLanuage)) continue;
            return subEntry.getKey();
        }
        return null;
    }

    public static String getMutliLingualLanguageKey(String strLanguage) {
        if (strLanguage.length() > 2) {
            strLanguage = "zh_tw".compareToIgnoreCase(strLanguage) == 0 ? "zh_TW" : ("zh_cn".compareToIgnoreCase(strLanguage) == 0 ? "zh_CN" : strLanguage.substring(0, 2));
        }
        return strLanguage;
    }

    private String getTranslationLanguageFromKey(String key) {
        String[] paths = key.split("/");
        if (paths != null && paths.length > 0) {
            return AbstractSchemaMapper.getMutliLingualLanguageKey(paths[paths.length - 1]);
        }
        return "";
    }

    private boolean isTranslationProcessingRequired(String key) {
        String[] paths;
        if (!this.TRANSLATION_TO_SCHEMA_KEYS.isEmpty() && !StringUtils.isEmpty(key) && (paths = key.split("/")) != null && paths.length > 1) {
            String strSecondLastPath = paths[paths.length - 2];
            return AbstractSchemaMapper.getTranslationFolderName().equals(strSecondLastPath);
        }
        return false;
    }

    public abstract void finalizeSchemaMapping(Map<String, Object> var1, Map<String, Object> var2);

    public Map<String, Object> toAttachmentSchema(Map<String, Object> data, String key) throws IOException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (this.CQ_ATTACHMENT_KEYS.contains(entry.getKey())) continue;
            resultMap.put(entry.getKey(), entry.getValue());
        }
        resultMap.put(AS_PROVIDER_ID, key);
        resultMap.put(AS_CONTENT_TYPE, data.get(CQ_CONTENT_TYPE));
        resultMap.put(AS_ATTACHMENT, data.get(CQ_ATTACHMENT));
        resultMap.remove(AS_PARENT_ID);
        return resultMap;
    }

    private static void spamFlagsFromSchema(Map<String, Object> cqMap, Map<String, Object> asMap) {
        Boolean approved = (Boolean)asMap.remove(AS_APPROVED);
        if (approved == null) {
            return;
        }
        cqMap.put(CQ_SPAM, approved == false);
        cqMap.put(CQ_APPROVED, approved);
    }

    public static Calendar fromSchemaDate(String key, Object asDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        Date date = null;
        try {
            if (asDate instanceof String) {
                LOGGER.error("Legacy format data from schema. Key: {}, String date: {}", (Object)key, asDate);
                date = dateFormat.parse((String)asDate);
            } else if (asDate instanceof Long) {
                date = new Date((Long)asDate);
            } else if (asDate instanceof Integer) {
                date = new Date(((Integer)asDate).intValue());
            } else if (asDate instanceof Double) {
                date = new Date(((Double)asDate).longValue());
            } else if (asDate instanceof Float) {
                date = new Date(((Float)asDate).longValue());
            } else {
                if (asDate instanceof Calendar) {
                    return (Calendar)asDate;
                }
                if (asDate instanceof Date) {
                    date = (Date)asDate;
                } else {
                    LOGGER.error("Unknown date format. Using current time. Key: {}, Date: {}. Type: " + (asDate == null ? "null" : asDate.getClass().toString()), (Object)key, asDate);
                }
            }
        }
        catch (ParseException e) {
            LOGGER.error("Could not parse date. Using current time. Key: {}, Date: {}", (Object)key, asDate);
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (date != null) {
            cal.setTime(date);
        }
        return cal;
    }

    public Map<String, Object> fromSchema(Map<String, Object> schemaData) {
        LOGGER.debug("About to map from schema: {}", (Object)schemaData);
        HashMap<String, Object> asFormatCopy = new HashMap<String, Object>(schemaData);
        HashMap<String, Object> cqMap = new HashMap<String, Object>();
        AbstractSchemaMapper.spamFlagsFromSchema(cqMap, asFormatCopy);
        boolean bTranslationMappingRequired = this.isTranslationProcessingRequired((String)schemaData.get(AS_PROVIDER_ID));
        String strTranslationLanuageKey = null;
        for (Map.Entry entry : asFormatCopy.entrySet()) {
            Calendar cal;
            if (this.TOP_LEVEL_TO_CQ_KEYS.containsKey(entry.getKey())) {
                if (((String)entry.getKey()).equals(AS_PUBLISH_DATE)) {
                    cqMap.put(this.TOP_LEVEL_TO_CQ_KEYS.get(entry.getKey()), AbstractSchemaMapper.fromSchemaDate((String)entry.getKey(), entry.getValue()));
                    continue;
                }
                cqMap.put(this.TOP_LEVEL_TO_CQ_KEYS.get(entry.getKey()), entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).equals(AS_CQ_DATA)) {
                Map cqData = (Map)entry.getValue();
                for (Map.Entry subEntry : cqData.entrySet()) {
                    String fieldName = (String)subEntry.getKey();
                    if (SUBHASH_DATE_FIELDS.contains(subEntry.getKey())) {
                        cal = AbstractSchemaMapper.fromSchemaDate((String)schemaData.get(AS_PROVIDER_ID), subEntry.getValue());
                        cqMap.put(fieldName, cal);
                        continue;
                    }
                    if (StringUtils.startsWith(fieldName, AbstractSchemaMapper.getUserDatePrefix())) {
                        String realName = StringUtils.remove(fieldName, AbstractSchemaMapper.getUserDatePrefix());
                        Object datesObj = subEntry.getValue();
                        if (datesObj instanceof Long) {
                            Calendar cal2 = AbstractSchemaMapper.fromSchemaDate((String)schemaData.get(AS_PROVIDER_ID), subEntry.getValue());
                            cqMap.put(realName, cal2);
                            continue;
                        }
                        Long[] milisArray = datesObj instanceof List ? ((List)datesObj).toArray(new Long[((List)datesObj).size()]) : (Long[])datesObj;
                        int len = milisArray.length;
                        Calendar[] calArray = new Calendar[len];
                        for (int i = 0; i < len; ++i) {
                            calArray[i] = AbstractSchemaMapper.fromSchemaDate((String)schemaData.get(AS_PROVIDER_ID), milisArray[i]);
                        }
                        cqMap.put(realName, calArray);
                        continue;
                    }
                    cqMap.put(fieldName, subEntry.getValue());
                }
                continue;
            }
            boolean bProcessingDone = false;
            if (bTranslationMappingRequired) {
                String strNewKeyEntry;
                if (strTranslationLanuageKey == null) {
                    strTranslationLanuageKey = this.getTranslationLanguageFromKey((String)schemaData.get(AS_PROVIDER_ID));
                }
                if (!StringUtils.isEmpty(strNewKeyEntry = this.getTranslationKeyEntry((String)entry.getKey(), strTranslationLanuageKey))) {
                    cqMap.put(strNewKeyEntry, entry.getValue());
                    bProcessingDone = true;
                }
            }
            if (bProcessingDone) continue;
            if (((String)entry.getKey()).endsWith("_dt")) {
                Calendar cal3 = AbstractSchemaMapper.fromSchemaDate((String)schemaData.get(AS_PROVIDER_ID), entry.getValue());
                cqMap.put((String)entry.getKey(), cal3);
                continue;
            }
            if (((String)entry.getKey()).endsWith("_dts")) {
                LOGGER.debug("From schema dynamic date array Long to Calendar {}", entry.getKey());
                Long[] miliDates = (Long[])entry.getValue();
                Calendar[] calArray = new Calendar[miliDates.length];
                for (int i = 0; i < miliDates.length; ++i) {
                    calArray[i] = cal = AbstractSchemaMapper.fromSchemaDate((String)schemaData.get(AS_PROVIDER_ID), miliDates[i]);
                }
                cqMap.put((String)entry.getKey(), calArray);
                continue;
            }
            cqMap.put((String)entry.getKey(), entry.getValue());
        }
        cqMap.remove(AS_REPORT_SUITE);
        cqMap.remove(AS_AUTHOR_CI);
        cqMap.remove(AS_AUTHOR_DISPLAY_NAME_CI);
        cqMap.remove(AS_ID);
        cqMap.remove(AS_COMPANY_ID);
        cqMap.remove(AS_FEATURES);
        if (schemaData.containsKey(AS_PROVIDER_ID)) {
            cqMap.put(CQ_KEY, schemaData.get(AS_PROVIDER_ID));
        }
        if (cqMap.containsKey(CQ_ADDED)) {
            Calendar cal = AbstractSchemaMapper.fromSchemaDate((String)schemaData.get(AS_PROVIDER_ID), cqMap.get(CQ_ADDED));
            cqMap.put(CQ_ADDED, cal);
        }
        if (!cqMap.containsKey(CQ_RESOURCE_TYPE) && schemaData.containsKey("resource_type")) {
            LOGGER.error("Legacy format data from AS. Key: {}, resource_type: {}", schemaData.get(AS_PROVIDER_ID), schemaData.get("resource_type"));
            cqMap.put(CQ_RESOURCE_TYPE, schemaData.get("resource_type"));
        }
        if (!cqMap.containsKey(CQ_TITLE) && schemaData.containsKey("title")) {
            LOGGER.error("Legacy format data from AS. Key: {}, title: {}", schemaData.get(AS_PROVIDER_ID), schemaData.get("title"));
            cqMap.put(CQ_TITLE, schemaData.get("title"));
        }
        if (!cqMap.containsKey(CQ_ROOT_COMMENT_SYSTEM) && schemaData.containsKey("root_id")) {
            LOGGER.error("Legacy format data from AS. Key: {}, root_id: {}", schemaData.get(AS_PROVIDER_ID), schemaData.get("root_id"));
            cqMap.put(CQ_ROOT_COMMENT_SYSTEM, schemaData.get("root_id"));
        }
        LOGGER.debug("Completed mapping from schema: {}", (Object)cqMap);
        return cqMap;
    }

    public Map<String, Object> fromAttachmentSchema(Map<String, Object> input) {
        if (input.isEmpty()) {
            return input;
        }
        input.remove("md5");
        input.remove("documentstore_id");
        input.remove("attachment_id");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            if (this.AS_ATTACHMENT_KEYS.contains(entry.getKey())) continue;
            resultMap.put(entry.getKey(), entry.getValue());
        }
        resultMap.put(CQ_KEY, input.get(AS_PROVIDER_ID));
        resultMap.put(CQ_CONTENT_TYPE, input.get(AS_CONTENT_TYPE));
        resultMap.put(CQ_ADDED, AbstractSchemaMapper.fromSchemaDate(AbstractSchemaMapper.getSchemaAttachmentUploadDateKey(), input.get(AbstractSchemaMapper.getSchemaAttachmentUploadDateKey())));
        if (resultMap.get(AS_ATTACHMENT_LENGTH) != null) {
            resultMap.put(AS_ATTACHMENT_LENGTH, ((Number)resultMap.get(AS_ATTACHMENT_LENGTH)).longValue());
        }
        return resultMap;
    }

    public String toSchemaKey(String cqKey) {
        if (this.TOP_LEVEL_TO_SCHEMA_KEYS.containsKey(cqKey)) {
            return this.TOP_LEVEL_TO_SCHEMA_KEYS.get(cqKey);
        }
        return cqKey;
    }

    public String fromSchemaKey(String schemaKey) {
        if (this.TOP_LEVEL_TO_CQ_KEYS.containsKey(schemaKey)) {
            return this.TOP_LEVEL_TO_CQ_KEYS.get(schemaKey);
        }
        return schemaKey;
    }

    public List<String> toSchemaKeys(String mltField) {
        List<String> override = this.mapToMultipleValues(mltField);
        if (override != null) {
            return override;
        }
        String ret = this.TOP_LEVEL_TO_SCHEMA_KEYS.get(mltField);
        if (ret == null) {
            return Arrays.asList(mltField);
        }
        return Arrays.asList(ret);
    }

    protected abstract String[] getASVerbatimList();

    private List<String> mapToMultipleValues(String mltField) {
        if (mltField.equals(AbstractSchemaMapper.getSocoDescriptionKey())) {
            return new ArrayList<String>(Arrays.asList(this.getASVerbatimList()));
        }
        return null;
    }

    public String luceneToSolr(String luceneQuery) {
        LOGGER.debug("Lucene query: {}", (Object)luceneQuery);
        StringBuilder sb = new StringBuilder().append(luceneQuery);
        AbstractSchemaMapper.replaceAll(sb, ":fulltext:", "");
        AbstractSchemaMapper.replaceAll(sb, ":path:", "provider_id:");
        AbstractSchemaMapper.replaceAll(sb, "cq:tags:", "cqtags_ss:");
        AbstractSchemaMapper.replaceAll(sb, ":parent:", "parent_id_s:");
        AbstractSchemaMapper.replaceAll(sb, "[ TO", "[* TO");
        AbstractSchemaMapper.replaceAll(sb, " TO \uffff]", " TO *]");
        LOGGER.debug("Replaced range limits {}", (Object)sb.toString());
        for (Map.Entry<String, String> entry : this.TOP_LEVEL_TO_SCHEMA_KEYS.entrySet()) {
            String cqKey = entry.getKey();
            List<String> override = this.mapToMultipleValues(cqKey);
            String solrKey = entry.getValue();
            if (override != null) {
                AbstractSchemaMapper.replaceAll(sb, cqKey + ":", override.get(0) + ":");
                continue;
            }
            AbstractSchemaMapper.replaceAll(sb, cqKey + ":", solrKey + ":");
        }
        String solrQuery = sb.toString().trim();
        String calendarSolrQuery = null;
        if (solrQuery.indexOf(AS_ADDRESS) >= 0) {
            int addressStartIndex = solrQuery.indexOf(AS_ADDRESS);
            int addressFinalIndex = addressStartIndex + solrQuery.substring(addressStartIndex).indexOf(") ");
            String keyParam = solrQuery.substring(addressStartIndex, addressFinalIndex).trim();
            String searchString = keyParam.substring(keyParam.indexOf(":(") + 2);
            String prefixString = solrQuery.substring(0, addressStartIndex);
            String[] literalArray = searchString.split("\\s+");
            StringBuilder key = new StringBuilder();
            for (String literal : literalArray) {
                key.append(literal).append("\\").append(" ");
            }
            String searchKey = key.toString().trim();
            searchKey = searchKey.substring(0, searchKey.length() - 1);
            calendarSolrQuery = prefixString.concat(AS_ADDRESS).concat(":(").concat("*").concat(searchKey).concat("*").concat(solrQuery.substring(addressFinalIndex));
            LOGGER.debug("Solr query: {}", (Object)calendarSolrQuery);
            return calendarSolrQuery;
        }
        LOGGER.debug("Solr query: {}", (Object)solrQuery);
        return solrQuery;
    }

    private static void replaceAll(StringBuilder builder, String from, String to) {
        int index = builder.indexOf(from);
        while (index != -1) {
            builder.replace(index, index + from.length(), to);
            index += to.length();
            index = builder.indexOf(from, index);
        }
    }

    public abstract Map<String, Object> toSolrSchema(Map<String, Object> var1, String var2);

    public boolean isIndexable(String key) {
        if (key.equals(SOLR_ID) || key.equals(AS_REPORT_SUITE)) {
            return true;
        }
        boolean matchesOutOfBoxFieldsInSolr = this.TOP_LEVEL_TO_CQ_KEYS.containsKey(key);
        if (matchesOutOfBoxFieldsInSolr) {
            return true;
        }
        Matcher incMatcher = PATTERN.matcher(key);
        return incMatcher.matches();
    }
}

