/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.api;

import com.adobe.cq.social.scf.OperationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;

public class SiteComponentConfiguration {
    public static final String CONFIG_PREFIX = "config.";
    public static final String CONFIG_VALUE_ON = "On";
    public static final String CONFIG_VALUE_OFF = "Off";
    public static final String CONFIGURATION_PATH = "/configuration";
    private final String componentName;
    private final Map<String, Object> configuration;
    public static final String[] COMPONENT_LIST = new String[]{"forum", "calendar", "commentsystem", "user", "theme", "template", "ws", "mt"};
    private static final Map<String, String> RESOURCE_TYPE_MAP = new HashMap<String, String>();

    public SiteComponentConfiguration(String name, RequestParameterMap params) {
        this.componentName = name;
        this.configuration = new HashMap<String, Object>();
        int beginIndex = CONFIG_PREFIX.length() + name.length();
        for (String key : params.keySet()) {
            if (!key.startsWith(CONFIG_PREFIX + name)) continue;
            String configName = key.substring(beginIndex + 1);
            RequestParameter[] values = (RequestParameter[])params.get(key);
            Object value = values.length == 1 ? values[0].getString() : params.getValues(key);
            boolean v = false;
            if ("on".equals(value)) {
                v = true;
            }
            this.configuration.put(configName, v);
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getComponentResourceType() {
        return RESOURCE_TYPE_MAP.get(this.componentName);
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public static void validateConfig(String name) throws OperationException {
        String componentName = name.substring(CONFIG_PREFIX.length(), name.indexOf(".", CONFIG_PREFIX.length()));
        for (int i = 0; i < COMPONENT_LIST.length; ++i) {
            if (!componentName.equals(COMPONENT_LIST[i])) continue;
            return;
        }
        throw new OperationException("Invalid component name " + name, 400);
    }

    static {
        RESOURCE_TYPE_MAP.put("forum", "social/forum/components/hbs/forum");
        RESOURCE_TYPE_MAP.put("calendar", "social/calendar/components/hbs/calendar");
        RESOURCE_TYPE_MAP.put("commentsystem", "social/commons/components/hbs/comments");
        RESOURCE_TYPE_MAP.put("ws", "babble/components/forum/components/hbs/forum");
    }
}

