/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.site.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.site.api.CommunitySiteCollection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommunitySiteCollection
extends BaseSocialComponent
implements CommunitySiteCollection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunitySiteCollection.class);
    private final CommunityContext context;
    private static final String SITE_FOLDER_TYPE = "sitefolder";
    private static final String PROPERTY_TYPE = "type";
    private CollectionPagination pagination = CollectionPagination.DEFAULT_PAGINATION;
    private CollectionSortedOrder sortOrder = CollectionSortedOrder.DEFAULT_ORDER;
    private List<Object> sites;

    public AbstractCommunitySiteCollection(Resource resource, ClientUtilities clientUtils, CollectionPagination pagination, CollectionSortedOrder sortOrder) {
        this(resource, clientUtils);
        this.setPagination(pagination);
        this.setSortedOrder(sortOrder);
    }

    public AbstractCommunitySiteCollection(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);
        this.context = resource.adaptTo(CommunityContext.class);
    }

    @Override
    public int getTotalSize() {
        if (this.sites == null) {
            this.sites = this.getItems();
        }
        return this.sites.size();
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.pagination = pagination;
        this.sites = null;
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.sortOrder = sortedOrder;
        this.sites = null;
    }

    @Override
    public List<Object> getItems() {
        if (this.sites == null) {
            this.sites = new ArrayList<Object>();
            Iterable<Resource> siteResources = null;
            try {
                siteResources = this.getSites();
            }
            catch (OperationException oe) {
                LOG.error("Failed to get the list of sites.", oe);
                return this.sites;
            }
            if (siteResources == null) {
                LOG.error("Failed to get the list of sites.");
                return this.sites;
            }
            this.getSites(siteResources, true);
        }
        return this.sites;
    }

    protected boolean isRequestForCommunitySiteFolder() {
        return StringUtils.equalsIgnoreCase(SITE_FOLDER_TYPE, this.getProperty(PROPERTY_TYPE, ""));
    }

    private void getSites(Iterable<Resource> siteResources, Boolean lookDeep) {
        for (Resource resource : siteResources) {
            Resource site = null;
            site = resource.getChild("configuration");
            if (site == null && lookDeep.booleanValue()) {
                if (!this.isRequestForCommunitySiteFolder()) {
                    this.getSites(resource.getChildren(), lookDeep == false);
                } else {
                    Resource jcrContent = resource.getChild("jcr:content");
                    if (jcrContent != null) {
                        ValueMap vm = jcrContent.adaptTo(ValueMap.class);
                        Boolean isCommunitySite = vm.get("cq:isCommunitySite", (Boolean)null);
                        if (isCommunitySite == null) {
                            this.getSites(resource.getChildren(), lookDeep == false);
                        } else if (isCommunitySite.booleanValue()) {
                            site = resource.getChild("folderConfiguration");
                        }
                    }
                }
            }
            if (site != null && (site.isResourceType("social/console/components/hbs/sitecollection/site") || site.isResourceType("social/console/components/hbs/sitecollection/sitefolder"))) {
                SocialComponent component;
                SocialComponentFactory factory = this.clientUtils.getSocialComponentFactoryManager().getSocialComponentFactory(site);
                if (factory == null || (component = factory.getSocialComponent(site)) == null) continue;
                this.sites.add(component);
                continue;
            }
            LOG.debug("No site resource found at {}", (Object)resource.getPath());
        }
    }

    protected CommunityContext getContext() {
        return this.context;
    }

    protected abstract Iterable<Resource> getSites() throws OperationException;
}

