/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.jackrabbit.util.Text;
import org.osgi.service.event.Event;

public abstract class SocialEvent<T extends SocialActions>
extends Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Map<String, Object> EMPTY_MAP = new HashMap<String, Object>();
    protected static final String USER_ID = "userId";
    protected static final String ACTION = "action";
    protected static final String PATH = "path";
    public static String TARGET = "target";
    public static String OBJECT = "object";
    public static final String SOCIAL_EVENT_TOPIC_PREFIX = "com/adobe/cq/social/";

    public SocialEvent(Event event) {
        super(event.getTopic(), SocialEvent.buildPropertiesFromEvent(event));
    }

    private static Dictionary<String, Object> buildPropertiesFromEvent(Event event) {
        Hashtable<String, Object> props = new Hashtable<String, Object>(event.getPropertyNames().length);
        for (String key : event.getPropertyNames()) {
            ((Dictionary)props).put(key, event.getProperty(key));
        }
        return props;
    }

    public SocialEvent(String topic, String path, String userId, T action, Map<String, Object> additionalData) {
        super(SOCIAL_EVENT_TOPIC_PREFIX + topic, SocialEvent.buildProps(path, userId, action, null, null, additionalData));
    }

    public SocialEvent(String topic, String path, String userId, T action, EventObject source, EventObject destination, Map<String, Object> additionalData) {
        super(SOCIAL_EVENT_TOPIC_PREFIX + topic, SocialEvent.buildProps(path, userId, action, source, destination, additionalData));
    }

    private static Dictionary<String, Object> buildProps(String path, String userId, SocialActions action, EventObject object, EventObject target, Map<String, Object> additionalData) {
        int size = 5;
        if (null != additionalData) {
            size += additionalData.size();
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>(size);
        if (null != additionalData) {
            for (Map.Entry<String, Object> datum : additionalData.entrySet()) {
                ((Dictionary)props).put(datum.getKey(), datum.getValue());
            }
        }
        ((Dictionary)props).put(PATH, path);
        ((Dictionary)props).put(ACTION, action);
        ((Dictionary)props).put(USER_ID, userId);
        if (target != null) {
            ((Dictionary)props).put(TARGET, target);
        }
        if (object != null) {
            ((Dictionary)props).put(OBJECT, object);
        }
        return props;
    }

    public String getUserId() {
        return (String)this.getProperty(USER_ID);
    }

    public T getAction() {
        return (T)((SocialActions)this.getProperty(ACTION));
    }

    public String getPath() {
        return (String)this.getProperty(PATH);
    }

    public EventObject getTarget() {
        return (EventObject)this.getProperty(TARGET);
    }

    public EventObject getObject() {
        return (EventObject)this.getProperty(OBJECT);
    }

    public static class BaseEventObject
    implements EventObject {
        private final String displayName;
        private final String id;
        private final String objectType;
        private final Map<String, Object> properties;

        public BaseEventObject(String id, String objectType) {
            this(id, objectType, EMPTY_MAP);
        }

        public BaseEventObject(String id, String ObjectType, Map<String, Object> properties) {
            this(Text.getName(id), id, ObjectType, properties);
        }

        public BaseEventObject(String displayName, String id, String objectType) {
            this(displayName, id, objectType, new HashMap<String, Object>());
        }

        public BaseEventObject(String displayName, String id, String objectType, Map<String, Object> properties) {
            this.displayName = displayName;
            this.id = id;
            this.objectType = objectType;
            this.properties = properties;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getType() {
            return this.objectType;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static interface SocialActions {
        public String getVerb();
    }

    public static interface EventObject {
        public String getId();

        public String getDisplayName();

        public String getType();

        public Map<String, Object> getProperties();
    }
}

