/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.scf.core;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.JsonException;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.DefaultResourceID;
import com.adobe.cq.social.scf.core.ResourceID;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, isGetterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class BaseSocialComponent
implements SocialComponent {
    private static ObjectMapper objectMapper;
    private static Charset UTF8_CHARSET;
    protected final Resource resource;
    protected final ResourceID id;
    private volatile Map<String, Object> properties = null;
    protected ClientUtilities clientUtils;
    protected final List<String> ignoredProperties = new ArrayList<String>(Arrays.asList("cq:.*", "ip", "email", "userAgent", "sling:.*"));
    protected List<Pattern> ignoredPropertiesPatterns;
    private final List<String> whiteList = Arrays.asList("cq:tags");

    public BaseSocialComponent(Resource resource, ClientUtilities clientUtils) {
        this.resource = resource;
        this.id = new DefaultResourceID(resource);
        this.clientUtils = clientUtils;
    }

    public static String buildJSONString(Map<String, Object> data, boolean tidy) throws JsonException {
        try {
            JsonFactory f = new JsonFactory();
            f.setCharacterEscapes(new EscapeCloseScriptBlocks());
            ByteArrayOutputStream bastream = new ByteArrayOutputStream();
            JsonGenerator jgen = f.createGenerator(bastream, JsonEncoding.UTF8);
            if (tidy) {
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(jgen, data);
            } else {
                objectMapper.writeValue(jgen, data);
            }
            return new String(bastream.toByteArray(), UTF8_CHARSET);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Error converting map to JSON", e);
        }
        catch (IOException e) {
            throw new JsonException("Error converting map to JSON", e);
        }
    }

    @Override
    public ResourceID getId() {
        return this.id;
    }

    @Override
    public String getResourceType() {
        return this.resource.getResourceType();
    }

    @Override
    public String getUrl() {
        return this.externalizeURL(this.resource.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            BaseSocialComponent baseSocialComponent = this;
            synchronized (baseSocialComponent) {
                if (this.properties == null) {
                    HashMap<String, Object> tmpMap = new HashMap<String, Object>();
                    BaseSocialComponent thiz = this;
                    ValueMap propMap = thiz.resource.adaptTo(ValueMap.class);
                    if (propMap != null) {
                        this.initIgnoredPropertiesList();
                        for (Map.Entry entry : propMap.entrySet()) {
                            if (thiz.isKeyIgnored((String)entry.getKey())) continue;
                            Object value = entry.getValue();
                            if (value == null) {
                                tmpMap.put((String)entry.getKey(), "");
                                continue;
                            }
                            tmpMap.put((String)entry.getKey(), value);
                        }
                    }
                    this.properties = tmpMap;
                }
            }
        }
        return this.properties;
    }

    @Override
    public <T> T getProperty(String name, Class<T> type) {
        Map<String, Object> props = this.getProperties();
        return this.convert(props.get(name), type);
    }

    @Override
    public <T> T getProperty(String name, T defaultValue) {
        Class<?> value = this.getProperty(name, (T)defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    private <T> T convert(Object obj, Class<T> type) {
        try {
            if (obj == null) {
                return null;
            }
            if (type.isAssignableFrom(obj.getClass())) {
                return (T)obj;
            }
            if (type.isArray()) {
                return (T)this.convertToArray(obj, type.getComponentType());
            }
            if (type == String.class) {
                return (T)String.valueOf(obj);
            }
            if (type == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(obj.toString()));
            }
            if (type == Long.class) {
                return (T)Long.valueOf(Long.parseLong(obj.toString()));
            }
            if (type == Double.class) {
                return (T)Double.valueOf(Double.parseDouble(obj.toString()));
            }
            if (type == Boolean.class) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(obj.toString()));
            }
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private <T> T[] convertToArray(Object obj, Class<T> type) {
        LinkedList<T> values = new LinkedList<T>();
        if (obj.getClass().isArray()) {
            for (Object o : (Object[])obj) {
                T ct = this.convert(o, type);
                if (ct == null) continue;
                values.add(ct);
            }
        } else {
            T ct = this.convert(obj, type);
            if (ct != null) {
                values.add(ct);
            }
        }
        Object[] result = (Object[])Array.newInstance(type, values.size());
        return values.toArray(result);
    }

    private void initIgnoredPropertiesList() {
        this.ignoredPropertiesPatterns = new ArrayList<Pattern>(this.getIgnoredProperties().size());
        for (String ignoredKey : this.getIgnoredProperties()) {
            this.ignoredPropertiesPatterns.add(Pattern.compile(ignoredKey));
        }
    }

    protected boolean isKeyIgnored(String key) {
        for (Pattern ignoredKey : this.ignoredPropertiesPatterns) {
            if (!ignoredKey.matcher(key).matches() || this.whiteList.contains(key)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getIgnoredProperties() {
        return this.ignoredProperties;
    }

    @Override
    @JsonIgnore
    public String toJSONString(boolean tidy) throws JsonException {
        try {
            JsonFactory f = new JsonFactory();
            f.setCharacterEscapes(new EscapeCloseScriptBlocks());
            ByteArrayOutputStream bastream = new ByteArrayOutputStream();
            JsonGenerator jgen = f.createGenerator(bastream, JsonEncoding.UTF8);
            if (tidy) {
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(jgen, (Object)this);
            } else {
                objectMapper.writeValue(jgen, (Object)this);
            }
            return new String(bastream.toByteArray(), UTF8_CHARSET);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("Error converting " + this.id + " to JSON", e);
        }
        catch (IOException e) {
            throw new JsonException("Error converting " + this.id + " to JSON", e);
        }
    }

    @Override
    @JsonIgnore
    public Resource getResource() {
        return this.resource;
    }

    protected String externalizeURL(String path) {
        if (this.clientUtils == null) {
            return path;
        }
        return this.clientUtils.externalLink(path);
    }

    @Override
    @JsonIgnore
    public Map<String, Object> getAsMap() {
        return objectMapper.convertValue((Object)this, Map.class);
    }

    @Override
    public SocialComponent getParentComponent() {
        return null;
    }

    @Override
    public SocialComponent getSourceComponent() {
        return this;
    }

    @Override
    public String getFriendlyUrl() {
        Page page;
        SocialUtils socialUtils = this.clientUtils.getSocialUtils();
        if (socialUtils != null && (page = socialUtils.getContainingPage(this.resource)) != null) {
            return this.clientUtils.externalLink(page.getPath(), false) + ".html";
        }
        return null;
    }

    static {
        UTF8_CHARSET = Charset.forName("UTF-8");
        objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true).configure(SerializationFeature.WRAP_EXCEPTIONS, false);
    }

    private static class EscapeCloseScriptBlocks
    extends CharacterEscapes {
        private static final long serialVersionUID = 1L;
        private final int[] escapes;

        public EscapeCloseScriptBlocks() {
            int[] baseEscapes = EscapeCloseScriptBlocks.standardAsciiEscapesForJSON();
            baseEscapes[60] = -1;
            baseEscapes[62] = -1;
            this.escapes = baseEscapes;
        }

        @Override
        public int[] getEscapeCodesForAscii() {
            return this.escapes;
        }

        @Override
        public SerializableString getEscapeSequence(int arg0) {
            return null;
        }
    }
}

