/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.review.client.api;

import com.adobe.cq.social.commons.comments.api.AbstractCommentCollection;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.review.client.api.ReviewCollectionSocialComponent;
import com.adobe.cq.social.review.client.api.ReviewSocialComponent;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.tally.client.api.RatingSocialComponent;
import com.adobe.cq.social.tally.client.api.ResponseValue;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.adobe.cq.social.ugc.api.PathConstraint;
import com.adobe.cq.social.ugc.api.PathConstraintType;
import com.adobe.cq.social.ugc.api.SearchResults;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.UgcSearch;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReviewCollection<R extends ReviewSocialComponent, C extends CommentCollectionConfiguration>
extends AbstractCommentCollection<R, C>
implements ReviewCollectionSocialComponent<R, C> {
    protected final ResourceResolver resolver;
    protected Resource ugcResource;
    protected final String authorizableUserID;
    protected Map<String, RatingSocialComponent> ratings;
    protected RatingSocialComponent overallRating;
    private final UgcSearch search;
    private List<Map<String, String>> allowedRatings;
    private String[] requiredRatingTitles;
    private boolean includeHistogram = false;
    protected static final String NAME_KEY = "name";
    protected static final String REQUIRED_KEY = "required";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReviewCollection.class);

    public AbstractReviewCollection(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager);
    }

    public AbstractReviewCollection(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager listProviderManager, UgcSearch search) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), listProviderManager, search);
    }

    public AbstractReviewCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager) {
        this(resource, clientUtils, queryInfo, listProviderManager, null);
    }

    public AbstractReviewCollection(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager listProviderManager, UgcSearch search) {
        super(resource, clientUtils, queryInfo, listProviderManager);
        this.resolver = resource.getResourceResolver();
        String path = clientUtils.getSocialUtils().resourceToUGCStoragePath(resource);
        this.ugcResource = this.resolver.getResource(path);
        if (this.ugcResource == null) {
            this.ugcResource = new NonExistingResource(this.resolver, path);
        }
        this.search = search;
        this.authorizableUserID = this.getLoggedInUser();
        this.ratings = this.getRatings(clientUtils);
        this.overallRating = this.getOverallRating(clientUtils);
    }

    private RatingSocialComponent getOverallRating(ClientUtilities clientUtils) {
        Resource parentResource;
        String overallRatingTitle = this.requiredRatingTitles == null ? "Overall" : this.requiredRatingTitles[0];
        Resource baseResource = this.ugcResource.getParent();
        baseResource = baseResource != null ? baseResource.getChild(this.resource.getName() + "_" + overallRatingTitle) : ((parentResource = this.resolver.getResource(StringUtils.substringBeforeLast(this.ugcResource.getPath(), "/"))) != null ? parentResource.getChild(this.resource.getName() + "_" + overallRatingTitle) : null);
        return this.getRatingSocialComponentFromResource(baseResource, clientUtils);
    }

    @Override
    public RatingSocialComponent getOverallRating() {
        return this.overallRating;
    }

    private Map<String, RatingSocialComponent> getRatings(ClientUtilities clientUtils) {
        HashMap<String, RatingSocialComponent> results = new HashMap<String, RatingSocialComponent>();
        Resource parentResource = this.ugcResource.getParent();
        Iterator<Object> children = Collections.emptyList().iterator();
        if (parentResource != null) {
            children = parentResource.getChildren().iterator();
        } else {
            List<Object> ratingResources = new ArrayList();
            String resourceName = StringUtils.substringAfterLast(this.ugcResource.getPath(), "/");
            String resourceBasePath = StringUtils.substringBeforeLast(this.ugcResource.getPath(), "/");
            List<Map<String, String>> ratings = this.getAllowedRatings();
            if (this.search != null) {
                UgcFilter resourceTypeAndParentFilter = new UgcFilter();
                resourceTypeAndParentFilter.addConstraint(new PathConstraint(resourceBasePath, PathConstraintType.IsDescendantNode));
                ValueConstraint<String> resourceTypeConstraint = new ValueConstraint<String>("sling:resourceType", "social/tally/components/hbs/rating");
                resourceTypeAndParentFilter.addConstraint(resourceTypeConstraint);
                try {
                    SearchResults<Resource> childrenResources = this.search.find(null, this.ugcResource.getResourceResolver(), resourceTypeAndParentFilter, 0, ratings.size(), false);
                    ratingResources = childrenResources.getResults();
                    children = ratingResources.iterator();
                }
                catch (RepositoryException e) {
                    LOG.error("Could not perform search to find ratings for {}", (Object)this.ugcResource.getPath());
                }
            } else {
                for (Map<String, String> rating : ratings) {
                    String childResourcePath = resourceBasePath + "/" + resourceName + "_" + rating.get(NAME_KEY);
                    Resource child = this.ugcResource.getResourceResolver().getResource(childResourcePath);
                    if (child == null) continue;
                    ratingResources.add(child);
                }
                children = ratingResources.iterator();
            }
        }
        while (children.hasNext()) {
            Resource child = (Resource)children.next();
            if (!this.resolver.isResourceType(child, "social/tally/components/hbs/rating")) continue;
            String name = StringUtils.substringAfterLast(child.getName(), "_");
            RatingSocialComponent rating = this.getRatingSocialComponentFromResource(child, clientUtils);
            results.put(name, rating);
        }
        return results;
    }

    private boolean isRatingAllowed(String name) {
        List<Map<String, String>> allowed = this.getAllowedRatings();
        for (Map<String, String> map : allowed) {
            if (map == null || !StringUtils.equals(map.get(NAME_KEY), name)) continue;
            return true;
        }
        return false;
    }

    private RatingSocialComponent getRatingSocialComponentFromResource(Resource resource, ClientUtilities clientUtils) {
        SocialComponentFactory scf;
        SocialComponentFactoryManager scfMgr;
        if (resource != null && (scfMgr = clientUtils.getSocialComponentFactoryManager()) != null && (scf = scfMgr.getSocialComponentFactory(resource)) != null) {
            return (RatingSocialComponent)scf.getSocialComponent(resource);
        }
        return null;
    }

    private String getLoggedInUser() {
        if (this.resolver == null) {
            return null;
        }
        return this.resolver.adaptTo(Session.class).getUserID();
    }

    @Override
    public String getName() {
        return (String)((Object)this.getProperty(NAME_KEY, String.class));
    }

    @Override
    public Long getTotalNumberOfResponses() {
        return new Long(this.getTotalSize());
    }

    @Override
    public Map<String, ResponseValue> getCurrentUserResponse() throws TallyException, RepositoryException {
        HashMap<String, ResponseValue> results = new HashMap<String, ResponseValue>();
        ResponseValue comment = new ResponseValue(){

            @Override
            public String getResponseValue() {
                return AbstractReviewCollection.this.getCurrentUserComment();
            }
        };
        results.put("comment", comment);
        if (this.overallRating != null && this.overallRating.getCurrentUserResponse() != null) {
            results.put(this.overallRating.getName(), this.overallRating.getCurrentUserResponse());
            return results;
        }
        return null;
    }

    private String getCurrentUserComment() {
        return "";
    }

    @Override
    public Map<String, RatingSocialComponent> getRatings() {
        return this.ratings;
    }

    @Override
    public Map<String, String> getRatingAverages() {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        for (Map<String, String> map : this.allowedRatings) {
            if (map == null || map.get(NAME_KEY) == null) continue;
            String name = map.get(NAME_KEY);
            if (this.ratings.get(name) != null) {
                results.put(name, this.ratings.get(name).getFormattedAverageRating());
                continue;
            }
            results.put(name, null);
        }
        return results;
    }

    private void buildAllowedRatings() {
        ValueMap summaryVM;
        Adaptable allowedRatingResource = null;
        if (this.resource.isResourceType("social/reviews/components/hbs/summary") && (summaryVM = ResourceUtil.getValueMap(this.resource)).containsKey("reviewPath")) {
            allowedRatingResource = this.resolver.resolve((String)summaryVM.get("reviewPath"));
        }
        if (allowedRatingResource == null) {
            allowedRatingResource = this.resolver.resolve(this.resource.getPath());
        }
        ValueMap values = allowedRatingResource.adaptTo(ValueMap.class) != null ? allowedRatingResource.adaptTo(ValueMap.class) : this.clientUtils.getDesignProperties((Resource)allowedRatingResource, "social/reviews/components/hbs/reviews");
        String[] ratings = values.get("allowedRatings", new String[]{"Overall"});
        this.allowedRatings = new ArrayList<Map<String, String>>(ratings.length);
        this.requiredRatingTitles = values.get("requiredRatings", new String[]{"Overall"});
        List<String> requiredList = Arrays.asList(this.requiredRatingTitles);
        for (String subrating : ratings) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(NAME_KEY, subrating);
            if (requiredList.contains(subrating)) {
                map.put(REQUIRED_KEY, "true");
            }
            this.allowedRatings.add(map);
        }
    }

    @Override
    public List<Map<String, String>> getAllowedRatings() {
        if (null == this.allowedRatings) {
            this.buildAllowedRatings();
        }
        return this.allowedRatings;
    }

    @Override
    public boolean isCompositeRating() {
        if (this.getAllowedRatings() == null) {
            return false;
        }
        return this.getAllowedRatings().size() != 1;
    }

    @Override
    public boolean isIncludeHistogram() {
        return this.includeHistogram;
    }

    protected void setIncludeHistogram(boolean include) {
        this.includeHistogram = include;
    }
}

