/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.notifications.client.api;

import com.adobe.cq.social.commons.listing.QueryFilterUtil;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.notifications.api.Notification;
import com.adobe.cq.social.notifications.api.NotificationManager;
import com.adobe.cq.social.notifications.client.api.SocialNotificationCollection;
import com.adobe.cq.social.notifications.client.api.SocialNotificationComponentFactory;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.Operator;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.activitystreams.ActivityException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSocialNotificationCollection
extends BaseSocialComponent
implements SocialNotificationCollection {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSocialNotificationCollection.class);
    private CollectionPagination pagination;
    private CollectionSortedOrder sortOrder = CollectionSortedOrder.DEFAULT_ORDER;
    private List<Object> notifications;
    private PageInfo pageInfo;
    private NotificationManager notificationManager;
    private String userId;
    private String channelId;
    private int maxNumberNotifications;
    private long numUnread = -1L;
    private UgcFilter ugcFilter;
    private static String PROP_FILTER_NAME = "filter";

    public AbstractSocialNotificationCollection(Resource resource, ClientUtilities clientUtils, NotificationManager notificationManager) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), notificationManager);
    }

    public AbstractSocialNotificationCollection(Resource resource, ClientUtilities clientUtilities, QueryRequestInfo queryRequestInfo, NotificationManager notificationManager) {
        super(resource, clientUtilities);
        this.init(resource, clientUtilities, queryRequestInfo, notificationManager, this.getProperty("userId", ""));
    }

    public AbstractSocialNotificationCollection(Resource resource, ClientUtilities clientUtilities, QueryRequestInfo queryRequestInfo, NotificationManager notificationManager, String userId) {
        super(resource, clientUtilities);
        this.init(resource, clientUtilities, queryRequestInfo, notificationManager, userId);
    }

    @Override
    public long getUnreadCount() {
        if (this.numUnread == -1L) {
            try {
                if (StringUtils.isBlank(this.userId)) {
                    throw new IllegalStateException("UserId has not been set.");
                }
                this.numUnread = this.notificationManager.getUnreadCount(this.resource.getResourceResolver(), AbstractSocialNotificationCollection.getPathConstraint(this.resource), this.channelId);
            }
            catch (RepositoryException e) {
                LOG.error("Failed to obtain number of unread count.", e);
            }
            catch (ActivityException e) {
                this.numUnread = 0L;
            }
        }
        return this.numUnread;
    }

    @Override
    public int getTotalSize() {
        if (this.maxNumberNotifications < 0) {
            return (int)this.pageInfo.getPageSize() * (int)this.pageInfo.getSelectedPage() + 2;
        }
        this.getItems();
        return this.notifications.size();
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.pagination = pagination;
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.sortOrder = sortedOrder;
    }

    @Override
    public List<Object> getItems() {
        ResourceResolver resolver = this.resource.getResourceResolver();
        if (this.pagination.getSize() > 0 && this.notifications == null && this.notificationManager.isStreamExist(resolver)) {
            Iterable<Notification> notificationList = null;
            notificationList = this.notificationManager.getNotifications(resolver, this.ugcFilter, this.pagination.getOffset(), this.pagination.getSize());
            if (notificationList != null) {
                this.notifications = new ArrayList<Object>();
                for (Notification notification : notificationList) {
                    SyntheticResource notificationResource = new SyntheticResource(resolver, notification.getPath(), "social/notifications/components/hbs/notifications/notification");
                    SocialComponentFactoryManager factoryManager = this.clientUtils.getSocialComponentFactoryManager();
                    SocialComponentFactory componentFactory = factoryManager.getSocialComponentFactory(notificationResource);
                    SocialComponent sc = null;
                    sc = componentFactory instanceof SocialNotificationComponentFactory ? ((SocialNotificationComponentFactory)componentFactory).getSocialComponent((Resource)notificationResource, this.clientUtils, notification) : componentFactory.getSocialComponent(notificationResource, this.clientUtils, null);
                    if (sc == null) continue;
                    this.notifications.add(sc);
                }
                return this.notifications;
            }
        }
        if (this.notifications == null) {
            LOG.debug("Return empty list");
            return Collections.emptyList();
        }
        LOG.debug("Returning existing notifications list");
        return this.notifications;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public int getUnreadCountConfigured() {
        return this.notificationManager.getUnreadCountConfigured();
    }

    private void init(Resource resource, ClientUtilities clientUtilities, QueryRequestInfo queryRequestInfo, NotificationManager notificationManager, String userId) {
        if (notificationManager == null) {
            throw new IllegalArgumentException("NoficationManager can not be null.");
        }
        this.notificationManager = notificationManager;
        if (StringUtils.isBlank(userId)) {
            throw new IllegalArgumentException("UserId can not be null.");
        }
        this.userId = userId;
        LOG.debug("userId: {}", (Object)userId);
        if (this.getProperties().containsKey("channelId")) {
            this.channelId = this.getProperty("channelId", "web");
            LOG.debug("channelId: {}", (Object)this.channelId);
        }
        if (StringUtils.isEmpty(this.channelId)) {
            this.channelId = "web";
        }
        this.pagination = queryRequestInfo.getPagination();
        if (this.pagination == null) {
            this.pagination = CollectionPagination.DEFAULT_PAGINATION;
        }
        this.pageInfo = new PageInfo(this, this.clientUtils, this.pagination, this.getQueryParams(queryRequestInfo));
        this.maxNumberNotifications = Integer.parseInt(this.getProperty("maxNotifications", "-1"));
        try {
            this.ugcFilter = this.getFilter(queryRequestInfo, resource);
        }
        catch (QueryFilterUtil.QueryFilterException e) {
            LOG.error("Failed to parse query predicates", e);
            this.ugcFilter = null;
        }
    }

    private UgcFilter getFilter(QueryRequestInfo queryRequestInfo, Resource resource) throws QueryFilterUtil.QueryFilterException {
        List<ConstraintGroup> constraints;
        String[] filters;
        UgcFilter ugcfilters = new UgcFilter();
        if (StringUtils.isNotBlank(this.channelId) && !"*".equals(this.channelId)) {
            ValueConstraint<String> constraint = new ValueConstraint<String>("channel_ss", this.channelId);
            ugcfilters.addConstraint(constraint);
        }
        ugcfilters.and(AbstractSocialNotificationCollection.getPathConstraint(resource));
        Map<String, String[]> predicates = queryRequestInfo.getPredicates();
        if (predicates != null && (filters = predicates.get(PROP_FILTER_NAME)) != null && filters.length > 0 && (constraints = QueryFilterUtil.parseFilter(filters)) != null && !constraints.isEmpty()) {
            for (ConstraintGroup cg : constraints) {
                ugcfilters.and(cg);
            }
        }
        return ugcfilters;
    }

    public static Constraint getPathConstraint(Resource resource) {
        CommunityContext context = resource.adaptTo(CommunityContext.class);
        ConstraintGroup cgTargetPaths = new ConstraintGroup();
        String siteId = context.getSiteId();
        List<Object> pathConstraints = new ArrayList<String>();
        if (StringUtils.isNotEmpty(siteId)) {
            if (StringUtils.isNotEmpty(context.getCommunityGroupId())) {
                pathConstraints.add(context.getCommunityGroupPath() + "/");
            } else {
                pathConstraints = context.getSiteContentPaths();
            }
        } else {
            pathConstraints.add(AbstractSocialNotificationCollection.getApplicationPagePath(resource));
        }
        SocialUtils socialUtils = resource.getResourceResolver().adaptTo(SocialUtils.class);
        String asiPath = socialUtils.getSocialResourceProvider(resource).getASIPath();
        for (String string : pathConstraints) {
            if (!StringUtils.isNotEmpty(string)) continue;
            String ending = string.endsWith("/") ? "" : "/";
            ValueConstraint<String> constraint = new ValueConstraint<String>("targetid_s", string + ending, ComparisonType.BeginsWith);
            constraint.setOperator(Operator.Or);
            cgTargetPaths.addConstraint(constraint);
            ValueConstraint<String> ugcconstraint = new ValueConstraint<String>("targetid_s", asiPath + string + ending, ComparisonType.BeginsWith);
            ugcconstraint.setOperator(Operator.Or);
            cgTargetPaths.addConstraint(ugcconstraint);
        }
        return cgTargetPaths;
    }

    private static String getApplicationPagePath(Resource resource) {
        String path = resource.getPath();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String pagePath = null;
        if (path.startsWith("/content")) {
            try {
                while (path != null) {
                    Node parentNode;
                    String parentPath = ResourceUtil.getParent(path);
                    if (parentPath != null && (parentNode = session.getNode(parentPath)).isNodeType("cq:Page")) {
                        pagePath = parentNode.getPath();
                    }
                    path = parentPath;
                }
            }
            catch (RepositoryException e) {
                LOG.error("Failed to obtain application page path for " + path, e);
            }
        }
        return pagePath;
    }

    private String getQueryParams(QueryRequestInfo queryInfo) {
        Map<String, String[]> params = queryInfo.getPredicates();
        StringBuilder sb = new StringBuilder();
        boolean firstParam = true;
        try {
            for (Map.Entry<String, String[]> ks : params.entrySet()) {
                String key = ks.getKey();
                String[] value = ks.getValue();
                for (int i = 0; i < value.length; ++i) {
                    if (!firstParam) {
                        sb.append("&");
                    } else {
                        firstParam = false;
                    }
                    sb.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value[i], "UTF-8"));
                }
            }
            String retVal = sb.toString();
            return retVal.isEmpty() ? null : retVal;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error encoding params.  " + sb.toString());
            return null;
        }
    }
}

