/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.moderation.dashboard.api;

import com.adobe.cq.social.moderation.dashboard.impl.FilterGroupImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="AEM Communities Moderation Dashboard Filters", description="This component holds a group of search filters.", immediate=true)
@Service
public class FilterGroupSocialComponentFactory
extends AbstractSocialComponentFactory {
    public static final String SERVICE_PID = "com.adobe.cq.social.moderation.dashboard.api.FilterGroupSocialComponentFactory";
    public static final String DEFAULT_QNA_QUESTION = "QnA Question";
    public static final String DEFAULT_QNA_ANSWER = "QnA Answer";
    public static final String DEFAULT_FORUM_TOPIC = "Forum Topic";
    public static final String DEFAULT_FORUM_REPLY = "Forum Reply";
    public static final String DEFAULT_COMMENT = "Comment";
    public static final String DEFAULT_FILE = "File Library Document";
    public static final String DEFAULT_FOLDER = "File Library Folder";
    public static final String DEFAULT_BLOGS = "Blog Article";
    public static final String DEFAULT_BLOGS_COMMENTS = "Blog Comment";
    public static final String DEFAULT_CALENDAR_EVENTS = "Calendar Event";
    public static final String DEFAULT_CALENDAR_EVENT_COMMENTS = "Calendar Comment";
    public static final String DEFAULT_IDEATION_IDEA = "Idea";
    public static final String DEFAULT_IDEATION_COMMENT = "Ideation Comment";
    public static final String DEFAULT_QNA_QUESTION_RT = "social/qna/components/topic";
    public static final String DEFAULT_QNA_QUESTION_HBS_RT = "social/qna/components/hbs/topic";
    public static final String DEFAULT_QNA_ANSWER_RT = "social/qna/components/post";
    public static final String DEFAULT_QNA_ANSWER_HBS_RT = "social/qna/components/hbs/post";
    public static final String DEFAULT_FORUM_TOPIC_RT = "social/forum/components/topic";
    public static final String DEFAULT_FORUM_TOPIC_HBS_RT = "social/forum/components/hbs/topic";
    public static final String DEFAULT_FORUM_REPLY_RT = "social/forum/components/post";
    public static final String DEFAULT_FORUM_REPLY_HBS_RT = "social/forum/components/hbs/post";
    public static final String DEFAULT_COMMENT_RT = "social/commons/components/comments/comment";
    public static final String DEFAULT_COMMENT_HBS_RT = "social/commons/components/hbs/comments/comment";
    public static final String DEFAULT_FILE_HBS_RT = "social/filelibrary/components/hbs/document";
    public static final String DEFAULT_FOLDER_HBS_RT = "social/filelibrary/components/hbs/folder";
    public static final String DEFAULT_BLOGS_HBS_RT = "social/journal/components/hbs/entry_topic";
    public static final String DEFAULT_BLOGS_COMMENTS_HBS_RT = "social/journal/components/hbs/comment";
    public static final String DEFAULT_CALENDAR_EVENTS_HBS_RT = "social/calendar/components/hbs/event";
    public static final String DEFAULT_CALENDAR_EVENT_COMMENTS_HBS_RT = "social/calendar/components/hbs/event_comment";
    public static final String DEFAULT_IDEATION_HBS_RT = "social/ideation/components/hbs/idea";
    public static final String DEFAULT_IDEATION_COMMENT_HBS_RT = "social/ideation/components/hbs/comment";
    @Property(label="ResourceType Filters", value={"", ""}, description="Specify resource types for searching: ScreenName=resource/type1:resource/type2... etc.")
    public static final String RT_FILTERS = "resourceType.filters";
    public static final String CONFIG_PARSE_PATTERN = "=|:";
    public static final String CONFIG_FILTER_GROUP_PREFIX = "filterGroup.";
    public static final Map<String, List<String>> DEFAULT_CONTENT_TYPES_MAP = new LinkedHashMap<String, List<String>>(5);
    private static final Logger LOG;
    private static final String UTILITY_READER = "communities-utility-reader";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private ConfigurationAdmin configurationAdmin;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    @Reference
    private ResourceResolverFactory rrf;
    private Map<String, List<String>> resourceTypeFilters;
    private FilterGroupImpl filterGroup;

    @Override
    public SocialComponent getSocialComponent(Resource resource) {
        this.filterGroup = new FilterGroupImpl(resource, this.getClientUtilities(resource.getResourceResolver()), this.getResourceTypeFilterNames(), this.getCommunitiesUtilResolver(resource));
        return this.filterGroup;
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, SlingHttpServletRequest request) {
        this.filterGroup = new FilterGroupImpl(resource, this.getClientUtilities(request), this.getResourceTypeFilterNames(), this.getCommunitiesUtilResolver(resource));
        return this.filterGroup;
    }

    @Override
    public SocialComponent getSocialComponent(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryRequestInfo) {
        this.filterGroup = new FilterGroupImpl(resource, clientUtils, this.getResourceTypeFilterNames(), this.getCommunitiesUtilResolver(resource));
        return this.filterGroup;
    }

    @Override
    public String getSupportedResourceType() {
        return "social/moderation/filters";
    }

    public List<String> getResourceTypeFilterNames() {
        if (this.resourceTypeFilters == null) {
            this.setResourceTypeFilters(null);
        }
        return new ArrayList<String>(this.resourceTypeFilters.keySet());
    }

    public Map<String, List<String>> getResourceTypeFilters() {
        if (this.resourceTypeFilters == null) {
            this.setResourceTypeFilters(null);
        }
        return this.resourceTypeFilters;
    }

    private void setResourceTypeFilters(ComponentContext context) {
        this.resourceTypeFilters = new LinkedHashMap<String, List<String>>();
        try {
            Dictionary<String, Object> configProperties;
            if (context == null) {
                Configuration configuration = this.configurationAdmin.getConfiguration(SERVICE_PID);
                configProperties = configuration.getProperties();
            } else {
                configProperties = context.getProperties();
            }
            String[] rawResourceTypes = (String[])configProperties.get(RT_FILTERS);
            if (this.resourceTypeFilters.size() == 0) {
                LOG.info("No resourceType filters from configuration found.  Default filters will be used.");
            }
            if (rawResourceTypes != null && rawResourceTypes.length != 0) {
                for (String resourceTypeEntry : rawResourceTypes) {
                    String[] filterEntry = resourceTypeEntry.split(CONFIG_PARSE_PATTERN);
                    if (filterEntry == null || filterEntry.length < 2) {
                        LOG.error("Resource types in configuration must contain a name and at least one resource type. [{}]", (Object)resourceTypeEntry);
                        continue;
                    }
                    ArrayList<String> types = new ArrayList<String>(5);
                    types.addAll(Arrays.asList(Arrays.copyOfRange(filterEntry, 1, filterEntry.length)));
                    if (DEFAULT_CONTENT_TYPES_MAP.containsKey(filterEntry[0])) {
                        types.addAll((Collection)DEFAULT_CONTENT_TYPES_MAP.get(filterEntry[0]));
                    }
                    this.resourceTypeFilters.put(filterEntry[0], types);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Unable to read resourceType filters from configuration.", e);
        }
        catch (NullPointerException npe) {
            LOG.error("Unable to read resourceType filters from configuration.", npe);
        }
        for (Map.Entry<String, List<String>> defaultType : DEFAULT_CONTENT_TYPES_MAP.entrySet()) {
            String name = defaultType.getKey();
            List<String> types = defaultType.getValue();
            if (this.resourceTypeFilters.containsKey(name)) continue;
            this.resourceTypeFilters.put(name, types);
        }
    }

    @Override
    protected void activate(ComponentContext context) {
        this.setResourceTypeFilters(context);
    }

    private ResourceResolver getCommunitiesUtilResolver(Resource resource) {
        ResourceResolver utilityReaderResolver = null;
        try {
            utilityReaderResolver = this.serviceUserWrapper.getServiceResourceResolver(this.rrf, Collections.singletonMap("sling.service.subservice", UTILITY_READER));
        }
        catch (LoginException e) {
            LOG.debug("login exception for service user communities-utility-reader");
        }
        if (utilityReaderResolver == null) {
            utilityReaderResolver = resource.getResourceResolver();
        }
        return utilityReaderResolver;
    }

    static {
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_COMMENT, Arrays.asList(DEFAULT_COMMENT_RT, DEFAULT_COMMENT_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_FORUM_TOPIC, Arrays.asList(DEFAULT_FORUM_TOPIC_RT, DEFAULT_FORUM_TOPIC_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_FORUM_REPLY, Arrays.asList(DEFAULT_FORUM_REPLY_RT, DEFAULT_FORUM_REPLY_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_QNA_QUESTION, Arrays.asList(DEFAULT_QNA_QUESTION_RT, DEFAULT_QNA_QUESTION_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_QNA_ANSWER, Arrays.asList(DEFAULT_QNA_ANSWER_RT, DEFAULT_QNA_ANSWER_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_BLOGS, Arrays.asList(DEFAULT_BLOGS_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_BLOGS_COMMENTS, Arrays.asList(DEFAULT_BLOGS_COMMENTS_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_CALENDAR_EVENTS, Arrays.asList(DEFAULT_CALENDAR_EVENTS_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_CALENDAR_EVENT_COMMENTS, Arrays.asList(DEFAULT_CALENDAR_EVENT_COMMENTS_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_FOLDER, Arrays.asList(DEFAULT_FOLDER_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_FILE, Arrays.asList(DEFAULT_FILE_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_IDEATION_IDEA, Arrays.asList(DEFAULT_IDEATION_HBS_RT));
        DEFAULT_CONTENT_TYPES_MAP.put(DEFAULT_IDEATION_COMMENT, Arrays.asList(DEFAULT_IDEATION_COMMENT_HBS_RT));
        LOG = LoggerFactory.getLogger(FilterGroupSocialComponentFactory.class);
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configurationAdmin == configurationAdmin) {
            this.configurationAdmin = null;
        }
    }

    protected void bindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        this.serviceUserWrapper = serviceUserWrapper;
    }

    protected void unbindServiceUserWrapper(ServiceUserWrapper serviceUserWrapper) {
        if (this.serviceUserWrapper == serviceUserWrapper) {
            this.serviceUserWrapper = null;
        }
    }

    protected void bindRrf(ResourceResolverFactory resourceResolverFactory) {
        this.rrf = resourceResolverFactory;
    }

    protected void unbindRrf(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrf == resourceResolverFactory) {
            this.rrf = null;
        }
    }
}

