/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.client.api;

import com.adobe.cq.social.badging.api.BadgingService;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.group.api.GroupUtil;
import com.adobe.cq.social.group.client.api.CommunityGroupUser;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.AbstractUser;
import com.adobe.cq.social.scoring.api.ScoringService;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.security.user.UserPropertiesManager;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCommunityGroupUser
extends AbstractUser
implements CommunityGroupUser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityGroupUser.class);
    private final CommunityContext context;
    private final ServiceUserWrapper serviceUserWrapper;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private final SlingRepository repository;
    private static final String ABSRACT = "aboutMe";
    private static final String USER_ADMIN = "communities-user-admin";

    public AbstractCommunityGroupUser(Resource resource, ClientUtilities clientUtilities, UserPropertiesManager upm, ScoringService scoringService, BadgingService badgingService, ServiceUserWrapper serviceUserWrapper, SlingRepository repository) {
        super(resource, clientUtilities, upm, scoringService, badgingService);
        this.context = this.clientUtils.getRequest().getResource().adaptTo(CommunityContext.class);
        this.serviceUserWrapper = serviceUserWrapper;
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isAdmin() {
        Session userAdminSession = null;
        try {
            userAdminSession = this.serviceUserWrapper.loginService(this.repository, USER_ADMIN);
            userAdminSession.refresh(true);
            UserManager um = ((JackrabbitSession)userAdminSession).getUserManager();
            if (um == null) {
                Boolean bl = false;
                return bl;
            }
            String groupId = this.clientUtils.getRequest().getParameter("groupId");
            if (StringUtils.isEmpty(groupId)) {
                Boolean bl = this.context.checkIfUserIsGroupAdmin(um, this.getAuthorizableId());
                return bl;
            }
            Boolean bl = GroupUtil.isMember(um, groupId, this.getAuthorizableId()) || this.context.checkIfUserIsGroupAdmin(um, this.getAuthorizableId());
            return bl;
        }
        catch (RepositoryException e) {
            LOG.error("failed to check if user " + this.getAuthorizableId() + " is group admin ", e);
            Boolean bl = false;
            return bl;
        }
        finally {
            if (userAdminSession != null) {
                userAdminSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanInvite() {
        Session userAdminSession = null;
        boolean canInviteGroupMember = false;
        try {
            userAdminSession = this.serviceUserWrapper.loginService(this.repository, USER_ADMIN);
            userAdminSession.refresh(true);
            UserManager um = ((JackrabbitSession)userAdminSession).getUserManager();
            if (this.getUserId().equals(this.clientUtils.getAuthorizedUserId())) {
                boolean bl = false;
                return bl;
            }
            ResourceResolver resolver = this.clientUtils.getRequest().getResourceResolver();
            canInviteGroupMember = GroupUtil.canInviteGroupMember(resolver, this.context, this.serviceUserWrapper, this.repository, um);
        }
        catch (RepositoryException e) {
            LOG.error("Unable to check if user can invite", e);
        }
        finally {
            if (userAdminSession != null) {
                userAdminSession.logout();
            }
        }
        return canInviteGroupMember;
    }

    @Override
    public String getDescription() {
        UserProperties userProps = this.getUserProperties();
        try {
            if (userProps != null) {
                return userProps.getProperty(ABSRACT);
            }
            return null;
        }
        catch (RepositoryException e) {
            LOG.error("Error retrieving description for " + userProps.getAuthorizableID(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanPromote() {
        Session userAdminSession = null;
        boolean canPromoteGroupMember = false;
        try {
            userAdminSession = this.serviceUserWrapper.loginService(this.repository, USER_ADMIN);
            userAdminSession.refresh(true);
            UserManager um = ((JackrabbitSession)userAdminSession).getUserManager();
            if (this.getUserId().equals(this.clientUtils.getAuthorizedUserId())) {
                boolean bl = false;
                return bl;
            }
            ResourceResolver resolver = this.clientUtils.getRequest().getResourceResolver();
            canPromoteGroupMember = GroupUtil.canPromoteGroupMember(resolver, this.context, this.serviceUserWrapper, this.repository, um);
        }
        catch (RepositoryException e) {
            LOG.error("Unable to check if user can promote", e);
        }
        finally {
            if (userAdminSession != null) {
                userAdminSession.logout();
            }
        }
        return canPromoteGroupMember;
    }
}

