/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.group.client.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.group.api.GroupUtil;
import com.adobe.cq.social.group.client.api.CommunityGroupMemberListComponent;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.serviceusers.internal.ServiceUserWrapper;
import com.adobe.cq.social.user.api.AbstractCommunityAuthorizableCollection;
import com.adobe.granite.security.user.UserPropertiesService;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCommunityGroupMemberListComponent
extends AbstractCommunityAuthorizableCollection
implements CommunityGroupMemberListComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCommunityGroupMemberListComponent.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    @Reference
    private ServiceUserWrapper serviceUserWrapper;
    private final PageInfo pageInfo;
    private final CommunityContext context;
    private static final String USER_ADMIN = "communities-user-admin";

    public AbstractCommunityGroupMemberListComponent(Resource resource, ClientUtilities utilities, QueryRequestInfo queryRequestInfo, UserPropertiesService userPropertiesService, UserManager userManager, ServiceUserWrapper serviceUserWrapper, SlingRepository repository) {
        super(resource, utilities, userManager, queryRequestInfo);
        ResourceResolver resolver = resource.getResourceResolver();
        this.context = resource.adaptTo(CommunityContext.class);
        this.pageInfo = new PageInfo(this, utilities, this.pagination);
        this.serviceUserWrapper = serviceUserWrapper;
        this.repository = repository;
    }

    @Override
    public int getTotalSize() {
        int size = this.getItems().size();
        if (size < 10) {
            return ((int)this.pageInfo.getSelectedPage() - 1) * 10 + size;
        }
        return (int)this.pageInfo.getSelectedPage() * 10 + 1;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Override
    protected String getChildResourceType() {
        return "social/group/components/hbs/communitygroupmember";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanInvite() {
        ResourceResolver resolver = this.clientUtils.getRequest().getResourceResolver();
        Session userAdminSession = null;
        boolean canInviteGroupMember = false;
        try {
            userAdminSession = this.serviceUserWrapper.loginService(this.repository, USER_ADMIN);
            userAdminSession.refresh(true);
            UserManager um = ((JackrabbitSession)userAdminSession).getUserManager();
            canInviteGroupMember = GroupUtil.canInviteGroupMember(resolver, this.context, this.serviceUserWrapper, this.repository, um);
        }
        catch (RepositoryException e) {
            LOG.error("Unable to check if user can invite", e);
        }
        finally {
            if (userAdminSession != null) {
                userAdminSession.logout();
            }
        }
        return canInviteGroupMember;
    }
}

