/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.graph.client.endpoint;

import com.adobe.cq.social.graph.Edge;
import com.adobe.cq.social.graph.Vertex;
import com.adobe.cq.social.graph.client.api.Following;
import com.adobe.cq.social.graph.client.api.MutableFollowing;
import com.adobe.cq.social.graph.client.endpoint.FollowingOperations;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.operations.AbstractOperationService;
import com.adobe.granite.socialgraph.SocialGraphException;
import java.util.HashMap;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractFollowingOperationService<T extends OperationExtension, U extends Operation>
extends AbstractOperationService<T, U, Following>
implements FollowingOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFollowingOperationService.class);
    @Reference
    private SocialComponentFactoryManager componentFactoryManager;

    private Following getSocialComponent(Resource following, SlingHttpServletRequest request) {
        SocialComponentFactory factory;
        Resource resource = following;
        if (ResourceUtil.isNonExistingResource(resource)) {
            resource = new SyntheticResource(following.getResourceResolver(), "/social/socialgraph/" + Text.getName(this.getResourceType()), this.getResourceType());
        }
        return (Following)((factory = this.componentFactoryManager.getSocialComponentFactory(resource)) != null ? factory.getSocialComponent(following, request) : null);
    }

    @Override
    public SocialComponent follow(SlingHttpServletRequest request) throws OperationException {
        Following following;
        Resource resource = request.getResource();
        try {
            following = this.getSocialComponent(resource, request);
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("user information is missing", e, 400);
        }
        try {
            if (following != null) {
                if (following.getIsFollowed()) {
                    throw new OperationException(following.getUser().getName() + " is already followed " + following.getFollowedId(), 400);
                }
                U followOperation = this.getFollowOperation();
                HashMap<String, Object> requestParams = new HashMap<String, Object>();
                RequestParameterMap params = request.getRequestParameterMap();
                for (String key : params.keySet()) {
                    requestParams.put(key, params.getValue(key).getString());
                }
                ResourceResolver resolver = resource.getResourceResolver();
                Session session = resolver.adaptTo(Session.class);
                this.performBeforeActions(followOperation, session, resource, requestParams);
                Vertex node = following.userNode();
                Vertex other = following.followedNode();
                String relType = following.getIsFollowedUser() ? "USER" : "RESOURCE";
                node.createRelationshipTo(other, this.getRelationshipType(request), relType);
                following.socialGraph().save();
                if (following instanceof MutableFollowing) {
                    ((MutableFollowing)following).setFollowingState(true);
                } else {
                    following = this.getSocialComponent(resource, request);
                }
                if (following != null) {
                    this.performAfterActions(followOperation, session, following, requestParams);
                    return following;
                }
            }
        }
        catch (SocialGraphException e) {
            throw new OperationException("Internal error creating following.", e, 500);
        }
        throw new OperationException("Unable to obtain Following component.", 500);
    }

    @Override
    public Following unfollow(SlingHttpServletRequest request) throws OperationException {
        Following following;
        Resource resource = request.getResource();
        try {
            following = this.getSocialComponent(resource, request);
        }
        catch (IllegalArgumentException e) {
            throw new OperationException("user information is missing", e, 400);
        }
        if (following != null) {
            try {
                if (!following.getIsFollowed()) {
                    throw new OperationException(following.getUser().getName() + " is not followed " + following.getFollowedId(), 400);
                }
                U unfollowOperation = this.getUnfollowOperation();
                HashMap<String, Object> requestParams = new HashMap<String, Object>();
                RequestParameterMap params = request.getRequestParameterMap();
                for (String key : params.keySet()) {
                    requestParams.put(key, params.getValue(key).getString());
                }
                ResourceResolver resolver = resource.getResourceResolver();
                Session session = resolver.adaptTo(Session.class);
                this.performBeforeActions(unfollowOperation, session, resource, requestParams);
                Edge edge = following.edge();
                edge.delete();
                if (following instanceof MutableFollowing) {
                    ((MutableFollowing)following).setFollowingState(false);
                } else {
                    following = this.getSocialComponent(resource, request);
                }
                if (following != null) {
                    this.performAfterActions(unfollowOperation, session, following, requestParams);
                    return following;
                }
            }
            catch (SocialGraphException e) {
                throw new OperationException("Failed to perform unfollow operation.", e, 500);
            }
        }
        throw new OperationException("Unable to obtain Following component.", 500);
    }

    protected String getRelationshipType(SlingHttpServletRequest request) {
        return "following";
    }

    protected String getResourceType() {
        return "social/socialgraph/components/hbs/following";
    }

    protected abstract U getFollowOperation();

    protected abstract U getUnfollowOperation();

    protected void bindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        this.componentFactoryManager = socialComponentFactoryManager;
    }

    protected void unbindComponentFactoryManager(SocialComponentFactoryManager socialComponentFactoryManager) {
        if (this.componentFactoryManager == socialComponentFactoryManager) {
            this.componentFactoryManager = null;
        }
    }
}

