/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.forum.client.api;

import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.forum.client.api.ForumConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseForumConfiguration
extends AbstractCommentCollectionConfiguration
implements ForumConfiguration {
    String PN_TAG_FILTER = "taggingFilter";
    String PN_TAG_FILTER_LIMIT = "tagFilterLimit";
    private final boolean isTaggingAllowed;
    private final ValueMap forumProperties;
    private final String[] tagFilterVal;
    private final long tagFilterLimitVal;
    private final boolean isUsingPriviligedUsers;
    private static final Logger LOG = LoggerFactory.getLogger(BaseForumConfiguration.class);

    public BaseForumConfiguration(Resource forumResource) {
        super(forumResource);
        this.forumProperties = forumResource.adaptTo(ValueMap.class);
        this.isTaggingAllowed = this.forumProperties != null ? this.forumProperties.get("allowTagging", false) : false;
        this.tagFilterVal = this.forumProperties != null ? (String[])this.forumProperties.get(this.PN_TAG_FILTER, String[].class) : new String[]{};
        this.tagFilterLimitVal = this.forumProperties != null ? (long)this.forumProperties.get(this.PN_TAG_FILTER_LIMIT, -1).intValue() : -1L;
        String[] privilegedUserGroups = this.forumProperties != null ? (String[])this.forumProperties.get("cq:privilegedMembers", String[].class) : new String[]{};
        this.isUsingPriviligedUsers = privilegedUserGroups != null && privilegedUserGroups.length > 0;
    }

    @Override
    @JsonProperty(value="isTaggingAllowed")
    public boolean isTaggingAllowed() {
        return this.isTaggingAllowed;
    }

    protected ValueMap getForumProperties() {
        return this.forumProperties;
    }

    @Override
    public String getTagFilterVal() {
        if (this.tagFilterVal == null || this.tagFilterVal.length < 1) {
            return null;
        }
        String out = this.tagFilterVal[0];
        for (int i = 1; i < this.tagFilterVal.length; ++i) {
            out = out + "," + this.tagFilterVal[i];
        }
        return out;
    }

    @Override
    public long getTagFilterLimit() {
        return this.tagFilterLimitVal;
    }

    @Override
    public boolean isBreadcrumbsEnabled() {
        return this.forumProperties == null ? true : this.forumProperties.get("showCrumbs", true);
    }

    @Override
    public boolean isUsingPrivilegedUsers() {
        return this.isUsingPriviligedUsers;
    }
}

