/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.filelibrary.client.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class FileLibraryBreadcrumb {
    private final String title;
    private final String path;
    private final boolean current;

    public FileLibraryBreadcrumb(String title, String path) {
        this(title, path, false);
    }

    public FileLibraryBreadcrumb(String title, String path, boolean current) {
        this.title = title;
        this.path = path;
        this.current = current;
    }

    public FileLibraryBreadcrumb(Resource resource) {
        this(resource, false);
    }

    public FileLibraryBreadcrumb(Resource resource, boolean current) {
        if (resource != null) {
            this.path = resource.getPath();
            ValueMap valueMap = ResourceUtil.getValueMap(resource);
            this.title = valueMap != null ? valueMap.get("jcr:title", "Unknown") : "Unknown";
        } else {
            this.path = "Unknown";
            this.title = "Unknown";
        }
        this.current = current;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isCurrent() {
        return this.current;
    }
}

