/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.events;

import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.day.text.Text;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.service.event.Event;

public class CommentEvent
extends SocialEvent<CommentActions> {
    private static final long serialVersionUID = 1L;
    public static final String COMMENT_TOPIC = "comment";
    private static final String COMMENT_SYSTEM_PATH = "COMMENT_SYSTEM_PATH";
    public static final String VERBS_CHANGESTATE = "Updated status";
    public static final String VERBS_ALLOW = "allow";
    public static final String VERBS_REOPEN = "reopen";
    private static final String MENTIONS = "mentions";

    public CommentEvent(Comment comment, String userId, CommentActions action) {
        super(COMMENT_TOPIC, comment.getResource().getPath(), userId, action, new SocialEvent.BaseEventObject(CommentEvent.getTitle(comment, action), comment.getResource().getPath(), COMMENT_TOPIC), new SocialEvent.BaseEventObject(CommentEvent.getTargetname(comment), comment.getParentComponent() != null ? comment.getParentComponent().getResource().getPath() : comment.getSourceComponentId(), "collection"), CommentEvent.additionalData(comment, action));
    }

    private static String getTitle(Comment comment, CommentActions action) {
        String name;
        String string = name = action.getVerb().equals("delete") ? "" : CommentEvent.getObjectName(comment.getResource());
        if (StringUtils.isNotEmpty(name)) {
            return name;
        }
        return "a comment";
    }

    private static Map<String, Object> additionalData(Comment comment, CommentActions action) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(COMMENT_SYSTEM_PATH, comment.getParentComponent() != null ? comment.getParentComponent().getResource().getPath() : comment.getSourceComponentId());
        CommentEvent.addMentionsData(comment, action, data);
        return data;
    }

    private static void addMentionsData(Comment comment, CommentActions action, Map<String, Object> data) {
        if (!action.getVerb().equals("delete") && comment.getProperties().get(MENTIONS) != null) {
            data.put(MENTIONS, comment.getProperties().get(MENTIONS));
        }
    }

    protected static String getObjectName(Resource resource) {
        String title = null;
        ValueMap vm = ResourceUtil.getValueMap(resource);
        title = (String)((Object)vm.get("jcr:title", String.class));
        if (StringUtils.isEmpty(title)) {
            title = "a " + Text.getName(resource.getResourceType());
        }
        return title;
    }

    protected static String getTargetname(Comment comment) {
        ValueMap vm;
        String title = null;
        SocialComponent component = comment.getParentComponent();
        if (component != null && StringUtils.isEmpty(title = (String)((Object)(vm = ResourceUtil.getValueMap(component.getResource())).get("jcr:title", String.class)))) {
            title = Text.getName(component.getId().getResourceIdentifier());
            if (component.getResource().isResourceType("social/commons/components/hbs/comments/comment")) {
                title = StringUtils.substringAfterLast(title, "-");
            }
        }
        if (StringUtils.isEmpty(title)) {
            title = Text.getName(comment.getSourceComponentId());
        }
        return title;
    }

    private CommentEvent(Event event) {
        super(event);
    }

    public String getCommentSystemPath() {
        return (String)this.getProperty(COMMENT_SYSTEM_PATH);
    }

    public static CommentEvent fromEvent(Event event) {
        if ("com/adobe/cq/social/comment".equals(event.getTopic())) {
            return new CommentEvent(event);
        }
        return null;
    }

    public static enum CommentActions implements SocialEvent.SocialActions
    {
        CREATED,
        REPLIED,
        EDITED,
        DELETED,
        CHANGESTATE,
        ALLOW,
        CLOSE,
        REOPEN;


        @Override
        public String getVerb() {
            switch (this) {
                case CREATED: {
                    return "post";
                }
                case REPLIED: {
                    return "add";
                }
                case EDITED: {
                    return "update";
                }
                case DELETED: {
                    return "delete";
                }
                case CLOSE: {
                    return "close";
                }
                case CHANGESTATE: {
                    return CommentEvent.VERBS_CHANGESTATE;
                }
                case ALLOW: {
                    return CommentEvent.VERBS_ALLOW;
                }
                case REOPEN: {
                    return CommentEvent.VERBS_REOPEN;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

