/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.states.internal;

import com.adobe.cq.social.commons.comments.states.internal.Role;
import com.adobe.cq.social.commons.comments.states.internal.State;
import com.adobe.cq.social.commons.comments.states.internal.StateOperation;
import com.adobe.cq.social.scf.OperationException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public abstract class AbstractStateOperation
implements StateOperation {
    private static final String PROPERTY_STATE = "state_s";

    @Override
    public void perform(Resource resource, State state, String toState, Role role, ResourceResolver resolver) throws OperationException {
        if (state == null || role == null || resource == null) {
            throw new OperationException("Null parameter", 400);
        }
        if (!state.canPerformOperation(role.getTitle(), this.getTitle())) {
            throw new OperationException("Opeation is not allowed for " + role.getTitle() + " on " + resource.getPath() + " in state " + state.getTitle(), 403);
        }
        try {
            Resource res = resolver.getResource(resource.getPath());
            ModifiableValueMap properties = res.adaptTo(ModifiableValueMap.class);
            properties.put(PROPERTY_STATE, toState);
            resolver.commit();
        }
        catch (PersistenceException e) {
            throw new OperationException("Failed to update comment", e, 500);
        }
    }
}

