/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.states.internal;

import com.adobe.cq.social.commons.comments.states.internal.Role;
import com.adobe.cq.social.commons.comments.states.internal.State;
import com.adobe.cq.social.commons.comments.states.internal.StateMachine;
import com.adobe.cq.social.commons.comments.states.internal.StateOperation;
import com.adobe.cq.social.scf.OperationException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public abstract class AbstractState
implements State {
    private StateMachine stateMachine;
    private String title;
    private List<RolePermissions> rolePermissions;

    public List<RolePermissions> getRolePermissions() {
        return this.rolePermissions;
    }

    public void setStateMachine(StateMachine parent) {
        this.stateMachine = parent;
    }

    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    public Role getRole(String role) {
        return this.stateMachine.getRole(role);
    }

    public StateOperation getStateOperation(String operation) {
        return this.stateMachine.getOperation(operation);
    }

    @Override
    public void performOperation(Resource resource, ResourceResolver resolver, String role, String operation, String toState) throws OperationException {
        StateOperation op = this.getStateOperation(operation);
        Role roleObj = this.getRole(role);
        op.perform(resource, this, toState, roleObj, resolver);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<String> getNextStatesForRole(String role) {
        if (this.rolePermissions != null && !this.rolePermissions.isEmpty()) {
            for (RolePermissions permissions : this.rolePermissions) {
                if (!StringUtils.equalsIgnoreCase(permissions.getTitle(), role)) continue;
                return permissions.getNextStates();
            }
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOperationsForRole(String role) {
        if (this.rolePermissions != null && !this.rolePermissions.isEmpty()) {
            for (RolePermissions permissions : this.rolePermissions) {
                if (!StringUtils.equalsIgnoreCase(permissions.getTitle(), role)) continue;
                return permissions.getOperations();
            }
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean canPerformOperation(String role, String operation) {
        List<String> operations = this.getOperationsForRole(role);
        if (operations != null) {
            return operations.contains(operation);
        }
        return false;
    }

    @Override
    public boolean canTransition(String role, String state) {
        List<String> states = this.getNextStatesForRole(role);
        if (states != null) {
            return states.contains(state);
        }
        return false;
    }

    public static class RolePermissions {
        String title;
        List<String> operations;
        List<String> nextStates;

        public String getTitle() {
            return this.title;
        }

        public List<String> getOperations() {
            return this.operations;
        }

        public List<String> getNextStates() {
            return this.nextStates;
        }
    }
}

