/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class AbstractCommentCollectionConfiguration
implements CommentCollectionConfiguration {
    private boolean allowsVoting;
    private boolean isRTEEnabled;
    private boolean allowsAttachment;
    private final boolean allowsTranslateAllButton;
    private final boolean allowsFlagging;
    private final boolean allowsClose;
    private final boolean allowsPin;
    private final boolean allowsDeny;
    private final boolean allowsEdit;
    private final boolean allowsReply;
    private final boolean allowsFollowing;
    private final boolean allowsSubscriptions;
    private final boolean allowsFeaturedContent;
    private boolean allowsDelete;
    private boolean allowsMove;
    private boolean allowsCustomFlagReason = true;
    private int pageSize = 10;
    private final ValueMap configValueMap;
    private final CollectionSortedOrder sortOrder;
    private final String[] sortField;
    private final String[] sortFieldOrder;
    private final String[] sortByList;
    private List<Map.Entry<String, Boolean>> sortFields = new ArrayList<Map.Entry<String, Boolean>>();
    private String timeSelector = "total_tl";
    private List<String> sortByItemsList = new ArrayList<String>();
    private boolean doNotGetRepliesOnListingPage;
    private final int thumbnailSize;
    private final long minImageSizeForThumbnail;
    private final boolean enableMentions;
    private final int maxMentions;
    private final String uiMentionPattern;

    public AbstractCommentCollectionConfiguration(Resource commentSystem) {
        this(ResourceUtil.getValueMap(commentSystem));
    }

    public AbstractCommentCollectionConfiguration(@Nonnull ValueMap vm) {
        int i;
        this.allowsVoting = vm.get("allowVoting", false);
        this.allowsEdit = true;
        this.pageSize = vm.get("maxPerPage", 10);
        this.allowsTranslateAllButton = vm.get("allowTranslateAllButton", false);
        this.allowsCustomFlagReason = vm.get("allowCustomFlagReason", false);
        this.allowsAttachment = vm.get("allowFileUploads", false);
        this.isRTEEnabled = vm.get("rteEnabled", false);
        this.allowsDeny = vm.get("allowDenyComments", false);
        this.allowsFlagging = vm.get("allowFlagComments", false);
        this.allowsFollowing = vm.get("allowFollowing", false);
        this.allowsSubscriptions = vm.get("allowSubscriptions", false);
        this.allowsReply = vm.get("allowRepliesToComments", false);
        this.allowsMove = vm.get("allowMoves", false);
        this.allowsClose = vm.get("allowCloseComments", false);
        this.allowsPin = vm.get("allowPinning", false);
        this.allowsDelete = vm.get("allowDeleteComments", false);
        this.allowsFeaturedContent = vm.get("allowFeaturedContent", false);
        this.doNotGetRepliesOnListingPage = vm.get("doNotGetRepliesOnListingPage", false);
        this.thumbnailSize = vm.get("thumbnailSize", 800);
        this.minImageSizeForThumbnail = vm.get("minImageSizeForThumbnail", 100000L);
        this.enableMentions = vm.get("enableMentions", false);
        this.maxMentions = vm.get("maxMentions", 10);
        this.uiMentionPattern = vm.get("uiMentionPattern", "");
        String sortOrderValue = vm.get("sortOrder", "DESC");
        this.sortField = vm.get("sortField", new String[]{"added"});
        this.sortFieldOrder = vm.get("sortFieldOrder", new String[0]);
        this.sortByList = vm.get("sortBy", new String[]{"newest", "added", "latestActivityDate_dt"});
        this.timeSelector = vm.get("timeSelector", this.timeSelector);
        int sortFieldOrderLength = this.sortFieldOrder.length;
        for (i = 0; i < this.sortByList.length; ++i) {
            this.sortByItemsList.add(this.sortByList[i]);
        }
        for (i = 0; i < this.sortField.length; ++i) {
            String orderString = "desc";
            if (i < sortFieldOrderLength) {
                orderString = this.sortFieldOrder[i];
            }
            boolean ascendingOrder = false;
            if (StringUtils.equals(orderString, "asc")) {
                ascendingOrder = true;
            }
            this.sortFields.add(new AbstractMap.SimpleEntry<String, Boolean>(this.sortField[i].replace("jcr_", "jcr:"), ascendingOrder));
        }
        this.sortOrder = StringUtils.equalsIgnoreCase("asc", sortOrderValue) ? CollectionSortedOrder.DEFAULT_ORDER : CollectionSortedOrder.REVERSED_ORDER;
        this.configValueMap = vm;
    }

    @Override
    @JsonProperty(value="enableMentions")
    public boolean isMentionsEnabled() {
        return this.enableMentions;
    }

    @Override
    @JsonProperty(value="maxMentions")
    public int getMaxMentions() {
        return this.maxMentions;
    }

    @Override
    @JsonProperty(value="uiMentionPattern")
    public String getUIMentionPattern() {
        return this.uiMentionPattern;
    }

    @Override
    @JsonProperty(value="thumbnailSize")
    public int getThumbNailSize() {
        return this.thumbnailSize;
    }

    @Override
    @JsonProperty(value="minImageSizeForThumbnail")
    public long getMinimumImgSizeForThumbnail() {
        return this.minImageSizeForThumbnail;
    }

    @Override
    @JsonProperty(value="isVotingAllowed")
    public boolean isVotingAllowed() {
        return this.allowsVoting;
    }

    @Override
    @JsonProperty(value="isAttachmentAllowed")
    public boolean isAttachmentAllowed() {
        return this.allowsAttachment;
    }

    @Override
    @JsonProperty(value="isRTEEnabled")
    public boolean isRTEEnabled() {
        return this.isRTEEnabled;
    }

    @Override
    @JsonProperty(value="isCustomFlagReasonAllowed")
    public boolean isCustomFlagReasonAllowed() {
        return this.allowsCustomFlagReason;
    }

    @Override
    @JsonProperty(value="isTranslateAllButtonAllowed")
    public boolean isTranslateAllButtonAllowed() {
        return this.allowsTranslateAllButton;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    @JsonProperty(value="isFlaggingAllowed")
    public boolean isFlaggingAllowed() {
        return this.allowsFlagging;
    }

    @Override
    @JsonProperty(value="isCloseAllowed")
    public boolean isCloseAllowed() {
        return this.allowsClose;
    }

    @Override
    @JsonProperty(value="isPinAllowed")
    public boolean isPinAllowed() {
        return this.allowsPin;
    }

    @Override
    @JsonProperty(value="isDenyAllowed")
    public boolean isDenyAllowed() {
        return this.allowsDeny;
    }

    @Override
    @JsonProperty(value="isEditAllowed")
    public boolean isEditAllowed() {
        return this.allowsEdit;
    }

    @Override
    @JsonProperty(value="isReplyAllowed")
    public boolean isReplyAllowed() {
        return this.allowsReply;
    }

    @Override
    @JsonProperty(value="isDeleteAllowed")
    public boolean isDeleteAllowed() {
        return this.allowsDelete;
    }

    protected void setAllowsMove(boolean allowsMove) {
        this.allowsMove = allowsMove;
    }

    protected void setAllowsDelete(boolean flag) {
        this.allowsDelete = flag;
    }

    protected void setAllowsAttachment(boolean flag) {
        this.allowsAttachment = flag;
    }

    protected void setAllowsVoting(boolean flag) {
        this.allowsVoting = flag;
    }

    protected void setRTEEnabled(boolean flag) {
        this.isRTEEnabled = flag;
    }

    @Nonnull
    protected ValueMap getConfigValueMap() {
        return this.configValueMap;
    }

    @Override
    public boolean isFollowingAllowed() {
        return this.allowsFollowing;
    }

    @Override
    public boolean isSubscriptionsAllowed() {
        return this.allowsSubscriptions;
    }

    @Override
    public CollectionSortedOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isMoveAllowed() {
        return this.allowsMove;
    }

    @Override
    public List<Map.Entry<String, Boolean>> getSortFields() {
        return this.sortFields;
    }

    @Override
    public List<String> getSortByItemsList() {
        return this.sortByItemsList;
    }

    @Override
    public String getAnalyticsTimeSelector() {
        return this.timeSelector;
    }

    @Override
    @JsonProperty(value="isFeaturingContentAllowed")
    public boolean isFeaturingContentAllowed() {
        return this.allowsFeaturedContent;
    }

    @Override
    @JsonProperty(value="doNotGetRepliesOnListingPage")
    public boolean isDoNotGetRepliesOnListingPage() {
        return this.doNotGetRepliesOnListingPage;
    }
}

