/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons.comments.api;

import com.adobe.cq.social.commons.Attachment;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.CommentSystem;
import com.adobe.cq.social.commons.CommentUtil;
import com.adobe.cq.social.commons.comments.api.AbstractCommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.Comment;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.commons.comments.api.PageInfo;
import com.adobe.cq.social.commons.comments.impl.TransientPropertyHelper;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentList;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProvider;
import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.commons.comments.states.internal.State;
import com.adobe.cq.social.commons.comments.states.internal.StateMachine;
import com.adobe.cq.social.commons.moderation.api.FlagReason;
import com.adobe.cq.social.commons.tagging.SocialTagManager;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.User;
import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.srp.SocialResource;
import com.adobe.cq.social.srp.SocialResourceProvider;
import com.adobe.cq.social.tally.Voting;
import com.adobe.cq.social.tally.client.api.Response;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.adobe.cq.social.tally.client.api.Vote;
import com.adobe.cq.social.translation.TranslationResults;
import com.adobe.cq.social.translation.TranslationSCFUtil;
import com.adobe.cq.social.translation.TranslationUtil;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.SocialResourceUtils;
import com.adobe.granite.security.user.UserProperties;
import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComment<T extends CommentCollectionConfiguration>
extends BaseSocialComponent
implements Comment<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractComment.class);
    private static final String UNKNOWN_USER = "Unknown";
    private static final String JCR_DESCRIPTION_PROP = "jcr:description";
    private static final String JCR_TITLE_PROP = "jcr:title";
    private static String USERS_HOME_UGC = "/home/users/";
    protected final CommentSocialComponentList replies;
    private final User author;
    private final Map<String, Attachment> attachments;
    private final Calendar created;
    private final String message;
    private final String parentPath;
    private final String resourceType;
    private final boolean isTopLevel;
    private final boolean isApproved;
    private boolean isDraft = false;
    private final State state;
    private boolean isScheduled = false;
    private final Calendar publishDate;
    private boolean canEdit = false;
    private boolean canDelete = false;
    private boolean userIsModerator = false;
    private boolean currentUserFlagged = false;
    private String currentUserFlagText = null;
    private String translationAttribution = null;
    private final QueryRequestInfo queryInfo;
    private final boolean isVisible;
    private final boolean isClosed;
    private final boolean isPinned;
    private final boolean isFeatured;
    private final boolean doDisplayTranslation;
    private final boolean displayReplyButton;
    private T configuration;
    private final Comment.ModeratorActions moderatorActions;
    private final Comment.ModeratorStatus moderatorStatus;
    private final String votingRoot;
    private boolean useFlagReasonList = true;
    private boolean useFlagReasons = false;
    private boolean useReferrerUrl;
    private List<FlagReason> flagReasons;
    private CommentSocialComponentListProviderManager commentListProviderManager;
    private final com.adobe.cq.social.commons.Comment comment;
    private SocialComponent parentComponent;
    private SocialComponent sourceComponent;
    private PageInfo pageInfo;
    private String descriptionTranslation = null;
    private String titleTranslation = null;
    private String displayTranslation = null;
    private int MAX_ERROR_MESSAGE_LENGTH = 1000;
    private final String MODERATORS_ROLE = "moderators";
    private final String OWNER_ROLE = "owner";
    private final String EDIT_OPERATION = "Edit";
    private final String DELETE_OPERATION = "Delete";
    private final String PROP_STATE = "state_s";
    private final String ERROR_HTML_FILTER_MESSAGE = "There was something wrong with this post.  Please contact your administrator to fix the issue.";
    private final String FILTER = "filter";
    private final String PAGE = "page has";
    private final String RESOURCE_COMMENTS = "se_social/se_discussion/";
    private final String CATALOG = "catalog.";
    private final String LEARNINGPATH = "learningpath";
    private final String RESOURCE = "resource";
    private final String PROFILE_NODE = "profile";
    private final String ANONYMOUS_USER_ID = "anonymous";
    private String filterFromRequest = null;
    private static final Pattern ANCHOR_MENTION_SOCIAL_AUTHORIZABLE_PATTERN = Pattern.compile("(<a [^<>]*?data-social-mention-authorizableid=\")(.+?)(\"[^<>]*?>)(.+?)(</a>)");
    private static final Pattern MENTION_IDENTIFIER_PATTERN = Pattern.compile("(\\{\\{[^{}]+?\\}\\})");
    private static final Pattern HTML_HREF_TAG_PATTERN = Pattern.compile("\\s*(?i)href\\s*=\"\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))");

    public AbstractComment(Resource resource, ClientUtilities clientUtils, CommentSocialComponentListProviderManager commentListProviderManager) throws RepositoryException {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), commentListProviderManager);
    }

    private String convertMentionsToHtml(String ugc) throws RepositoryException {
        Matcher mentionSocialAuthorizableMatcher = ANCHOR_MENTION_SOCIAL_AUTHORIZABLE_PATTERN.matcher(ugc);
        StringBuffer ugcToDisplay = new StringBuffer();
        while (mentionSocialAuthorizableMatcher.find()) {
            String mentionedUserAuthorizableIdFromUgc = mentionSocialAuthorizableMatcher.group(2);
            User mentionedUser = this.clientUtils.getUser(mentionedUserAuthorizableIdFromUgc, this.resource.getResourceResolver());
            String profileUrl = mentionedUser.getProfileUrl();
            if (profileUrl == null) {
                Matcher hrefMatcher = HTML_HREF_TAG_PATTERN.matcher(mentionSocialAuthorizableMatcher.group(3));
                while (hrefMatcher.find()) {
                    profileUrl = hrefMatcher.group(1);
                }
            }
            String uiMentionPattern = this.getConfiguration().getUIMentionPattern();
            Matcher uiMentionPatternMatcher = MENTION_IDENTIFIER_PATTERN.matcher(uiMentionPattern);
            StringBuffer uiMentionUserStringBuffer = new StringBuffer();
            if (mentionedUser.getAuthorizableId().equals("anonymous")) {
                uiMentionUserStringBuffer.append(mentionedUser.getName());
            } else if (StringUtils.isBlank(uiMentionPattern)) {
                uiMentionUserStringBuffer.append(mentionedUser.getName());
            } else {
                boolean validMentionPattern = false;
                while (uiMentionPatternMatcher.find()) {
                    String userProfilePropertyKey = uiMentionPatternMatcher.group(0);
                    try {
                        String propertyName = userProfilePropertyKey.substring(2, userProfilePropertyKey.length() - 2);
                        String propertyValue = this.clientUtils.getUserProperties(mentionedUser.getAuthorizableId(), "profile").getProperty(propertyName);
                        if (StringUtils.isNotBlank(propertyValue)) {
                            validMentionPattern = true;
                        } else {
                            propertyValue = "";
                        }
                        uiMentionPatternMatcher.appendReplacement(uiMentionUserStringBuffer, propertyValue);
                    }
                    catch (RepositoryException e) {
                        LOG.error("Failed to Fetch Mentioned user profile info", e);
                        throw e;
                    }
                }
                if (validMentionPattern) {
                    uiMentionPatternMatcher.appendTail(uiMentionUserStringBuffer);
                } else {
                    uiMentionUserStringBuffer.append(mentionedUser.getName());
                }
            }
            String ugcMentionedUserAnchor = "<a data-social-mention-authorizableid=\"" + mentionedUser.getAuthorizableId() + "\" href=" + profileUrl + ">" + uiMentionUserStringBuffer + "</a>";
            mentionSocialAuthorizableMatcher.appendReplacement(ugcToDisplay, ugcMentionedUserAnchor);
        }
        mentionSocialAuthorizableMatcher.appendTail(ugcToDisplay);
        return ugcToDisplay.toString();
    }

    public AbstractComment(Resource resource, ClientUtilities clientUtils, QueryRequestInfo queryInfo, CommentSocialComponentListProviderManager commentListProviderManager) throws RepositoryException {
        super(resource, clientUtils);
        TranslationResults results;
        boolean canOwnerDelete;
        this.commentListProviderManager = commentListProviderManager;
        this.comment = resource.adaptTo(com.adobe.cq.social.commons.Comment.class);
        this.author = this.clientUtils.getUser(this.comment.getAuthor().getId(), this.comment.getResource().getResourceResolver());
        this.attachments = this.comment.getAttachments();
        this.created = this.comment.getCreated();
        this.parentPath = this.comment.getComponent().getPath();
        this.isTopLevel = this.comment.isTopLevel();
        if (queryInfo.getPredicates().containsKey("filter") && queryInfo.getPredicates().get("filter")[0].startsWith("page has")) {
            this.filterFromRequest = queryInfo.getPredicates().get("filter")[0].replace("page has", "").trim();
            this.queryInfo = new BaseQueryRequestInfo(false, new HashMap<String, String[]>(), queryInfo.getPagination(), queryInfo.getSortOrder(), queryInfo.getSortBy());
        } else {
            this.queryInfo = queryInfo;
        }
        this.flagReasons = new ArrayList<FlagReason>();
        Session session = resource.getResourceResolver().adaptTo(Session.class);
        String userId = session.getUserID();
        CommentSystem cs = this.comment.getCommentSystem();
        this.isApproved = !this.comment.isSpam() && (this.comment.isApproved() || !cs.isModerated());
        this.userIsModerator = clientUtils.getSocialUtils().hasModeratePermissions(resource);
        this.isDraft = this.comment.getProperty("isDraft", false);
        String currentState = this.comment.getProperty("state_s", "");
        StateMachine stateMachine = resource.adaptTo(StateMachine.class);
        this.state = stateMachine == null ? null : stateMachine.getState(currentState);
        this.isScheduled = this.comment.getProperty("isScheduled", false);
        this.publishDate = (Calendar)((Object)this.comment.getProperty("publishDate", Calendar.class));
        boolean userIsLoggedIn = clientUtils == null ? userId != null && !userId.equalsIgnoreCase("Anonymous") : !clientUtils.userIsAnonymous();
        this.isClosed = this.comment.isClosed();
        this.isPinned = this.comment.getProperty("isPinned_b", false);
        this.isFeatured = this.comment.getProperty("isFeatured_b", false);
        this.useReferrerUrl = cs.getProperty("useReferrer", Boolean.FALSE);
        this.configuration = this.createConfiguration(resource, cs.getResource());
        this.message = this.convertMentionsToHtml(this.comment.getMessage());
        boolean canModEdit = this.state == null ? true : this.state.canPerformOperation("moderators", "Edit");
        boolean canOwnerEdit = this.state == null ? true : this.state.canPerformOperation("owner", "Edit");
        boolean canModDelete = this.state == null ? true : this.state.canPerformOperation("moderators", "Delete");
        boolean bl = canOwnerDelete = this.state == null ? true : this.state.canPerformOperation("owner", "Delete");
        if (this.userIsModerator && canModEdit || this.userIsOwner() && userIsLoggedIn && canOwnerEdit && !this.isClosed) {
            this.canEdit = true;
        }
        if (this.userIsModerator && canModDelete || this.userIsOwner() && userIsLoggedIn && canOwnerDelete && cs.allowsDelete() && !this.isClosed) {
            this.canDelete = true;
        }
        this.isVisible = this.userIsModerator || !this.comment.isSpam() && !this.comment.isFlaggedHidden() && this.isApproved && !this.isDraft;
        this.displayReplyButton = this.canUserReply(userIsLoggedIn, cs, session);
        Comment.ModeratorStatus moderatorStatus = this.moderatorStatus = this.userIsModerator ? new ModeratorStatusImpl(this.comment, cs) : null;
        if (cs.allowsFlagging()) {
            this.useFlagReasonList = cs.useFlagReasonList();
            this.useFlagReasons = this.useFlagReasonList || cs.allowCustomFlagReason();
            Response<Vote> response = this.getFlagResponseForUser(userId);
            if (response != null && response.getResponseValue() != null) {
                this.currentUserFlagged = true;
                if (this.useFlagReasons) {
                    Resource responseResource = response.getResource();
                    ValueMap resourceProperties = responseResource.adaptTo(ValueMap.class);
                    this.currentUserFlagText = resourceProperties.get("social:flagReason", "");
                }
            }
            if (this.userIsModerator && this.useFlagReasons) {
                this.flagReasons = this.listFlagReasons(resource, clientUtils);
            }
        }
        this.moderatorActions = new ModeratorActionsImpl(this.comment, cs, userIsLoggedIn);
        this.resourceType = this.comment.getResource().getResourceType();
        QueryRequestInfo repliesListInfo = QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(this.queryInfo);
        CollectionPagination currentPagination = repliesListInfo.getPagination();
        CollectionPagination repliesPagination = this.configuration.isDoNotGetRepliesOnListingPage() && resource != null && (Boolean)TransientPropertyHelper.getTransientProperty((Resource)resource, (String)"collection", (Object)false) != false ? new CollectionPagination(0, 0, 0, currentPagination.getSortIndex(), this.configuration.getPageSize()) : (currentPagination.getEmbedLevel() != 0 ? new CollectionPagination(0, 0, currentPagination.getEmbedLevel() + 1, currentPagination.getSortIndex(), this.configuration.getPageSize()) : new CollectionPagination(currentPagination.getOffset(), queryInfo.getPagination() == CollectionPagination.DEFAULT_PAGINATION ? this.configuration.getPageSize() : currentPagination.getSize(), currentPagination.getEmbedLevel() + 1, currentPagination.getSortIndex(), this.configuration.getPageSize()));
        repliesListInfo.setPagination(repliesPagination);
        repliesListInfo.setSortOrder(CollectionSortedOrder.DEFAULT_ORDER);
        this.replies = this.getReplies(resource, this, this.filterFromRequest, repliesListInfo);
        Resource component = cs.getResource();
        this.votingRoot = this.configuration.isVotingAllowed() ? CommentUtil.getVotingRoot(component) : "";
        if (!queryInfo.isQuery() && resource.getPath().indexOf(clientUtils.getSocialUtils().getStorageConfig(resource).getAsiPath() + USERS_HOME_UGC) == -1) {
            this.prefetchResources(resource.getResourceResolver(), clientUtils, cs);
            this.doDisplayTranslation = TranslationUtil.doDisplayTranslation(resource.getResourceResolver(), resource, clientUtils);
        } else {
            this.doDisplayTranslation = false;
        }
        this.pageInfo = new PageInfo(this, clientUtils, repliesListInfo.getPagination());
        if ((this.queryInfo.isTranslationRequest() && this.queryInfo.getPagination().getEmbedLevel() == 0 || clientUtils.getRequest() != null && TranslationSCFUtil.isSmartRenderingOn(resource, clientUtils)) && (results = TranslationSCFUtil.getTranslationSCF(resource, clientUtils)) != null) {
            Map<String, String> translations = results.getTranslation();
            this.displayTranslation = results.getDisplay();
            this.translationAttribution = results.getAttribution();
            if (!translations.isEmpty()) {
                this.descriptionTranslation = translations.get(JCR_DESCRIPTION_PROP);
                this.titleTranslation = translations.get(JCR_TITLE_PROP);
            }
        }
    }

    private int getChildIndex(String commentToCheck, int size, List<Map.Entry<String, Boolean>> sortFields) throws CommentException {
        int replyIndex = 0;
        if (this.clientUtils != null) {
            String pathToCheck = this.clientUtils.getCommonStorePath(this.resource);
            SocialResourceProvider srp = SocialResourceUtils.getSocialResource(this.resource).getResourceProvider();
            if (srp != null) {
                replyIndex = srp.getCommentIndex(pathToCheck, "social/commons/components/comments/comment", this.resource.getResourceResolver(), pathToCheck + "/" + commentToCheck.split("/")[0], true);
            }
        }
        if (replyIndex < 0) {
            LOG.warn("Unable to get comment index. Fail to provide direct link to comment");
            replyIndex = 0;
        }
        return replyIndex;
    }

    private CommentSocialComponentList getReplies(Resource resource, AbstractComment abstractComment, String filterFromRequest, QueryRequestInfo repliesListInfo) {
        CollectionPagination repliesPagination = repliesListInfo.getPagination();
        if (filterFromRequest != null) {
            int replyIndex = this.getChildIndex(filterFromRequest, this.configuration.getPageSize(), repliesListInfo.getSortFields());
            int pageNo = replyIndex / this.configuration.getPageSize();
            repliesPagination = new CollectionPagination(pageNo * this.configuration.getPageSize(), this.configuration.getPageSize(), 1, repliesPagination.getSortIndex(), this.configuration.getPageSize());
            repliesListInfo.setPagination(repliesPagination);
        }
        CommentSocialComponentListProvider listProvider = this.commentListProviderManager.getCommentSocialComponentListProvider(resource, repliesListInfo);
        CommentSocialComponentList replies = listProvider.getCommentSocialComponentList(abstractComment, repliesListInfo, this.clientUtils);
        return replies;
    }

    protected boolean canUserReply(boolean userIsLoggedIn, CommentSystem cs, Session session) {
        boolean result = false;
        if (userIsLoggedIn) {
            SocialUtils socialUtils = this.clientUtils.getSocialUtils();
            if (socialUtils != null) {
                String aclPath = socialUtils.resourceToACLPath(cs.getResource());
                boolean mayPost = this.clientUtils.getSocialUtils().canAddNode(session, aclPath == null ? "/content/usergenerated" : aclPath);
                result = cs.allowsReplies() && !this.isClosed && mayPost;
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    private void prefetchResources(ResourceResolver resolver, ClientUtilities clientUtils, CommentSystem cs) {
        if (!SocialResourceUtils.isSocialResource(this.resource)) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>(3);
        if (clientUtils.isTranslationServiceConfigured(this.resource)) {
            String s;
            ValueMap vm;
            paths.add(this.resource.getPath() + "/" + "translation");
            if (!this.isTopLevel && (vm = this.resource.adaptTo(ValueMap.class)) != null && (s = (String)((Object)vm.get("social:parentid", String.class))) != null) {
                paths.add(s + "/" + "translation");
            }
        }
        if (this.configuration.isVotingAllowed()) {
            paths.add(this.resource.getPath() + "/" + this.votingRoot);
            if (!clientUtils.userIsAnonymous()) {
                paths.add(this.resource.getPath() + "/" + this.votingRoot + "/" + clientUtils.getAuthorizedUserId());
            }
        }
        if (!paths.isEmpty()) {
            SocialResourceProvider srp = SocialResourceUtils.getSocialResource(this.resource).getResourceProvider();
            srp.getResources(resolver, paths);
        }
    }

    protected T createConfiguration(Resource resource, Resource commentSystem) {
        if (ResourceUtil.isNonExistingResource(commentSystem) && this.clientUtils != null) {
            ValueMap vm = this.clientUtils.getDesignProperties(commentSystem, "sling:resourceType");
            return (T)new AbstractCommentCollectionConfiguration(vm);
        }
        return (T)new AbstractCommentCollectionConfiguration(commentSystem);
    }

    @Override
    public T getConfiguration() {
        return this.configuration;
    }

    private boolean userIsOwner() {
        Session session = this.resource.getResourceResolver().adaptTo(Session.class);
        ValueMap map = this.resource.adaptTo(ValueMap.class);
        String resourceAuthorID = (String)((Object)map.get("userIdentifier", String.class));
        String composedByID = (String)((Object)map.get("authorizableId", String.class));
        if (StringUtils.isEmpty(resourceAuthorID)) {
            resourceAuthorID = (String)((Object)map.get("jcr:lastModifiedBy", String.class));
        }
        return StringUtils.equals(session.getUserID(), resourceAuthorID) || StringUtils.equals(session.getUserID(), composedByID);
    }

    private String getFlagsPath() {
        ValueMap props = this.resource.adaptTo(ValueMap.class);
        if (props == null) {
            LOG.warn("Unable to adapt resource {} to ValueMap.");
            return null;
        }
        int flagAllowCount = props.get("social:flagAllowCount", -1);
        if (flagAllowCount < 0) {
            return null;
        }
        return this.resource.getPath() + "/flags_" + flagAllowCount;
    }

    private Response<Vote> getFlagResponseForUser(String currentUserId) throws RepositoryException {
        ResourceResolver resolver = this.resource.getResourceResolver();
        String flagsPath = this.getFlagsPath();
        if (flagsPath == null) {
            return null;
        }
        Resource flagResource = resolver.resolve(flagsPath);
        if (ResourceUtil.isNonExistingResource(flagResource)) {
            return null;
        }
        Voting voting = flagResource.adaptTo(Voting.class);
        Response<Vote> response = null;
        try {
            response = voting.getUserResponse(currentUserId);
        }
        catch (RepositoryException e) {
            LOG.error("Repository Exception getting voting response for user {}.", (Object)currentUserId);
        }
        catch (TallyException e) {
            LOG.error("Tally Exception getting voting response for user {}.", (Object)currentUserId);
        }
        return response;
    }

    private List<FlagReason> listFlagReasons(Resource resource, ClientUtilities clientUtils) throws RepositoryException {
        Voting voting;
        ArrayList<FlagReason> reasons = new ArrayList<FlagReason>();
        ResourceResolver resolver = resource.getResourceResolver();
        String flagsPath = this.getFlagsPath();
        if (flagsPath == null) {
            return reasons;
        }
        Resource flagResource = resolver.resolve(flagsPath);
        if (!ResourceUtil.isNonExistingResource(flagResource) && (voting = flagResource.adaptTo(Voting.class)) != null) {
            Iterator responses = voting.getResponses(0L);
            while (responses.hasNext()) {
                Response response = responses.next();
                Resource responseResource = response.getResource();
                ValueMap resourceProperties = responseResource.adaptTo(ValueMap.class);
                String flagReasonText = (String)resourceProperties.get("social:flagReason");
                FlagReason flagReason = new FlagReason(flagReasonText);
                String flagUserId = response.getUserId();
                UserProperties userProps = clientUtils.getSocialUtils().getUserProperties(resolver, flagUserId);
                String flagUser = userProps != null ? userProps.getDisplayName() : UNKNOWN_USER;
                flagReason.setUser(flagUser);
                reasons.add(flagReason);
            }
        }
        return reasons;
    }

    @Override
    protected List<String> getIgnoredProperties() {
        this.ignoredProperties.add("jcr:.*");
        this.ignoredProperties.add("userIdentifier");
        this.ignoredProperties.add("referer");
        this.ignoredProperties.add("authorizableId");
        this.ignoredProperties.add("authorizableId");
        this.ignoredProperties.add("isPinned_b");
        return this.ignoredProperties;
    }

    @Override
    public Attachment getAttachment(String name) {
        return this.attachments.get(name);
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public String getState() {
        return this.state == null ? null : this.state.getTitle();
    }

    @Override
    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public Calendar getCreated() {
        return this.created;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getMessage() {
        try {
            return this.clientUtils.filterHTML(this.message);
        }
        catch (Throwable e) {
            String msg = this.message.length() > this.MAX_ERROR_MESSAGE_LENGTH ? this.message.substring(this.MAX_ERROR_MESSAGE_LENGTH) : this.message;
            LOG.error("Failed to filter HTML for the message {}.  Please configure max message length or change your XSS rules for the comment system to fix the issue.", (Object)msg);
            return "There was something wrong with this post.  Please contact your administrator to fix the issue.";
        }
    }

    public String getParent() {
        return this.externalizeURL(this.parentPath);
    }

    public String toString() {
        return this.getUrl();
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.replies.setPagination(pagination);
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.replies.setSortedOrder(sortedOrder);
    }

    public void setSortFields(List<Map.Entry<String, Boolean>> sortFields) {
        this.replies.setSortFields(sortFields);
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean isApproved() {
        return this.isApproved;
    }

    @Override
    public boolean getCanEdit() {
        return this.canEdit;
    }

    @Override
    public boolean getCanReply() {
        return this.displayReplyButton;
    }

    @Override
    public boolean getCanDelete() {
        return this.canDelete;
    }

    @Override
    public int getTotalSize() {
        return this.replies.getTotalSize();
    }

    @Override
    public List<Object> getItems() {
        return this.replies;
    }

    @Override
    public String getParentId() {
        SocialComponent pc = this.getParentComponent();
        if (pc == null) {
            LOG.warn("Could not get Parent SocialComponent for {}", (Object)this.getResource().getPath());
            return null;
        }
        return pc.getId().getResourceIdentifier();
    }

    @Override
    public String getSourceComponentId() {
        SocialComponent sc = this.getSourceComponent();
        if (sc == null) {
            Object o;
            Map<String, Object> props = this.getProperties();
            if (props.containsKey("social:parentid") && (o = props.get("social:parentid")) instanceof String) {
                return (String)o;
            }
            LOG.warn("Could not get Source SocialComponent for {}", (Object)this.getResource().getPath());
            return null;
        }
        return sc.getId().getResourceIdentifier();
    }

    @Override
    public boolean getCanTranslate() {
        return this.doDisplayTranslation;
    }

    @Override
    public boolean isUserModerator() {
        return this.userIsModerator;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public boolean isPinned() {
        return this.isPinned;
    }

    @Override
    public boolean isFeatured() {
        return this.isFeatured;
    }

    @Override
    public boolean isDraft() {
        return this.isDraft;
    }

    @Override
    public boolean isScheduled() {
        return this.isScheduled;
    }

    @Override
    public Calendar getPublishDate() {
        return this.publishDate;
    }

    @Override
    public List<FlagReason> getFlagReasons() {
        return this.flagReasons;
    }

    @Override
    public String getCurrentUserFlagText() {
        return this.currentUserFlagText;
    }

    @Override
    public boolean getUseFlagReasons() {
        return this.useFlagReasons;
    }

    @Override
    public boolean isFlaggedByUser() {
        return this.currentUserFlagged;
    }

    @Override
    public SocialComponent getVotes() {
        if (this.configuration.isVotingAllowed()) {
            SocialComponentFactory scf;
            SocialComponentFactoryManager scfMgr;
            Resource voteResource = this.resource.getChild(this.votingRoot);
            if (voteResource == null || ResourceUtil.isNonExistingResource(voteResource)) {
                voteResource = SocialResourceUtils.isSocialResource(this.resource) ? new SyntheticVotingResource(this.resource.getResourceResolver(), SocialResourceUtils.getSocialResource(this.resource), this.resource.getPath() + "/" + this.votingRoot, CommentUtil.getVotingType(this.comment.getComponent())) : new SyntheticResource(this.resource.getResourceResolver(), this.resource.getPath() + "/" + this.votingRoot, CommentUtil.getVotingType(this.comment.getComponent()));
            }
            if ((scfMgr = this.clientUtils.getSocialComponentFactoryManager()) != null && (scf = scfMgr.getSocialComponentFactory(voteResource)) != null) {
                return scf.getSocialComponent(voteResource, this.clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create());
            }
        }
        return null;
    }

    @Override
    public Comment.ModeratorActions getModeratorActions() {
        return this.moderatorActions;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Comment.ModeratorStatus getModeratorStatus() {
        return this.moderatorStatus;
    }

    @Override
    public SocialComponent getParentComponent() {
        if (this.parentComponent == null) {
            this.setParentOrSourceComponent(false);
        }
        return this.parentComponent;
    }

    private void setParentOrSourceComponent(boolean forceSourceComponent) {
        if (this.parentComponent != null && this.sourceComponent != null) {
            return;
        }
        for (Resource parentResource = this.parentComponent != null ? this.parentComponent.getResource() : this.getResource().getParent(); parentResource != null; parentResource = parentResource.getParent()) {
            if (parentResource.adaptTo(ValueMap.class).containsKey("commentsNode")) {
                Resource tempParent = parentResource.getResourceResolver().getResource((String)((Object)parentResource.adaptTo(ValueMap.class).get("commentsNode", String.class)));
                if (tempParent == null) {
                    this.sourceComponent = this.parentComponent = this.getComponent(parentResource);
                    break;
                }
                parentResource = tempParent;
                if (this.sourceComponent == null) {
                    this.sourceComponent = this.getComponent(parentResource);
                }
            }
            if (this.parentComponent == null) {
                this.parentComponent = this.getComponent(parentResource);
            }
            if (this.sourceComponent != null || !forceSourceComponent) break;
            if (StringUtils.startsWith(parentResource.getPath(), "/content/usergenerated")) continue;
            this.sourceComponent = this.getComponent(parentResource);
        }
    }

    private SocialComponent getComponent(Resource srcResource) {
        if (srcResource == null) {
            return null;
        }
        SocialComponentFactory parentFactory = this.clientUtils.getSocialComponentFactoryManager().getSocialComponentFactory(srcResource);
        if (parentFactory == null) {
            return null;
        }
        return parentFactory.getSocialComponent(srcResource, this.clientUtils, this.queryInfo);
    }

    @Override
    public SocialComponent getSourceComponent() {
        if (this.sourceComponent == null) {
            this.setParentOrSourceComponent(true);
        }
        return this.sourceComponent;
    }

    protected List<Comment> getComments() throws RepositoryException {
        return this.replies.getComments();
    }

    protected CollectionPagination getPagination() {
        return this.queryInfo.getPagination();
    }

    protected QueryRequestInfo getQueryRequestInfo() {
        return this.queryInfo;
    }

    @Override
    public List<Comment.Tag> getTags() {
        Locale pageLocale;
        Tag[] userTags;
        block6: {
            SocialTagManager tm = this.getResource().getResourceResolver().adaptTo(SocialTagManager.class);
            userTags = new Tag[]{};
            pageLocale = this.getPageLocale(this.getResource());
            try {
                userTags = tm.getTags(this.getResource());
            }
            catch (Exception e) {
                if (userTags == null || userTags.length > 0) break block6;
                try {
                    if (this.getProperties().get("cq:tags") != null && !this.getProperties().get("cq:tags").getClass().isArray()) {
                        String tag = null;
                        tag = this.getProperties().get("cq:tags").toString();
                        Tag singleTag = tm.resolve(tag);
                        userTags = new Tag[]{singleTag};
                    }
                }
                catch (Exception e1) {
                    LOG.error("Error retrieving tags: ", e1);
                }
            }
        }
        ArrayList<Comment.Tag> tags = new ArrayList<Comment.Tag>(userTags.length);
        for (final Tag t : userTags) {
            if (t == null) continue;
            Comment.Tag tag = new Comment.Tag(){

                @Override
                public String getTitle() {
                    return t.getTitle(pageLocale);
                }

                @Override
                public String getTagId() {
                    return t.getTagID();
                }
            };
            tags.add(tag);
        }
        return tags;
    }

    private Locale getPageLocale(Resource currentResource) {
        Page page;
        Locale locale = Locale.ENGLISH;
        if (currentResource != null && (page = this.clientUtils.getSocialUtils().getContainingPage(currentResource)) != null) {
            locale = page.getLanguage(false);
        }
        return locale;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Override
    public String getTranslationDescription() {
        return this.clientUtils.filterHTML(this.descriptionTranslation);
    }

    @Override
    public String getTranslationAttribution() {
        return this.translationAttribution;
    }

    @Override
    public String getTranslationTitle() {
        return this.titleTranslation;
    }

    @Override
    public String getTranslationDisplay() {
        return this.displayTranslation;
    }

    @Override
    public String getFriendlyUrl() {
        String url = this.getReferrerUrl();
        if (StringUtils.isNotBlank(url)) {
            if (url.contains("catalog.resource")) {
                url = this.removePageinationFromReferer(url, "resource");
            } else if (url.contains("catalog.learningpath")) {
                url = this.removePageinationFromReferer(url, "learningpath");
            }
            String commentFilter = "";
            if (url.indexOf("page has") < 0) {
                String asiComment = url.substring(url.lastIndexOf("/"));
                String[] commentPathArray = this.getId().getResourceIdentifier().split(asiComment + "/");
                if (commentPathArray.length > 1) {
                    String commentPath = commentPathArray[1];
                    if (commentPath.startsWith("se_social/se_discussion/")) {
                        commentPath = commentPath.replace("se_social/se_discussion/", "");
                    }
                    try {
                        commentFilter = "?filter=" + URLEncoder.encode("page has ", "UTF-8") + commentPath;
                    }
                    catch (UnsupportedEncodingException ex) {
                        commentFilter = "?filter=" + "page has ".replace(" ", "%20") + commentPath;
                    }
                }
            }
            return url + commentFilter;
        }
        return super.getFriendlyUrl();
    }

    private String removePageinationFromReferer(String referer, String enablementType) {
        String[] urlPartsNextSplit;
        String[] urlParts = referer.split("catalog");
        String url = referer;
        if (urlParts.length >= 2 && (urlPartsNextSplit = urlParts[1].split("\\.")).length >= 1 && !urlPartsNextSplit[1].startsWith("html")) {
            url = urlParts[0] + "catalog." + enablementType + ".html" + urlParts[1].split(".html")[1];
        }
        return url;
    }

    @Override
    public String getReferrerUrl() {
        return this.useReferrerUrl ? this.comment.getProperty("referer", "") : null;
    }

    protected class ModeratorActionsImpl
    implements Comment.ModeratorActions {
        private boolean displayAllowButton = false;
        private boolean displayFlagButton = false;
        private boolean displayDenyButton = false;
        private boolean displayCloseButton = false;
        private boolean displayReviewButton = false;
        private List<String> nextStates = new ArrayList<String>();
        private boolean displayPinButton = false;
        private boolean canMove = false;
        private boolean displayFeaturedLink = false;
        private final String OPERATION_REVIEW_IDEA = "Review Idea";

        public ModeratorActionsImpl(com.adobe.cq.social.commons.Comment comment, CommentSystem cs, boolean userIsLoggedIn) {
            boolean commentApproved = comment.isApproved() || !cs.isModerated();
            this.displayFlagButton = !AbstractComment.this.isClosed && !AbstractComment.this.currentUserFlagged && userIsLoggedIn && commentApproved && !AbstractComment.this.userIsOwner() && !comment.isSpam() && !comment.isFlaggedHidden() && cs.allowsFlagging();
            this.displayAllowButton = AbstractComment.this.userIsModerator && !AbstractComment.this.isClosed && (comment.isSpam() || comment.isFlagged() || !commentApproved);
            this.displayDenyButton = AbstractComment.this.userIsModerator && !comment.isSpam() && cs.allowsDeny();
            this.displayPinButton = AbstractComment.this.userIsModerator && AbstractComment.this.isTopLevel && cs.allowsPin();
            this.displayCloseButton = AbstractComment.this.userIsModerator && AbstractComment.this.isTopLevel && cs.allowsClose();
            this.canMove = AbstractComment.this.userIsModerator && AbstractComment.this.isTopLevel && !comment.isClosed() && cs.allowsMove();
            boolean bl = this.displayFeaturedLink = AbstractComment.this.userIsModerator && AbstractComment.this.isTopLevel && AbstractComment.this.configuration.isFeaturingContentAllowed();
            boolean bl2 = AbstractComment.this.state == null ? false : (this.displayReviewButton = AbstractComment.this.userIsModerator && AbstractComment.this.isTopLevel && AbstractComment.this.state.canPerformOperation("moderators", "Review Idea"));
            if (AbstractComment.this.userIsModerator && AbstractComment.this.isTopLevel && AbstractComment.this.state != null) {
                this.nextStates = AbstractComment.this.state.getNextStatesForRole("moderators");
            }
        }

        @Override
        public boolean getCanDeny() {
            return this.displayDenyButton;
        }

        @Override
        public boolean getUseFlagReasonList() {
            return AbstractComment.this.useFlagReasonList;
        }

        @Override
        public boolean getCanAllow() {
            return this.displayAllowButton;
        }

        @Override
        public boolean getCanFlag() {
            return this.displayFlagButton;
        }

        @Override
        public boolean getCanClose() {
            return this.displayCloseButton;
        }

        @Override
        public boolean getCanPin() {
            return this.displayPinButton;
        }

        @Override
        public boolean getCanMove() {
            return this.canMove;
        }

        @Override
        public boolean getCanMarkFeatured() {
            return this.displayFeaturedLink;
        }

        public boolean getCanReview() {
            return this.displayReviewButton;
        }

        public List<String> getReviewStates() {
            return this.nextStates;
        }
    }

    protected class ModeratorStatusImpl
    implements Comment.ModeratorStatus {
        private final boolean flagged;
        private final boolean approved;
        private final boolean spam;
        private final boolean pending;

        public ModeratorStatusImpl(com.adobe.cq.social.commons.Comment comment, CommentSystem cs) {
            this.flagged = comment.isFlagged();
            this.spam = comment.isSpam();
            this.approved = !this.spam && (comment.isApproved() || !cs.isModerated());
            this.pending = cs.isModerated() && !comment.isApproved() && !comment.isDenied();
        }

        @Override
        @JsonProperty(value="isFlagged")
        public boolean isFlagged() {
            return this.flagged;
        }

        @Override
        @JsonProperty(value="isApproved")
        public boolean isApproved() {
            return this.approved;
        }

        @Override
        @JsonProperty(value="isSpam")
        public boolean isSpam() {
            return this.spam;
        }

        @Override
        @JsonProperty(value="isPending")
        public boolean isPending() {
            return this.pending;
        }
    }

    private static class SyntheticVotingResource
    extends SyntheticResource
    implements SocialResource {
        private final SocialResource parent;

        public SyntheticVotingResource(ResourceResolver resourceResolver, SocialResource parentIn, String path, String resourceType) {
            super(resourceResolver, path, resourceType);
            this.parent = parentIn;
        }

        @Override
        public SocialResourceProvider getResourceProvider() {
            return this.parent.getResourceProvider();
        }

        @Override
        public Resource getRootJCRNode() {
            return this.parent.getRootJCRNode();
        }

        @Override
        public boolean checkPermissions(String permission) {
            return this.parent.checkPermissions(permission);
        }
    }
}

