/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.exception.FunctionValidationException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionValidationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionValidationUtil.class);

    private static Set<String> getInvalidFunctionUrls(@Nonnull Resource site, @Nonnull JSONArray functions) throws JSONException, FunctionValidationException {
        Set<String> invalidUrls = FunctionValidationUtil.getInvalidFunctionUrls(functions);
        for (int i = functions.length() - 1; i >= 0; --i) {
            String functionOrigUrl;
            JSONObject function = functions.getJSONObject(i);
            String functionUrl = function.has("url") ? function.getString("url") : null;
            String string = functionOrigUrl = function.has("origUrl") ? function.getString("origUrl") : null;
            if (functionUrl == null || functionUrl.equals(functionOrigUrl) || site.getChild(functionUrl) == null) continue;
            invalidUrls.add(functionUrl);
        }
        return invalidUrls;
    }

    private static Set<String> getInvalidFunctionUrls(@Nonnull JSONArray functions) throws JSONException, FunctionValidationException {
        HashSet<String> invalidUrls = new HashSet<String>();
        HashSet<String> uniqueUrl = new HashSet<String>();
        for (int i = functions.length() - 1; i >= 0; --i) {
            String functionOrigUrl;
            JSONObject function = functions.getJSONObject(i);
            String functionUrl = function.has("url") ? function.getString("url") : null;
            String string = functionOrigUrl = function.has("origUrl") ? function.getString("origUrl") : null;
            if (functionOrigUrl == null || functionUrl.equals(functionOrigUrl)) {
                if (uniqueUrl.add(functionUrl)) continue;
                invalidUrls.add(functionUrl);
                continue;
            }
            if (!uniqueUrl.add(functionUrl)) {
                invalidUrls.add(functionUrl);
            }
            if (uniqueUrl.add(functionOrigUrl)) continue;
            invalidUrls.add(functionOrigUrl);
        }
        return invalidUrls;
    }

    public static void validateFunctions(@Nonnull Resource resource, JSONArray functions) throws FunctionValidationException {
        Set<String> invalidUrls;
        try {
            if (functions == null) {
                functions = new JSONArray();
            }
            invalidUrls = FunctionValidationUtil.getInvalidFunctionUrls(resource, functions);
        }
        catch (JSONException e) {
            LOG.error("Functions Json structure is invalid- ", e);
            throw new FunctionValidationException("Functions Json structure is invalid", e);
        }
        if (!invalidUrls.isEmpty()) {
            String invalidUrlsString = StringUtils.join(invalidUrls.iterator(), ",");
            throw new FunctionValidationException("Url used before or same url used for multiple functions: " + invalidUrlsString);
        }
    }

    public static void validateFunctions(JSONArray functions) throws FunctionValidationException {
        Set<String> invalidUrls;
        try {
            if (functions == null) {
                functions = new JSONArray();
            }
            invalidUrls = FunctionValidationUtil.getInvalidFunctionUrls(functions);
        }
        catch (JSONException e) {
            LOG.error("Functions Json structure is invalid- ", e);
            throw new FunctionValidationException("Functions Json structure is invalid", e);
        }
        if (!invalidUrls.isEmpty()) {
            String invalidUrlsString = StringUtils.join(invalidUrls.iterator(), ",");
            throw new FunctionValidationException("Url used before or same url used for multiple functions: " + invalidUrlsString);
        }
    }
}

