/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.commons;

import com.adobe.cq.social.commons.AttachmentDataSource;
import com.adobe.cq.social.commons.AttachmentTypeBlacklistService;
import com.adobe.cq.social.commons.CollabException;
import com.adobe.cq.social.commons.CommentException;
import com.adobe.cq.social.commons.FileDataSource;
import com.adobe.cq.social.commons.FileUploadSizeLimit;
import com.adobe.cq.social.commons.bundleactivator.Activator;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.cq.social.ugcbase.core.LocalJcrUtils;
import com.adobe.granite.security.user.UserProperties;
import com.adobe.granite.translation.core.MachineTranslationCloudConfig;
import com.adobe.granite.translation.core.MachineTranslationUtil;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataSource;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CollabUtil {
    public static String PN_REMOTE_UGC_LOCATION = "remoteUGC";
    private static final Logger log = LoggerFactory.getLogger(CollabUtil.class);
    public static final String BUCKET_TYPE = "sling:Folder";
    @Deprecated
    public static final String REQ_ATTR_SOCIAL_PROFILE_PAGE = "cq.social.profile.page";
    public static final String GROUP_MEMBERGROUP = "membergroup";
    public static String DEFAULT_AVATAR = "/etc.clientlibs/settings/wcm/designs/default/resources/social/avatar.png";
    private static SecureRandom randomGenerator = new SecureRandom();
    private static char[] RANDOM_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static boolean hasModeratePermissions(Resource resource) {
        if (!CollabUtil.isUGCResource(resource)) {
            return false;
        }
        SocialUtils socialUtils = resource.getResourceResolver().adaptTo(SocialUtils.class);
        if (socialUtils != null) {
            return socialUtils.hasModeratePermissions(resource);
        }
        return false;
    }

    public static boolean isResourceOwner(Resource resource) {
        if (!CollabUtil.isUGCResource(resource)) {
            return false;
        }
        SocialUtils socialUtils = resource.getResourceResolver().adaptTo(SocialUtils.class);
        if (socialUtils != null) {
            return socialUtils.isResourceOwner(resource);
        }
        return false;
    }

    public static String resourceToUGCPath(Resource resource) {
        if (resource == null) {
            return null;
        }
        SocialUtils socialUtils = resource.getResourceResolver().adaptTo(SocialUtils.class);
        if (socialUtils != null) {
            return socialUtils.resourceToUGCStoragePath(resource);
        }
        log.debug("In function: resourceToUGCPath");
        String resourcePath = resource.getPath();
        log.debug("resourcePath: {}", (Object)resourcePath);
        if (resourcePath.startsWith("/content/usergenerated")) {
            return resourcePath;
        }
        StringBuilder path = new StringBuilder();
        MachineTranslationUtil mtu = resource.getResourceResolver().adaptTo(MachineTranslationUtil.class);
        if (mtu != null) {
            MachineTranslationCloudConfig cloudConfig = mtu.getAppliedMachineTranslationCloudConfigs(resource);
            if (cloudConfig != null) {
                String ugcRoot = cloudConfig.getUgcPath();
                log.debug("Applied ugcRoot: {}", (Object)ugcRoot);
                if (!ugcRoot.startsWith("/content/usergenerated")) {
                    path.append("/content/usergenerated");
                }
                if (ugcRoot.endsWith("/")) {
                    path.append(StringUtils.substringBeforeLast(ugcRoot, "/"));
                } else {
                    path.append(ugcRoot);
                }
                path.append(CollabUtil.stripLanguageRoot(resource));
            } else {
                path.append("/content/usergenerated");
                if (!resource.getPath().contains("jcr:content")) {
                    path.append(resource.getPath());
                } else {
                    path.append(CollabUtil.getPagePath(resource));
                    path.append("/").append("jcr:content");
                    path.append("/").append(CollabUtil.getIdFromResource(resource));
                }
            }
        }
        log.debug("Returning ugc path: {}", (Object)path.toString());
        return path.toString();
    }

    private static String stripLanguageRoot(Resource resource) {
        StringBuilder pathWithoutExtensions;
        log.debug("In Function: stripLanguageRoot");
        String ISO_PROP_NAME = "jcr:content/jcr:language";
        String pathMinusLanguageRoot = "";
        log.debug("resource.getPath(): {}", (Object)resource.getPath());
        if (!resource.getPath().contains("jcr:content")) {
            pathWithoutExtensions = new StringBuilder(resource.getPath());
        } else {
            pathWithoutExtensions = new StringBuilder();
            pathWithoutExtensions.append(CollabUtil.getPagePath(resource));
            pathWithoutExtensions.append("/").append("jcr:content");
            pathWithoutExtensions.append("/").append(CollabUtil.getIdFromResource(resource));
        }
        Node pageNode = resource.adaptTo(Node.class);
        try {
            while (pageNode != null && !pageNode.hasProperty("jcr:content/jcr:language") && LanguageUtil.getLocale(pageNode.getName()) == null) {
                pageNode = pageNode.getDepth() <= 1 ? null : pageNode.getParent();
            }
            if (pageNode != null) {
                log.debug("pageNode path: {}", (Object)pageNode.getPath());
                pathMinusLanguageRoot = StringUtils.substringAfter(pathWithoutExtensions.toString(), pageNode.getPath());
            }
        }
        catch (AccessDeniedException e) {
            try {
                log.info("Could not access parent of {} to look for the page language", (Object)pageNode.getPath());
            }
            catch (RepositoryException repositoryException) {}
        }
        catch (RepositoryException e) {
            log.error("Error while evaluating content language.", e);
        }
        log.debug("pathMinusLanguageRoot: {}", (Object)pathMinusLanguageRoot);
        return pathMinusLanguageRoot;
    }

    public static String getPagePath(Resource resource) {
        return CollabUtil.getPagePath(resource.getPath());
    }

    public static String getPagePath(String path) {
        return StringUtils.substringBefore(path, "/jcr:content");
    }

    private static String getIdFromResource(Resource resource) {
        return StringUtils.substringBefore(ResourceUtil.getName(resource), ".");
    }

    public static boolean canAddNode(Session session, String path) {
        try {
            StringBuilder childPath = new StringBuilder(path).append("/foo_").append(new Date().getTime());
            return session != null && session.hasPermission(childPath.toString(), "add_node");
        }
        catch (RepositoryException e) {
            log.error("canAddNode: error while checking add node permission on[{}]", (Object)path, (Object)e);
            return false;
        }
    }

    public static String getAvatar(UserProperties userProperties, String email, String absoluteDefaultAvatar) {
        return CollabUtil.getAvatar(userProperties, email, absoluteDefaultAvatar, AVATAR_SIZE.THIRTY_TWO);
    }

    public static String getAvatar(UserProperties userProperties, String email, String absoluteDefaultAvatar, AVATAR_SIZE size) {
        String avatar = DEFAULT_AVATAR;
        if (userProperties != null) {
            try {
                Resource resource = userProperties.getResource("photos/primary/image");
                if (null != resource) {
                    avatar = resource.getPath() + ".prof.thumbnail." + size.toString() + ".png";
                } else {
                    String gravatar;
                    String primaryMail = userProperties.getProperty("email");
                    if (primaryMail != null && !"".equals(primaryMail) && (gravatar = CollabUtil.getGravatar(primaryMail, absoluteDefaultAvatar)) != null) {
                        avatar = gravatar;
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("getAvatar: error getting avatar: ", e);
            }
        } else {
            String gravatar = CollabUtil.getGravatar(email, absoluteDefaultAvatar);
            if (gravatar != null) {
                avatar = gravatar;
            }
        }
        return avatar;
    }

    public static String getGravatar(String email, String absoluteDefaultAvatar) {
        if (StringUtils.isBlank(email) || StringUtils.isBlank(absoluteDefaultAvatar)) {
            return null;
        }
        try {
            email = Text.md5(email, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://www.gravatar.com/avatar/");
        sb.append(email);
        sb.append("?d=").append("mm");
        sb.append("&s=32");
        sb.append("&r=g");
        return sb.toString();
    }

    public static String generateRandomString(int length) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            str.append(RANDOM_CHARS[randomGenerator.nextInt(RANDOM_CHARS.length)]);
        }
        return str.toString();
    }

    public static void save(ResourceResolver resolver) throws CollabException, IllegalArgumentException {
        Session session = resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        try {
            session.save();
        }
        catch (RepositoryException re) {
            throw new CollabException("failed to save changes", re);
        }
    }

    public static Page createPage(ResourceResolver resolver, String path, String template, String resourceTypeProp, String resourceType, String title) throws CollabException {
        String parentPath = Text.getRelativeParent(path, 1);
        String name = Text.getName(path);
        return CollabUtil.createPage(resolver, parentPath, name, template, resourceTypeProp, resourceType, title);
    }

    public static Page createPage(ResourceResolver resolver, String parentPath, String name, String template, String resourceTypeProp, String resourceType, String title) throws CollabException {
        Exception e;
        try {
            if (resolver.getResource(parentPath) == null) {
                CollabUtil.createNode(resolver, parentPath, "nt:unstructured");
                CollabUtil.save(resolver);
            }
            if (!JcrUtil.isValidName(name)) {
                name = JcrUtil.createValidName(name, JcrUtil.HYPHEN_LABEL_CHAR_MAPPING);
            }
            Page page = resolver.adaptTo(PageManager.class).create(parentPath, name, template, title);
            if (StringUtils.isNotEmpty(resourceTypeProp)) {
                page.getContentResource().adaptTo(Node.class).setProperty(resourceTypeProp, resourceType);
            }
            return page;
        }
        catch (RepositoryException re) {
            e = re;
        }
        catch (WCMException wcme) {
            e = wcme;
        }
        catch (CollabException ce) {
            e = ce;
        }
        throw new CollabException("failed to create page", e);
    }

    public static Node createNode(ResourceResolver resolver, String path, String nodeType) throws CollabException {
        try {
            return CollabUtil.createNode(resolver.adaptTo(Session.class), path, nodeType);
        }
        catch (Exception e) {
            throw new CollabException("failed to create node", e);
        }
    }

    public static Node createNode(Session session, String path, String nodeType) {
        try {
            Node result = LocalJcrUtils.getOrCreateByPathDepthFirst(path, false, null, nodeType, session, false);
            return result;
        }
        catch (RepositoryException e) {
            throw new CommentException("Failed to create node", e);
        }
    }

    public static List<DataSource> getAttachmentsFromRequest(RequestParameter[] fileRequestParameters, long attachmentSizeLimit, List<String> whitelist, String[] blacklist) {
        return CollabUtil.getAttachmentsFromRequest(fileRequestParameters, new FileUploadSizeLimit(attachmentSizeLimit, attachmentSizeLimit), whitelist, blacklist);
    }

    public static List<DataSource> getAttachmentsFromRequest(RequestParameter[] fileRequestParameters, FileUploadSizeLimit fileUploadSizeLimit, List<String> whitelist, String[] blacklist) {
        List<DataSource> attachments = Collections.emptyList();
        HashSet<String> whitelistSet = null;
        if (whitelist != null) {
            whitelistSet = new HashSet<String>(whitelist);
        }
        if (fileRequestParameters != null && fileRequestParameters.length > 0 && !fileRequestParameters[0].isFormField()) {
            attachments = new ArrayList<DataSource>();
            for (RequestParameter fileRequestParameter : fileRequestParameters) {
                if (fileUploadSizeLimit.fits(fileRequestParameter)) {
                    FileDataSource filteredAttachment = CollabUtil.getAttachmentFromDataSource(new AttachmentDataSource(fileRequestParameter), fileUploadSizeLimit, whitelistSet, blacklist);
                    if (filteredAttachment != null) {
                        attachments.add(filteredAttachment);
                        continue;
                    }
                    log.debug("File is black listed, so ignoring the attachment");
                    continue;
                }
                log.debug("File bigger than specified size, so ignoring the attachment");
            }
        }
        return attachments;
    }

    public static Iterable<DataSource> getAttachmentsFromDataSources(Iterable<FileDataSource> attachmentList, FileUploadSizeLimit fileUploadSizeLimit, Set<String> whitelist, String[] blacklist) {
        ArrayList<DataSource> attachments = new ArrayList<DataSource>();
        for (FileDataSource attachmentDataSource : attachmentList) {
            FileDataSource filteredAttachment = CollabUtil.getAttachmentFromDataSource(attachmentDataSource, fileUploadSizeLimit, whitelist, blacklist);
            if (filteredAttachment == null) continue;
            attachments.add(filteredAttachment);
        }
        return attachments;
    }

    public static FileDataSource getAttachmentFromDataSource(FileDataSource attachmentDataSource, FileUploadSizeLimit fileUploadSizeLimit, Set<String> whitelist, String[] blacklistIn) {
        AttachmentTypeBlacklistService attachmentTypeBlacklistService = (AttachmentTypeBlacklistService)Activator.getService(AttachmentTypeBlacklistService.class);
        Object[] blacklist = blacklistIn;
        if (attachmentTypeBlacklistService != null) {
            blacklist = attachmentTypeBlacklistService.getBlacklist(blacklistIn);
        }
        if (fileUploadSizeLimit.fits(attachmentDataSource)) {
            String contentFileType = attachmentDataSource.getTypeFromFileName();
            String contentType = attachmentDataSource.getType();
            if (StringUtils.isNotBlank(contentFileType) && !ArrayUtils.contains(blacklist, contentFileType)) {
                if (whitelist != null && !whitelist.isEmpty()) {
                    if (StringUtils.isNotBlank(contentType) && whitelist.contains(contentType) && !ArrayUtils.contains(blacklist, contentType)) {
                        return attachmentDataSource;
                    }
                    if (StringUtils.isNotBlank(contentType)) {
                        log.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the servlet's attachment black list");
                    } else {
                        log.info("Tika couldn't figure out the file type. Not attaching it as it is suspicious");
                    }
                } else {
                    if (StringUtils.isNotBlank(contentType) && !ArrayUtils.contains(blacklist, contentType)) {
                        return attachmentDataSource;
                    }
                    if (StringUtils.isNotBlank(contentType)) {
                        log.info("File of type " + contentType + " is blacklisted for security reasons. To upload edit the servlet's attachment black list");
                    } else {
                        log.info("Tika couldn't figure out the file type. Not attaching it as it is suspicious");
                    }
                }
            } else if (StringUtils.isNotBlank(contentFileType)) {
                log.info("File of type " + contentFileType + "with name " + attachmentDataSource.getName() + " is blacklisted for security reasons. To upload edit the servlet's attachment black list");
            } else {
                log.info("File doesn't have a valid extension. Not attaching it as it is suspicious");
            }
        } else {
            log.info("File bigger than specified size, so ignoring the attachment");
        }
        return null;
    }

    public static String getValueString(Object value) throws RepositoryException {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            throw new RepositoryException("Specified value is an array.");
        }
        if (value instanceof Value) {
            return ((Value)value).getString();
        }
        return value.toString();
    }

    protected static boolean isUGCResource(Resource resource) {
        return StringUtils.startsWith(resource.getPath(), "/content/usergenerated");
    }

    public static enum AVATAR_SIZE {
        THIRTY_TWO(32),
        FOURTY_EIGHT(48),
        THIRTY_FOUR(34);

        private final int size;

        private AVATAR_SIZE(int s) {
            this.size = s;
        }

        public String toString() {
            return String.valueOf(this.size);
        }
    }
}

