/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.blueprint.api;

import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteBlueprintUtil {
    private static final Logger log = LoggerFactory.getLogger(SiteBlueprintUtil.class);
    public static final int DEFAULT_MAX_WAIT_TIME = 2000;
    public static final int DEFAULT_WAIT_BETWEEN_RETRIES = 100;
    public static final int WARN_WAIT_TIME = 120000;
    public static final int WARN_RETRY_DELAY = 1000;
    public static final String GROUP_MEMBERGROUP_SUFFIX = "-members";
    @Reference
    private static XSSAPI xssAPI;

    public static String validateCommunityName(ResourceResolver resolver, String name, String communityPath) {
        String validName = JcrUtil.createValidName(name);
        if (StringUtils.isBlank(name)) {
            return "0";
        }
        if (!StringUtils.equals(name.trim(), name)) {
            return "1";
        }
        if (!StringUtils.equals(xssAPI.filterHTML(name), name) && name.contains("<")) {
            return "2";
        }
        if (!SiteBlueprintUtil.validateGroupName(resolver, validName, communityPath)) {
            return "3";
        }
        if (!name.matches("^[a-zA-Z0-9-]+")) {
            return "4";
        }
        return "true";
    }

    public static boolean validateGroupName(ResourceResolver resolver, String name, String groupRoot) {
        if (name.startsWith("_")) {
            log.info("Group name {} begins with invalid charactor", (Object)name);
            return false;
        }
        PageManager pm = resolver.adaptTo(PageManager.class);
        Page childPage = pm.getPage(groupRoot + "/" + name);
        if (childPage != null) {
            log.info("Page {} already exists in {}", (Object)name, (Object)groupRoot);
            return false;
        }
        CommunityContext site = resolver.getResource(groupRoot).adaptTo(CommunityContext.class);
        String memberGroup = name + GROUP_MEMBERGROUP_SUFFIX;
        if (site != null) {
            memberGroup = site.getTenantUserGroupName(site.getSiteId() + '-' + memberGroup);
        }
        try {
            Session session = resolver.adaptTo(Session.class);
            UserManager um = ((JackrabbitSession)session).getUserManager();
            Authorizable group = um.getAuthorizable(memberGroup);
            if (group != null) {
                log.info("Authorizable {} already exists", (Object)memberGroup);
                return false;
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to validate user group " + memberGroup, e);
            return false;
        }
        return true;
    }

    public static void waitForPageCreation(ResourceResolver resolver, String pagePath) throws RepositoryException {
        SiteBlueprintUtil.waitForPageCreation(resolver, pagePath, 2000L, 100L);
    }

    public static void waitForPageCreation(ResourceResolver resolver, String pagePath, long maxWaitTime, long waitInterval) throws RepositoryException {
        log.debug("Wait for page creation at {}", (Object)pagePath);
        if (resolver == null || StringUtils.isEmpty(pagePath)) {
            return;
        }
        if (maxWaitTime <= 0L) {
            log.warn("Invalid maxWaitTime [{}]. Resetting.", (Object)maxWaitTime);
            maxWaitTime = 2000L;
        }
        if (maxWaitTime > 120000L) {
            log.warn("Very large number of retries configured [{}]. This may cause thread contention.", (Object)maxWaitTime);
        }
        if (waitInterval <= 0L) {
            log.warn("Invalid wait interval [{}]. Resetting.", (Object)waitInterval);
            waitInterval = 100L;
        }
        if (waitInterval > 1000L) {
            log.warn("Very large wait interval configured [{}]. This may cause thread contention.", (Object)waitInterval);
        }
        long start = System.currentTimeMillis();
        boolean wait = false;
        do {
            Resource res;
            if ((res = resolver.resolve(pagePath + "/" + "jcr:content")) != null && !ResourceUtil.isNonExistingResource(res)) {
                if (wait) {
                    log.debug("Page content successfully created at {} after waiting for {} milliseconds", (Object)pagePath, (Object)(System.currentTimeMillis() - start));
                } else {
                    log.debug("Page content successfully created at {} already", (Object)pagePath);
                }
                return;
            }
            wait = true;
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resolver.adaptTo(Session.class).refresh(true);
            resolver.refresh();
        } while (System.currentTimeMillis() - start < maxWaitTime);
        log.debug("Page content failed to be created at {} ", (Object)pagePath);
    }
}

