/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.social.activitystreams.client.api;

import com.adobe.cq.social.activitystreams.api.SocialActivity;
import com.adobe.cq.social.activitystreams.api.SocialActivityManager;
import com.adobe.cq.social.activitystreams.client.api.SocialActivityComponentFactory;
import com.adobe.cq.social.activitystreams.client.api.SocialActivityStream;
import com.adobe.cq.social.community.api.CommunityContext;
import com.adobe.cq.social.graph.Edge;
import com.adobe.cq.social.graph.SocialGraph;
import com.adobe.cq.social.graph.Vertex;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.CollectionPagination;
import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.BaseSocialComponent;
import com.adobe.cq.social.scf.core.CollectionSortedOrder;
import com.adobe.cq.social.ugc.api.ComparisonType;
import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.ConstraintGroup;
import com.adobe.cq.social.ugc.api.Operator;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.cq.social.ugc.api.ValueConstraint;
import com.adobe.cq.social.ugcbase.SocialUtils;
import com.adobe.granite.activitystreams.Activity;
import com.adobe.granite.socialgraph.Direction;
import com.adobe.granite.socialgraph.Relationship;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActivityStream
extends BaseSocialComponent
implements SocialActivityStream {
    public static final String FOLLOWINGS_LIST_TYPE = "following";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractActivityStream.class);
    private static final String PROP_FILTER_NAME = "filter";
    private static final String PROP_FILTER_SELECTION_NAME = "selection";
    private static final String GROUP_RESOURCE_TYPE = "social/group/components/hbs/communitygroups/communitygroup";
    private CollectionPagination pagination;
    private CollectionSortedOrder sortOrder = CollectionSortedOrder.DEFAULT_ORDER;
    private final PageInfo pageInfo;
    private List<Object> activities;
    private final Map<String, Object> filters = new LinkedHashMap<String, Object>();
    private final SocialActivityManager activityManager;
    private final ValueMap properties;
    private final String streamPath;
    private final String streamName;
    private final String streamContextPath;
    private final boolean displayUserView;
    private final boolean displayAllView;
    private final boolean displayFollowingView;
    private final int maxNumberActivities;
    private SocialActivityStream.ActivityContext activityContext;
    private final CommunityContext context;
    private final String userId;

    public AbstractActivityStream(Resource resource, ClientUtilities clientUtils, SocialActivityManager activityManager) {
        this(resource, clientUtils, QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), activityManager);
    }

    public AbstractActivityStream(Resource resource, ClientUtilities clientUtilities, QueryRequestInfo queryRequestInfo, SocialActivityManager activityManager) {
        this(resource, clientUtilities, queryRequestInfo, activityManager, null);
    }

    public AbstractActivityStream(Resource resource, ClientUtilities clientUtilities, QueryRequestInfo queryRequestInfo, SocialActivityManager activityManager, String userId) {
        super(resource, clientUtilities);
        this.userId = userId;
        this.activityManager = activityManager;
        this.properties = ResourceUtil.getValueMap(resource);
        this.streamContextPath = this.properties.get("streamContextPath", "");
        LOG.debug("Stream context path: %", (Object)this.streamContextPath);
        this.activityContext = SocialActivityStream.ActivityContext.NONE;
        if (StringUtils.isNotEmpty(this.streamContextPath)) {
            this.activityContext = SocialActivityStream.ActivityContext.PATH;
            Resource contextResource = resource.getResourceResolver().getResource(this.streamContextPath);
            this.context = contextResource != null ? contextResource.adaptTo(CommunityContext.class) : null;
        } else {
            this.context = resource.adaptTo(CommunityContext.class);
        }
        String path = this.properties.get("streamPath", "");
        if (StringUtils.isEmpty(path)) {
            if (this.context != null) {
                path = this.context.getActivityStreamRootPath();
                if (this.context.isMultiTenantSupported()) {
                    this.activityContext = SocialActivityStream.ActivityContext.TENANT;
                } else {
                    String siteId = this.context.getSiteId();
                    if (StringUtils.isNotEmpty(siteId)) {
                        this.activityContext = StringUtils.isNotEmpty(this.context.getCommunityGroupId()) ? SocialActivityStream.ActivityContext.COMMUNITIY_GROUP : SocialActivityStream.ActivityContext.SITE;
                    } else if (this.activityContext == SocialActivityStream.ActivityContext.NONE) {
                        this.activityContext = SocialActivityStream.ActivityContext.APP;
                    }
                }
            }
        } else if (this.activityContext != SocialActivityStream.ActivityContext.PATH) {
            LOG.error("Configuration for the stream ContextPath is missing.");
        }
        LOG.debug("ActivityContext: %", (Object)this.activityContext.toString());
        this.streamPath = path;
        this.streamName = this.properties.get("streamName", "community");
        this.displayAllView = Boolean.parseBoolean(this.properties.get("allowAllView", "false"));
        this.displayUserView = !this.isAnonymousUser(userId) ? Boolean.parseBoolean(this.properties.get("allowUserView", "false")) : false;
        this.displayFollowingView = !this.isAnonymousUser(userId) ? Boolean.parseBoolean(this.properties.get("allowFollowingView", "false")) : false;
        this.maxNumberActivities = Integer.parseInt(this.properties.get("maxNumberActivities", "-1"));
        String[] filterParams = queryRequestInfo.getPredicates().get(PROP_FILTER_NAME);
        SocialActivityStream.Selection selection = SocialActivityStream.Selection.NONE;
        if (filterParams != null && filterParams.length > 0) {
            for (int i = 0; i < filterParams.length; ++i) {
                String filter = StringUtils.trim(filterParams[i]);
                int index = filter.indexOf("=");
                if (index <= 0) continue;
                String selectionKey = filterParams[0].substring(0, index);
                String selectionValue = filterParams[0].substring(index + 1);
                if (selectionKey.equals(PROP_FILTER_SELECTION_NAME)) {
                    try {
                        selection = SocialActivityStream.Selection.valueOf(selectionValue);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.error("Invalue value of selection {}", (Object)selectionValue);
                        selection = SocialActivityStream.Selection.NONE;
                    }
                    continue;
                }
                this.filters.put(selectionKey, selectionValue);
            }
        }
        if (selection == SocialActivityStream.Selection.NONE) {
            if (this.displayAllView) {
                selection = SocialActivityStream.Selection.ALL;
            } else if (this.displayUserView) {
                selection = SocialActivityStream.Selection.USER;
            } else if (this.displayFollowingView) {
                selection = SocialActivityStream.Selection.FOLLOWER;
            }
        }
        LOG.debug("Selection: %", (Object)selection);
        this.filters.put(PROP_FILTER_SELECTION_NAME, (Object)selection);
        this.pagination = queryRequestInfo.getPagination();
        this.pageInfo = new PageInfo(this, this.clientUtils, this.pagination, this.getQueryParams(queryRequestInfo));
    }

    @Override
    public int getTotalSize() {
        if (this.maxNumberActivities < 0) {
            return (int)this.pageInfo.getPageSize() * (int)this.pageInfo.getSelectedPage() + 2;
        }
        this.getItems();
        return this.activities.size();
    }

    @Override
    public void setPagination(CollectionPagination pagination) {
        this.pagination = pagination;
    }

    @Override
    public void setSortedOrder(CollectionSortedOrder sortedOrder) {
        this.sortOrder = sortedOrder;
    }

    protected abstract UgcFilter getCustomizedFilter(UgcFilter var1);

    protected boolean isAnonymousUser(String userId) {
        return userId == null || "anonymous".equals(userId);
    }

    @Override
    public List<Object> getItems() {
        if (this.activities == null) {
            this.activities = new ArrayList<Object>();
            try {
                SocialActivityStream.Selection selection = (SocialActivityStream.Selection)((Object)this.filters.get(PROP_FILTER_SELECTION_NAME));
                if (selection != SocialActivityStream.Selection.NONE) {
                    ResourceResolver resolver = this.resource.getResourceResolver();
                    com.adobe.cq.social.activitystreams.api.SocialActivityStream stream = this.getStream(resolver);
                    UgcFilter filter = new UgcFilter();
                    if (stream != null) {
                        int size;
                        int offset;
                        ConstraintGroup cg = new ConstraintGroup(Operator.And);
                        ContextPathUtil pathConstraintUtil = new ContextPathUtil(this.context);
                        List<String> pathConstraints = pathConstraintUtil.getConstraintPaths();
                        FollowerConstraintUtil fcu = null;
                        for (Map.Entry<String, Object> entry : this.filters.entrySet()) {
                            ValueConstraint<String> constraint;
                            String key = entry.getKey();
                            Iterator<String> value = entry.getValue();
                            if (PROP_FILTER_SELECTION_NAME.equals(key)) {
                                if (selection == SocialActivityStream.Selection.USER) {
                                    constraint = new ValueConstraint<String>("actorId", this.userId);
                                    cg.addConstraint(constraint);
                                    continue;
                                }
                                if (selection != SocialActivityStream.Selection.FOLLOWER) continue;
                                String path = pathConstraints.size() > 0 ? pathConstraints.get(0) : null;
                                fcu = new FollowerConstraintUtil(path);
                                Constraint constraint2 = fcu.getFollowerConstraint();
                                if (constraint2 != null) {
                                    cg.addConstraint(constraint2);
                                    continue;
                                }
                                return this.activities;
                            }
                            if (value instanceof String) {
                                constraint = new ValueConstraint<String>(key, (String)((Object)value));
                                cg.addConstraint(constraint);
                                continue;
                            }
                            LOG.error("Unsupported filter type. " + value.getClass().getName());
                        }
                        ConstraintGroup cgTargetPaths = new ConstraintGroup();
                        SocialUtils socialUtils = resolver.adaptTo(SocialUtils.class);
                        String asiPath = socialUtils.getSocialResourceProvider(this.resource).getASIPath();
                        for (String pathConstraint : pathConstraints) {
                            if (!StringUtils.isNotEmpty(pathConstraint) || fcu != null && (fcu == null || fcu.matchedContextPath(pathConstraint))) continue;
                            String ending = pathConstraint.endsWith("/") ? "" : "/";
                            ValueConstraint<String> constraint = new ValueConstraint<String>("targetid_s", pathConstraint + ending, ComparisonType.BeginsWith);
                            constraint.setOperator(Operator.Or);
                            cgTargetPaths.addConstraint(constraint);
                            ValueConstraint<String> ugcconstraint = new ValueConstraint<String>("targetid_s", asiPath + pathConstraint + ending, ComparisonType.BeginsWith);
                            ugcconstraint.setOperator(Operator.Or);
                            cgTargetPaths.addConstraint(ugcconstraint);
                        }
                        if (cgTargetPaths.hasConstraints()) {
                            cg.addConstraint(cgTargetPaths);
                        }
                        if (cg.hasConstraints()) {
                            filter.addConstraint(cg);
                        }
                        UgcFilter customFilter = this.getCustomizedFilter(filter);
                        if (this.maxNumberActivities > 0) {
                            offset = 0;
                            size = this.maxNumberActivities;
                        } else {
                            offset = this.pagination.getOffset();
                            size = this.pagination.getSize();
                        }
                        for (Activity activity : stream.getActivities(offset, size, customFilter.hasConstraints() ? customFilter : null)) {
                            SyntheticResource activityResource = new SyntheticResource(resolver, activity.getPath(), "social/activitystreams/components/hbs/activitystreams/activity");
                            SocialComponentFactoryManager factoryManager = this.clientUtils.getSocialComponentFactoryManager();
                            SocialComponentFactory componentFactory = factoryManager.getSocialComponentFactory(activityResource);
                            SocialComponent sc = null;
                            sc = componentFactory instanceof SocialActivityComponentFactory ? ((SocialActivityComponentFactory)componentFactory).getSocialComponent((Resource)activityResource, this.clientUtils, (SocialActivity)activity) : componentFactory.getSocialComponent(activityResource, this.clientUtils, null);
                            if (sc == null) continue;
                            this.activities.add(sc);
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to obtain collection listing.", e);
            }
        }
        return this.activities;
    }

    @Override
    public String getStreamPath() {
        return this.streamPath;
    }

    @Override
    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    @Override
    public String getSelector() {
        SocialActivityStream.Selection selection = (SocialActivityStream.Selection)((Object)this.filters.get(PROP_FILTER_SELECTION_NAME));
        return selection.name();
    }

    @Override
    public boolean allowAllView() {
        return this.displayAllView;
    }

    @Override
    public boolean allowUserView() {
        return this.displayUserView;
    }

    @Override
    public boolean allowFollowingView() {
        return this.displayFollowingView;
    }

    private String getQueryParams(QueryRequestInfo queryInfo) {
        Map<String, String[]> params = queryInfo.getPredicates();
        StringBuilder sb = new StringBuilder();
        boolean firstParam = true;
        try {
            for (Map.Entry<String, String[]> ks : params.entrySet()) {
                String key = ks.getKey();
                String[] value = ks.getValue();
                for (int i = 0; i < value.length; ++i) {
                    if (!firstParam) {
                        sb.append("&");
                    } else {
                        firstParam = false;
                    }
                    sb.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value[i], "UTF-8"));
                }
            }
            String retVal = sb.toString();
            return retVal.isEmpty() ? null : retVal;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error encoding params.  " + sb.toString());
            return null;
        }
    }

    private com.adobe.cq.social.activitystreams.api.SocialActivityStream getStream(ResourceResolver resolver) {
        Resource streamResource = null;
        com.adobe.cq.social.activitystreams.api.SocialActivityStream stream = null;
        try {
            if (!StringUtils.isEmpty(this.streamPath)) {
                streamResource = resolver.resolve(this.streamPath);
            }
            if (streamResource != null) {
                stream = this.activityManager.getSocialStream(streamResource, this.streamName, true);
            }
        }
        catch (Exception e) {
            LOG.error("Error getting the stream", e);
        }
        return stream;
    }

    private class ContextPathUtil {
        private final CommunityContext context;

        public ContextPathUtil(CommunityContext context) {
            this.context = context;
        }

        public List<String> getConstraintPaths() {
            String pathConstraint = null;
            switch (AbstractActivityStream.this.activityContext) {
                case SITE: {
                    return this.context.getSiteContentPaths();
                }
                case COMMUNITIY_GROUP: {
                    pathConstraint = this.context.getCommunityGroupPath() + "/";
                    break;
                }
                case APP: {
                    pathConstraint = this.getApplicationPagePath();
                    break;
                }
                case PATH: {
                    pathConstraint = AbstractActivityStream.this.streamContextPath;
                    break;
                }
            }
            ArrayList<String> pathConstraints = new ArrayList<String>();
            if (StringUtils.isNotEmpty(pathConstraint)) {
                if (!pathConstraint.startsWith("/")) {
                    pathConstraint = "/" + pathConstraint;
                }
                pathConstraints.add(pathConstraint);
            }
            return pathConstraints;
        }

        private String getApplicationPagePath() {
            String path = AbstractActivityStream.this.resource.getPath();
            Session session = AbstractActivityStream.this.resource.getResourceResolver().adaptTo(Session.class);
            String pagePath = null;
            if (path.startsWith("/content")) {
                try {
                    while (path != null) {
                        Node parentNode;
                        String parentPath = ResourceUtil.getParent(path);
                        if (parentPath != null && (parentNode = session.getNode(parentPath)).isNodeType("cq:Page")) {
                            pagePath = parentNode.getPath();
                        }
                        path = parentPath;
                    }
                }
                catch (RepositoryException e) {
                    LOG.error("Failed to obtain application page path for " + path, e);
                }
            }
            return pagePath;
        }
    }

    private class FollowerConstraintUtil {
        private final String contextPath;
        private boolean matchedContext;
        private List<String> contextPaths = new ArrayList<String>();

        public FollowerConstraintUtil(String contextPath) {
            this.contextPath = contextPath;
        }

        public boolean matchedContextPath() {
            return this.matchedContext;
        }

        public boolean matchedContextPath(String path) {
            return !this.contextPaths.isEmpty() && this.contextPaths.contains(path);
        }

        public Constraint getFollowerConstraint() {
            ResourceResolver resolver = AbstractActivityStream.this.resource.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            if (session != null) {
                SocialGraph graph = resolver.adaptTo(SocialGraph.class);
                Resource contextResource = resolver.getResource(this.contextPath);
                if (contextResource != null) {
                    Iterable<Relationship> relationships;
                    Vertex vertex;
                    String ugcContextPath = AbstractActivityStream.this.clientUtils.getSocialUtils().resourceToUGCStoragePath(contextResource);
                    if (graph != null && (vertex = graph.getVertex(AbstractActivityStream.this.userId)) != null && (relationships = vertex.getRelationships(Direction.OUTGOING, AbstractActivityStream.FOLLOWINGS_LIST_TYPE)).iterator().hasNext()) {
                        ConstraintGroup group = new ConstraintGroup(Operator.And);
                        for (Relationship r : relationships) {
                            if (!(r instanceof Edge)) continue;
                            Edge edge = (Edge)r;
                            String endId = edge.getEndId();
                            if (endId.startsWith("/")) {
                                Resource resource = resolver.resolve(endId);
                                String ugcResourcePath = AbstractActivityStream.this.clientUtils.getSocialUtils().resourceToUGCStoragePath(resource);
                                if (!ugcResourcePath.startsWith(ugcContextPath)) continue;
                                if (resource.isResourceType(AbstractActivityStream.GROUP_RESOURCE_TYPE)) {
                                    ugcResourcePath = Text.getRelativeParent(ugcResourcePath, 1);
                                }
                                ValueConstraint<String> constraint = new ValueConstraint<String>("objectid_s", ugcResourcePath, ComparisonType.BeginsWith);
                                constraint.setOperator(Operator.Or);
                                group.addConstraint(constraint);
                                this.matchedContext = true;
                                this.contextPaths.add(ugcResourcePath);
                                continue;
                            }
                            ValueConstraint<String> constraint = new ValueConstraint<String>("actorId", edge.getEndId(), ComparisonType.Equals, Operator.Or);
                            group.addConstraint(constraint);
                        }
                        if (group.hasConstraints()) {
                            return group;
                        }
                    }
                } else {
                    LOG.warn("Failed to find context path resource: %s", (Object)this.contextPath);
                }
            }
            return null;
        }
    }
}

