/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.screens.impl.aemio;

import com.adobe.cq.screens.channel.ChannelService;
import com.adobe.cq.screens.device.Device;
import com.adobe.cq.screens.device.DeviceManager;
import com.adobe.cq.screens.impl.aemio.ScreensModelLookup;
import com.adobe.granite.haf.annotations.ApiAction;
import com.adobe.granite.haf.annotations.ApiEntities;
import com.adobe.granite.haf.annotations.ApiModel;
import com.adobe.granite.haf.annotations.ApiProperty;
import com.adobe.granite.haf.annotations.HttpFormParam;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class})
@ApiModel(category="screens", type={"aem-io/screens/channel"}, modelLookup=ScreensModelLookup.class)
public class ScreensChannelModel {
    @Inject
    @Self
    protected Resource baseResource;
    @Inject
    @Named(value="jcr:content")
    protected Resource jcrContent;

    @ApiProperty
    public String getTitle() {
        return (String)((Object)ResourceUtil.getValueMap(this.jcrContent).get("jcr:title", String.class));
    }

    @ApiProperty
    public String getDescription() {
        return (String)((Object)ResourceUtil.getValueMap(this.jcrContent).get("jcr:description", String.class));
    }

    @ApiProperty
    public boolean isSupportsOffline() {
        Resource offlineResource = this.baseResource.getChild("offline");
        Resource offlineConfigResource = offlineResource != null ? offlineResource.getChild("config") : null;
        return offlineConfigResource != null && offlineConfigResource.isResourceType("contentsync/config");
    }

    @ApiProperty
    public boolean isOffline() {
        return this.isSupportsOffline() && ResourceUtil.getValueMap(this.jcrContent).get("forceRemoteContent", true) == false;
    }

    @ApiEntities
    public Iterable<Resource> children() {
        ArrayList<Resource> results = new ArrayList<Resource>();
        Page page = this.baseResource.adaptTo(Page.class);
        if (page != null) {
            Iterator<Page> children = page.listChildren();
            while (children.hasNext()) {
                results.add(children.next().adaptTo(Resource.class));
            }
        }
        return results;
    }

    @ApiAction(method="POST", name="broadcast-command")
    public void executeCommand(@HttpFormParam(value="command") String msg, @HttpFormParam(value="command_payload", optional=true) String msgPayload) throws RepositoryException, JSONException {
        this.executeCommand(msg, msgPayload, false);
    }

    @ApiAction(method="POST", name="broadcast-command-with-ack")
    public void executeCommand(@HttpFormParam(value="command") String msg, @HttpFormParam(value="command_payload", optional=true) String msgPayload, @HttpFormParam(value="requires_ack", optional=true) Boolean requiresAck) throws RepositoryException, JSONException {
        DeviceManager dm = this.baseResource.getResourceResolver().adaptTo(DeviceManager.class);
        if (dm == null) {
            return;
        }
        JSONObject payload = null;
        if (msgPayload != null) {
            payload = new JSONObject(msgPayload);
        }
        Iterator<Device> devices = dm.getRelatedDevices(this.baseResource);
        while (devices.hasNext()) {
            dm.executeCommand(devices.next(), msg, payload, requiresAck != null && requiresAck != false);
        }
    }

    @ApiAction(method="POST", name="unassign")
    public void executeCommand(@HttpFormParam(value="displays") String displays) throws RepositoryException, JSONException {
        ResourceResolver resolver = this.baseResource.getResourceResolver();
        ArrayList<Resource> displayList = new ArrayList<Resource>();
        for (String displayPath : displays.split(",")) {
            Resource displayResource = resolver.getResource(displayPath);
            if (displayResource == null) continue;
            displayList.add(displayResource);
        }
        if (displayList.size() == 0) {
            return;
        }
        ChannelService channelSvc = resolver.adaptTo(ChannelService.class);
        if (channelSvc == null) {
            throw new JSONException("Could not load channel service.");
        }
        try {
            channelSvc.unassignFromDisplays(resolver, this.baseResource, displayList);
        }
        catch (RepositoryException e) {
            throw new JSONException(e.getMessage());
        }
        catch (PersistenceException e) {
            throw new JSONException(e.getMessage());
        }
    }
}

