/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.scheduled.exporter.process;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="process.label", value={"Extract Export Data"})
public class ExtractExportDataProcess
implements WorkflowProcess {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PN_PAYLOAD = "payload";
    private static final String NT_SLINGFOLDER = "sling:Folder";
    private static final String TYPE_JCR_PATH = "JCR_PATH";

    @Override
    public void execute(WorkItem item, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        String[] args = this.buildArguments(metaData);
        try {
            if (TYPE_JCR_PATH.equals(item.getWorkflowData().getPayloadType())) {
                Session session = workflowSession.getSession();
                String destPath = null;
                if (this.getValuesFromArgs(Arguments.DEST_PATH.getArgumentName(), args).size() > 0) {
                    destPath = this.getValuesFromArgs(Arguments.DEST_PATH.getArgumentName(), args).get(0);
                }
                if (destPath == null) {
                    this.log.error("Argument destPath missing.");
                    return;
                }
                String itemPath = item.getWorkflowData().getPayload().toString();
                String nodeName = DigestUtils.shaHex(itemPath.getBytes());
                if (!session.nodeExists(destPath + "/" + nodeName)) {
                    Node pathNode = JcrUtil.createPath(destPath + "/" + nodeName, NT_SLINGFOLDER, session);
                    pathNode.setProperty(PN_PAYLOAD, itemPath);
                }
                if (session.hasPendingChanges()) {
                    session.save();
                }
            }
        }
        catch (RepositoryException e) {
            this.log.error("execute: error while extracting data; work item [{}]: ", (Object)item.getId(), (Object)e);
        }
    }

    String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String targetpath = (String)((Object)metaData.get(Arguments.DEST_PATH.name(), String.class));
        if (StringUtils.isNotBlank(targetpath)) {
            arguments.add(Arguments.DEST_PATH.getArgumentPrefix() + targetpath);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    private List<String> getValuesFromArgs(String key, String[] arguments) {
        LinkedList<String> values = new LinkedList<String>();
        for (String str : arguments) {
            if (!str.startsWith(key + ":")) continue;
            String mt = str.substring((key + ":").length()).trim();
            values.add(mt);
        }
        return values;
    }

    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        DEST_PATH("destPath");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

