/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.processor.nui.util;

import com.day.cq.dam.api.Rendition;
import java.net.URI;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.binary.BinaryDownload;
import org.apache.jackrabbit.api.binary.BinaryDownloadOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectBinaryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DirectBinaryUtil.class);

    public static URI getRenditionCloudURI(Rendition rendition) {
        try {
            if (rendition != null) {
                Binary binary = rendition.getBinary();
                if (binary instanceof BinaryDownload) {
                    BinaryDownload binaryDownload = (BinaryDownload)binary;
                    String mimeType = rendition.getMimeType();
                    String fileName = rendition.getAsset().getName();
                    BinaryDownloadOptions downloadOptions = BinaryDownloadOptions.builder().withMediaType(mimeType).withFileName(fileName).withDispositionTypeInline().build();
                    URI uri = binaryDownload.getURI(downloadOptions);
                    if (uri != null) {
                        LOG.debug("Get cloud uri: {} for {}: ", (Object)uri, (Object)rendition.getPath());
                        return uri;
                    }
                    LOG.debug("Failed to get cloud uri for {} due to failed to get URI from Binary", (Object)rendition.getPath());
                } else {
                    LOG.debug("Failed to get cloud uri for {} due to binary isnot BinaryDownload", (Object)rendition.getPath());
                }
            } else {
                LOG.debug("Failed to get cloud uri for null rendition");
            }
        }
        catch (RepositoryException e) {
            LOG.debug("Failed to get cloud uri due to RepositoryException", e);
        }
        return null;
    }
}

