/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.dam.index.builder;

import com.adobe.cq.dam.index.builder.AggregationRule;
import com.adobe.cq.dam.index.builder.IndexRule;
import com.adobe.cq.dam.index.builder.api.IndexDefinition;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class LuceneIndexDefinition
implements IndexDefinition {
    private static Logger log = LoggerFactory.getLogger(LuceneIndexDefinition.class);
    String indexName;
    List<IndexRule> indexRules;
    List<AggregationRule> aggregationRules;

    public LuceneIndexDefinition(String indexName, List<AggregationRule> aggregationRules, List<IndexRule> indexRules) {
        this.indexName = indexName;
        this.aggregationRules = aggregationRules;
        this.indexRules = indexRules;
    }

    @Override
    public boolean build(Resource resource) {
        return this.build(resource, false);
    }

    @Override
    public boolean build(Resource resource, boolean reindex) {
        if (resource == null) {
            log.warn("LuceneIndexDefinition build failed due to null resource");
            return false;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        try {
            Resource oakIndexNode = resolver.getResource(resource, "oak:index");
            if (oakIndexNode == null) {
                oakIndexNode = resolver.create(resource, "oak:index", new ImmutableMap.Builder<String, String>().put("jcr:primaryType", "nt:unstructured").build());
            }
            log.info(oakIndexNode.getPath());
            if (resolver.getResource(oakIndexNode, this.indexName) != null) {
                resolver.delete(resolver.getResource(oakIndexNode, this.indexName));
            }
            Resource indexDefNode = resolver.create(oakIndexNode, this.indexName, new ImmutableMap.Builder<String, String>().put("jcr:primaryType", "oak:QueryIndexDefinition").put("async", "async").put("compatVersion", (String)((Object)Integer.valueOf(IndexFormatVersion.V2.getVersion()))).put("type", "lucene").put("evaluatePathRestrictions", (String)((Object)Boolean.valueOf(true))).put("reindex", (String)((Object)Boolean.valueOf(reindex))).build());
            Resource aggregatesNode = resolver.create(indexDefNode, "aggregates", ImmutableMap.of("jcr:primaryType", "nt:unstructured"));
            for (AggregationRule aggRule : this.aggregationRules) {
                aggRule.build(aggregatesNode);
            }
            Resource indexRulesNode = resolver.create(indexDefNode, "indexRules", ImmutableMap.of("jcr:primaryType", "nt:unstructured"));
            for (IndexRule indexRule : this.indexRules) {
                indexRule.build(indexRulesNode);
            }
            resolver.commit();
            return true;
        }
        catch (PersistenceException e) {
            log.error("Error while creating LuceneIndexDefinition at {}", (Object)resource.getPath(), (Object)e);
            return false;
        }
    }
}

