/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.pim.common;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.pim.api.CatalogBlueprintImporter;
import com.adobe.cq.commerce.pim.common.AbstractImporter;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(componentAbstract=true, metatype=true)
@Service
@ConsumerType
public abstract class AbstractBlueprintImporter
extends AbstractImporter
implements CatalogBlueprintImporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractBlueprintImporter.class);
    protected String basePath = "/content/catalogs";
    protected long startTime;
    protected int catalogCount;
    protected int sectionCount;

    @Override
    public void importBlueprints(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (!this.validateInput(request, response)) {
            return;
        }
        ResourceResolver resourceResolver = request.getResourceResolver();
        Session session = resourceResolver.adaptTo(Session.class);
        String storeName = request.getParameter("storeName");
        String storePath = request.getParameter("storePath");
        String provider = request.getParameter("provider");
        this.initTicker(request.getParameter("tickertoken"), session);
        Boolean incrementalImport = false;
        if (request.getParameter("incrementalImport") != null) {
            incrementalImport = true;
        }
        this.catalogCount = 0;
        this.sectionCount = 0;
        this.run(resourceResolver, storePath != null ? storePath : this.basePath, storeName, incrementalImport, provider);
        long millis = System.currentTimeMillis() - this.startTime;
        long seconds = millis / 1000L;
        if (seconds > 120L) {
            log.info("Imported " + this.catalogCount + " catalogs with " + this.sectionCount + " sections in " + seconds / 60L + " minutes.");
        } else {
            log.info("Imported " + this.catalogCount + " catalogs with " + this.sectionCount + " sections in " + seconds + " seconds.");
        }
        String msg = this.catalogCount + " catalogs created with " + this.sectionCount + " sections.";
        if (this.getErrorCount() > 0) {
            msg = msg + " " + this.getErrorCount() + " errors encountered.";
        }
        if (this.catalogCount > 0) {
            this.respondWithMessages(response, msg);
        } else {
            response.sendError(500, msg);
        }
    }

    protected abstract boolean validateInput(SlingHttpServletRequest var1, SlingHttpServletResponse var2) throws IOException;

    protected Page createCatalog(PageManager pageManager, String storePath, String catalogTitle, Session session) throws RepositoryException, WCMException {
        Page catalog = pageManager.create(storePath, AbstractBlueprintImporter.mangleName(catalogTitle), "/libs/commerce/templates/catalog", catalogTitle);
        Node contentNode = catalog.getContentResource().adaptTo(Node.class);
        String rolloutConfig_aem63 = "/etc/msm/rolloutconfigs/catalog";
        String rolloutConfig_aem64 = "/libs/msm/catalog/rolloutconfigs/catalog";
        String rolloutConfig = session.nodeExists("/etc/msm/rolloutconfigs/catalog") ? "/etc/msm/rolloutconfigs/catalog" : "/libs/msm/catalog/rolloutconfigs/catalog";
        this.setProperty(contentNode, "templates/cq_rolloutConfigs", "[" + rolloutConfig + "]");
        ++this.catalogCount;
        this.logMessage("Created catalog " + catalog.getPath(), false);
        this.checkpoint(session, false);
        return catalog;
    }

    protected Page createSection(PageManager pageManager, String parentPath, String[] hierarchy, String sectionTitle, Session session) throws RepositoryException, WCMException {
        for (int i = 0; i < hierarchy.length - 1; ++i) {
            parentPath = parentPath + "/" + AbstractBlueprintImporter.mangleName(hierarchy[i]);
        }
        String sectionName = hierarchy[hierarchy.length - 1];
        Page section = pageManager.create(parentPath, AbstractBlueprintImporter.mangleName(sectionName), "/libs/commerce/templates/section", sectionTitle);
        ++this.sectionCount;
        this.logMessage("Created section " + section.getPath(), false);
        this.updateTicker(this.makeTickerMessage());
        this.checkpoint(session, false);
        return section;
    }

    protected void setProperty(Node node, String propertyPath, String value) throws RepositoryException {
        String propertyName = propertyPath;
        if (propertyPath.contains("/")) {
            node = JcrUtil.createPath(node, propertyPath.substring(0, propertyPath.lastIndexOf("/")), false, "nt:unstructured", "nt:unstructured", node.getSession(), false);
            propertyName = propertyPath.substring(propertyPath.lastIndexOf("/") + 1);
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            String[] values = value.substring(1, value.length() - 1).split(",");
            node.setProperty(propertyName, values);
        } else {
            node.setProperty(propertyName, value);
        }
    }

    protected String makeTickerMessage() {
        return this.sectionCount + " section blueprints imported/updated";
    }
}

