/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpMethod;

public class CookieUtil {
    private static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    private static final String URL_HOST_REGEX = "https?://([\\w\\d_\\.\\-]*)(:\\d+)?(/.*)?";
    public static final String SESSION_COOKIE = "JSESSIONID";
    public static final boolean HTTP_ONLY = true;

    public static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, boolean httpOnly) {
        StringBuilder header = new StringBuilder();
        header.append(name).append("=").append(value);
        String contextPath = request.getContextPath();
        String cookiePath = contextPath == null || contextPath.length() == 0 ? "/" : contextPath;
        header.append("; Path=").append(cookiePath);
        if (maxAge >= 0) {
            header.append("; Max-Age=").append(maxAge);
        }
        if (httpOnly) {
            header.append("; HttpOnly");
        }
        if (request.isSecure()) {
            header.append("; Secure");
        }
        response.addHeader(HTTP_HEADER_SET_COOKIE, header.toString());
    }

    public static String hostFromUrl(String url) {
        Matcher matcher = Pattern.compile(URL_HOST_REGEX).matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Deprecated
    public static List<Cookie> getSessionCookies(HttpServletRequest request, String prefix, String remoteHost) {
        throw new UnsupportedOperationException("Method is deprecated and not supported any more");
    }

    @Deprecated
    public static void setSessionCookies(HttpServletResponse response, String prefix, List<Cookie> cookies) {
        throw new UnsupportedOperationException("Method is deprecated and not supported any more");
    }

    @Deprecated
    public static boolean hasUpdatedSessionCookies(HttpMethod method) {
        throw new UnsupportedOperationException("Method is deprecated and not supported any more");
    }

    @Deprecated
    public static boolean hasSessionCookie(List<Cookie> cookies) {
        throw new UnsupportedOperationException("Method is deprecated and not supported any more");
    }
}

