/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceSession;
import com.adobe.cq.commerce.api.OrderHistoryTraitDataProvider;
import com.adobe.cq.commerce.api.PlacedOrderResult;
import com.adobe.cq.commerce.api.PriceInfo;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionInfo;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.VoucherInfo;
import com.adobe.cq.commerce.common.AbstractJcrProduct;
import com.adobe.cq.commerce.common.DefaultJcrCartEntry;
import com.day.cq.commons.LanguageUtil;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommerceHelper {
    private static final Logger log = LoggerFactory.getLogger(CommerceHelper.class);

    public static String mapPathToCurrentLanguage(Page currentPage, String srcPath) {
        String languageRoot = LanguageUtil.getLanguageRoot(currentPage.getPath());
        if (StringUtils.isNotEmpty(languageRoot) && StringUtils.isNotBlank(srcPath)) {
            String srcSuffix = StringUtils.substringAfter(srcPath, LanguageUtil.getLanguageRoot(srcPath));
            return languageRoot + srcSuffix;
        }
        return srcPath;
    }

    public static Comparator<Product> getProductSizeComparator() {
        final String[] letterSizes = new String[]{"XXS", "2XS", "XS", "S", "M", "L", "XL", "XXL", "2XL", "XXXL", "3XL"};
        final String[] units = new String[]{"IN", "FT", "MM", "CM", "M"};
        return new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                String[] parts;
                String size1 = o1.getProperty("size", String.class).toUpperCase();
                String size2 = o2.getProperty("size", String.class).toUpperCase();
                if (CommerceHelper.indexOf(letterSizes, size1) >= 0 && CommerceHelper.indexOf(letterSizes, size2) >= 0) {
                    return NumberUtils.compare(CommerceHelper.indexOf(letterSizes, size1), CommerceHelper.indexOf(letterSizes, size2));
                }
                for (String unit : units) {
                    if (!size1.contains(unit) || !size2.contains(unit)) continue;
                    size1 = size1.replace(unit, "");
                    size2 = size2.replace(unit, "");
                }
                if (size1.contains("\"")) {
                    size1 = size1.replace("\"", "");
                }
                if (size1.indexOf("'") >= 1) {
                    parts = size1.split("'");
                    size1 = parts[0];
                    size1 = parts.length == 1 ? size1 + "00" : (parts[1].length() == 1 ? size1 + "0" + parts[1] : size1 + parts[1]);
                }
                if (size2.contains("\"")) {
                    size2 = size2.replace("\"", "");
                }
                if (size2.indexOf("'") >= 1) {
                    parts = size2.split("'");
                    size2 = parts[0];
                    size2 = parts.length == 1 ? size2 + "00" : (parts[1].length() == 1 ? size2 + "0" + parts[1] : size2 + parts[1]);
                }
                if (!NumberUtils.isNumber(size1) || !NumberUtils.isNumber(size2)) {
                    throw new IllegalArgumentException(String.format("Size values not recognized: %s, %s", o1.getProperty("size", String.class), o2.getProperty("size", String.class)));
                }
                double d1 = Double.parseDouble(size1);
                double d2 = Double.parseDouble(size2);
                return NumberUtils.compare(d1, d2);
            }
        };
    }

    private static int indexOf(String[] strings, String op) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(op)) continue;
            return i;
        }
        return -1;
    }

    public static Product findCurrentProduct(Page currentPage) {
        try {
            return CommerceHelper.findProduct(currentPage.getContentResource());
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    protected static Product findProduct(Resource resource) throws RepositoryException {
        Resource productResource = CommerceHelper.findProductResource(resource);
        if (productResource != null) {
            return productResource.adaptTo(Product.class);
        }
        return null;
    }

    public static Resource findProductResource(Page page) {
        return CommerceHelper.findProductResource(page.getContentResource());
    }

    public static Resource findProductResource(Resource resource) {
        if (AbstractJcrProduct.isABaseProduct(resource)) {
            return resource;
        }
        Iterator<Resource> iter = resource.listChildren();
        while (iter.hasNext()) {
            Resource product = CommerceHelper.findProductResource(iter.next());
            if (product == null) continue;
            return product;
        }
        return null;
    }

    public static void collectVariants(Resource resource, Map<String, Product> variations) {
        ValueMap properties;
        String key;
        if (AbstractJcrProduct.isAProductOrVariant(resource) && (key = (String)((Object)(properties = resource.adaptTo(ValueMap.class)).get("productData", String.class))) != null && !properties.get("cq:RolloutHookSyncAction", false).booleanValue()) {
            variations.put(key, resource.adaptTo(Product.class));
        }
        Iterator<Resource> children = resource.listChildren();
        while (children.hasNext()) {
            CommerceHelper.collectVariants(children.next(), variations);
        }
    }

    public static boolean copyTags(Product source, Resource dest, Predicate filter) throws RepositoryException {
        String[] sourceTags;
        TagManager tagManager = dest.getResourceResolver().adaptTo(TagManager.class);
        ArrayList<String> resultTags = new ArrayList<String>();
        boolean changed = false;
        String[] destTags = (String[])ResourceUtil.getValueMap(dest).get("cq:tags", String[].class);
        if (destTags != null) {
            resultTags.addAll(Arrays.asList(destTags));
        }
        if ((sourceTags = source.getProperty("cq:tags", String[].class)) != null) {
            for (String sourceTag : sourceTags) {
                Tag tag = tagManager.resolve(sourceTag);
                if (tag == null || !filter.evaluate(tag) || resultTags.contains(sourceTag)) continue;
                resultTags.add(sourceTag);
                changed = true;
            }
        }
        if (changed) {
            dest.adaptTo(Node.class).setProperty("cq:tags", resultTags.toArray(new String[resultTags.size()]));
        }
        return changed;
    }

    public static void writeCart(JSONWriter writer, CommerceSession commerceSession) throws CommerceException, JSONException {
        CommerceHelper.writeCart(writer, commerceSession, null);
    }

    @Deprecated
    public static void writeCart(JSONWriter writer, CommerceSession commerceSession, ResourceResolver resolver) throws CommerceException, JSONException {
        CommerceHelper.writeCart(writer, commerceSession, resolver, null);
    }

    @Deprecated
    public static void writeCart(JSONWriter writer, CommerceSession commerceSession, ResourceResolver resolver, SlingHttpServletRequest request) throws CommerceException, JSONException {
        PromotionManager pm = resolver != null ? resolver.adaptTo(PromotionManager.class) : null;
        HashMap<String, String> serverPromotionsMap = new HashMap<String, String>();
        if (pm != null) {
            for (Promotion promotion : pm.getAvailablePromotions(resolver)) {
                ValueMap props;
                String code;
                if (!"/libs/commerce/components/promotion/server".equals(promotion.getType()) || !StringUtils.isNotBlank(code = (props = promotion.getConfig()).get("code", "")) || props.get("disabled", Boolean.FALSE).booleanValue()) continue;
                serverPromotionsMap.put(code, StringUtils.join(promotion.getSegments(), ","));
            }
        }
        Map<Object, Object> clientPromotionsMap = new HashMap();
        if (pm != null && request != null) {
            clientPromotionsMap = pm.getPromotionsMap(request);
        }
        writer.object();
        writer.key("entries").array();
        for (CommerceSession.CartEntry e : commerceSession.getCartEntries()) {
            DefaultJcrCartEntry entry;
            ValueMap properties;
            writer.object();
            writer.key("title").value(e.getProduct().getTitle());
            writer.key("quantity").value(e.getQuantity());
            List<PriceInfo> priceInfos = e.getPriceInfo(null);
            if (priceInfos != null && priceInfos.size() > 0) {
                writer.key("priceFormatted").value(priceInfos.get(0).getFormattedString());
                writer.key("price").value(priceInfos.get(0).getAmount());
            } else {
                log.error("Empty PriceInfo list for product!", (Object)e.getProduct().getPath());
                writer.key("priceFormatted").value("$0.00");
                writer.key("price").value(0L);
            }
            String thumbnail = e.getProduct().getThumbnailUrl(".64.transparent");
            if (StringUtils.isNotEmpty(thumbnail)) {
                writer.key("thumbnail").value(thumbnail);
            }
            writer.key("page").value(e.getProduct().getPagePath());
            writer.key("path").value(e.getProduct().getPath());
            Boolean readonly = e.getProperty("readonly", Boolean.class);
            if (readonly != null && readonly.booleanValue()) {
                writer.key("readonly").value(true);
            }
            if (e instanceof DefaultJcrCartEntry && !(properties = (entry = (DefaultJcrCartEntry)e).getProperties()).isEmpty()) {
                writer.key("properties").object();
                for (String key : properties.keySet()) {
                    writer.key(key).value(properties.get(key, String.class));
                }
                writer.endObject();
            }
            writer.endObject();
        }
        writer.endArray();
        writer.key("promotions").array();
        for (PromotionInfo p : commerceSession.getPromotions()) {
            if (p.getStatus() != PromotionInfo.PromotionStatus.FIRED && p.getStatus() != PromotionInfo.PromotionStatus.POTENTIAL) continue;
            writer.object();
            writer.key("title").value(p.getTitle());
            writer.key("description").value(p.getDescription());
            writer.key("message").value(p.getMessage());
            writer.key("path").value(p.getPath());
            writer.key("status").value(p.getStatus().toString());
            writer.key("cartEntryIndex").value(p.getCartEntryIndex());
            if (p.getStatus().equals((Object)PromotionInfo.PromotionStatus.FIRED) && serverPromotionsMap.containsKey(p.getPath())) {
                writer.key("resolve").value("true");
            }
            writer.endObject();
        }
        writer.endArray();
        writer.key("vouchers").array();
        for (VoucherInfo c : commerceSession.getVoucherInfos()) {
            writer.object();
            writer.key("code").value(c.getCode());
            writer.key("title").value(c.getTitle());
            writer.key("description").value(c.getDescription());
            writer.key("message").value(c.getMessage());
            writer.key("path").value(c.getPath());
            writer.endObject();
        }
        writer.endArray();
        List<PriceInfo> list = commerceSession.getCartPriceInfo(null);
        if (list != null && list.size() > 0) {
            writer.key("totalPrice").value(list.get(0).getFormattedString());
            writer.key("totalPriceFloat").value(list.get(0).getAmount());
        } else {
            log.error("Empty PriceInfo list for cart!");
            writer.key("totalPrice").value("$0.00");
            writer.key("totalPriceFloat").value(0L);
        }
        writer.key("promotionsMap").array();
        Map<Object, Object> map = commerceSession.supportsClientsidePromotionResolution() ? clientPromotionsMap : serverPromotionsMap;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            writer.object();
            writer.key("segments").value(entry.getValue());
            writer.key("path").value(entry.getKey());
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    public static void writeOrderHistory(JSONWriter writer, PlacedOrderResult orderHistory, OrderHistoryTraitDataProvider[] services) throws CommerceException, JSONException {
        if (services == null) {
            services = new OrderHistoryTraitDataProvider[]{};
        }
        writer.object();
        writer.key("traits").object();
        Arrays.sort(services, new Comparator<OrderHistoryTraitDataProvider>(){

            @Override
            public int compare(OrderHistoryTraitDataProvider o1, OrderHistoryTraitDataProvider o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (OrderHistoryTraitDataProvider trait : services) {
            writer.key(trait.getIdentifier()).object();
            writer.key("name").value(trait.getName());
            writer.key("data");
            Object data = trait.getTraitData(orderHistory);
            if (data instanceof Map) {
                writer.object();
                Map map = (Map)data;
                for (Map.Entry entry : map.entrySet()) {
                    writer.key((String)entry.getKey());
                    writer.value(entry.getValue());
                }
                writer.endObject();
            } else if (data instanceof Collection) {
                writer.array();
                for (Object o : (Collection)data) {
                    writer.value(o);
                }
                writer.endArray();
            } else {
                writer.value(data);
            }
            writer.endObject();
        }
        writer.endObject();
        writer.endObject();
    }

    public static String getCatalogCardThumbnail(String contextPath, Resource resource, PageManager pageManager) {
        HierarchyNodeInheritanceValueMap blueprintProps;
        ValueMap properties = resource.adaptTo(ValueMap.class);
        Page templatePage = null;
        if (ResourceUtil.isA(resource, "commerce/components/catalog")) {
            blueprintProps = new HierarchyNodeInheritanceValueMap(resource);
            templatePage = pageManager.getPage(blueprintProps.getInherited("templates/catalog", ""));
        } else if (ResourceUtil.isA(resource, "commerce/components/section")) {
            blueprintProps = new HierarchyNodeInheritanceValueMap(resource);
            templatePage = pageManager.getPage(blueprintProps.getInherited("templates/section", ""));
        }
        if (templatePage != null) {
            String url = contextPath + templatePage.getPath() + ".thumb.319.319.png";
            Calendar lastMod = (Calendar)((Object)templatePage.getProperties().get("image/file/jcr:content/jcr:lastModified", Calendar.class));
            if (lastMod != null) {
                url = url + "?ck=" + lastMod.getTimeInMillis() / 1000L;
            }
            return url;
        }
        String coverUrl = (String)((Object)properties.get("coverUrl", String.class));
        if (coverUrl != null) {
            return coverUrl + ".thumb.319.319.png";
        }
        return contextPath + resource.getParent().getPath() + ".thumb.319.319.png";
    }

    public static String getCardTitle(Resource resource, PageManager pageManager) {
        String jcrTitle;
        if (AbstractJcrProduct.isAProductOrVariant(resource)) {
            String jcrTitle2 = (String)((Object)resource.getValueMap().get("jcr:title", String.class));
            if (StringUtils.isNotBlank(jcrTitle2)) {
                return jcrTitle2;
            }
            String title = resource.getName();
            for (resource = resource.getParent(); resource != null; resource = resource.getParent()) {
                jcrTitle2 = (String)((Object)resource.getValueMap().get("jcr:title", String.class));
                if (StringUtils.isNotBlank(jcrTitle2)) {
                    title = jcrTitle2 + " / " + title;
                    return title;
                }
                title = resource.getName() + " / " + title;
            }
            return title;
        }
        Page page = pageManager.getPage(resource.getPath());
        if (page != null) {
            return page.getTitle();
        }
        Resource jcr_content = resource.getChild("jcr:content");
        if (jcr_content != null && StringUtils.isNotBlank(jcrTitle = (String)((Object)jcr_content.getValueMap().get("jcr:title", String.class)))) {
            return jcrTitle;
        }
        jcrTitle = (String)((Object)resource.getValueMap().get("jcr:title", String.class));
        if (StringUtils.isNotBlank(jcrTitle)) {
            return jcrTitle;
        }
        String title = resource.getName();
        if (title.matches("\\d+")) {
            resource = resource.getParent();
            while (resource.getName().matches("\\d+")) {
                title = resource.getName() + "." + title;
                resource = resource.getParent();
            }
        }
        return title;
    }

    public static String getProductCardThumbnail(String contextPath, Product product) {
        String thumbnail = product.getThumbnailUrl(319);
        if (StringUtils.isNotEmpty(thumbnail)) {
            return contextPath + thumbnail;
        }
        return null;
    }
}

