/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.common;

import aQute.bnd.annotation.ConsumerType;
import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.CommerceQuery;
import com.adobe.cq.commerce.api.CommerceResult;
import com.adobe.cq.commerce.api.CommerceService;
import com.adobe.cq.commerce.api.PaymentMethod;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.ShippingMethod;
import com.adobe.cq.commerce.api.collection.ProductCollection;
import com.adobe.cq.commerce.api.conf.CommerceBasePathsService;
import com.adobe.cq.commerce.api.promotion.Promotion;
import com.adobe.cq.commerce.api.promotion.PromotionManager;
import com.adobe.cq.commerce.api.promotion.Voucher;
import com.adobe.cq.commerce.common.AbstractJcrCommerceServiceFactory;
import com.adobe.cq.commerce.common.CommerceSearchProvider;
import com.adobe.cq.commerce.common.DefaultJcrCartEntry;
import com.adobe.cq.commerce.common.ServiceContext;
import com.adobe.cq.commerce.common.VendorJcrPlacedOrder;
import com.day.cq.wcm.api.Page;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

@ConsumerType
public abstract class AbstractJcrCommerceService
implements CommerceService {
    private final ServiceContext serviceContext;
    protected Map<String, Object> context = new HashMap<String, Object>();
    protected CommerceSearchProvider searchProvider;
    protected ResourceResolver resolver;
    @Deprecated
    public AbstractJcrCommerceServiceFactory.Services services;

    protected AbstractJcrCommerceService(ServiceContext serviceContext, Resource resource) {
        this.serviceContext = serviceContext;
        this.resolver = resource.getResourceResolver();
    }

    public ServiceContext serviceContext() {
        return this.serviceContext;
    }

    @Override
    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public String getServer() {
        return null;
    }

    @Override
    public boolean isActivated(Product product) throws CommerceException {
        return true;
    }

    @Override
    public Promotion getPromotion(String path) throws CommerceException {
        Resource resource = this.resolver.getResource(path);
        return resource != null ? resource.adaptTo(Promotion.class) : null;
    }

    @Override
    public Voucher getVoucher(String path) throws CommerceException {
        Resource resource = this.resolver.getResource(path);
        return resource != null ? resource.adaptTo(Voucher.class) : null;
    }

    @Override
    public ProductCollection getProductCollection(String path) throws CommerceException {
        Resource resource = this.resolver.getResource(path);
        return resource != null ? resource.adaptTo(ProductCollection.class) : null;
    }

    public VendorJcrPlacedOrder getPlacedOrder(String orderId, Locale locale) {
        return new VendorJcrPlacedOrder(this, orderId, locale);
    }

    @Override
    public void catalogRolloutHook(Page blueprint, Page catalog) throws CommerceException {
    }

    @Override
    public void sectionRolloutHook(Page blueprint, Page section) {
    }

    @Override
    public void productRolloutHook(Product productData, Page productPage, Product productReference) throws CommerceException {
    }

    @Override
    public CommerceResult search(CommerceQuery query) throws CommerceException {
        if (this.searchProvider == null) {
            this.searchProvider = this.getSearchProvider();
        }
        if (this.searchProvider != null) {
            return this.searchProvider.search(query, this);
        }
        return null;
    }

    protected CommerceSearchProvider getSearchProvider() throws CommerceException {
        String providerName = this.getSearchProviderName();
        if (providerName != null) {
            return this.serviceContext.searchProviderManager.getSearchProvider(providerName);
        }
        return null;
    }

    protected String getSearchProviderName() {
        return null;
    }

    @Override
    public List<Promotion> getAvailablePromotions(ResourceResolver resourceResolver) throws CommerceException {
        PromotionManager promotionManager = resourceResolver.adaptTo(PromotionManager.class);
        return promotionManager.getAvailablePromotions(resourceResolver);
    }

    public List<ShippingMethod> getAvailableShippingMethods() throws CommerceException {
        CommerceBasePathsService cbps = this.resolver.adaptTo(CommerceBasePathsService.class);
        return this.enumerateMethods(cbps.getShippingMethodsBasePath(), ShippingMethod.class);
    }

    public List<PaymentMethod> getAvailablePaymentMethods() throws CommerceException {
        CommerceBasePathsService cbps = this.resolver.adaptTo(CommerceBasePathsService.class);
        return this.enumerateMethods(cbps.getPaymentMethodsBasePath(), PaymentMethod.class);
    }

    protected <T> List<T> enumerateMethods(String path, Class<T> type) {
        ArrayList<T> methods = new ArrayList<T>();
        Resource dir = this.resolver.getResource(path);
        if (dir != null) {
            for (Resource resource : dir.getChildren()) {
                T method;
                if (resource.getName().equals("jcr:content") || (method = resource.adaptTo(type)) == null) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public DefaultJcrCartEntry newCartEntryImpl(int index, Product product, int quantity) {
        return new DefaultJcrCartEntry(index, product, quantity);
    }

    public String serializeCartEntryData(String productPath, int quantity, ValueMap properties) {
        StringBuilder sb = new StringBuilder();
        sb.append(productPath).append(';').append(quantity);
        if (properties == null || properties.isEmpty()) {
            return sb.toString();
        }
        sb.append(';');
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            sb.append(key).append('=').append(value).append('\f');
        }
        return sb.toString();
    }

    public Object[] deserializeCartEntryData(String str) throws CommerceException {
        String[] propertyFields;
        Object[] entryData = new Object[3];
        String[] entryFields = str.split(";", 3);
        Product product = this.getProduct(entryFields[0]);
        entryData[0] = product;
        int quantity = Integer.parseInt(entryFields[1]);
        entryData[1] = quantity;
        if (entryFields.length == 2) {
            return entryData;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String field : propertyFields = entryFields[2].split("\f")) {
            if (!StringUtils.isNotBlank(field)) continue;
            String[] property = field.split("=", 2);
            properties.put(property[0], property[1]);
        }
        entryData[2] = properties;
        return entryData;
    }

    @Deprecated
    public AbstractJcrCommerceService(AbstractJcrCommerceServiceFactory.Services services) {
        this((ServiceContext)null);
        this.services = services;
    }

    @Deprecated
    protected AbstractJcrCommerceService(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }
}

