/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.util;

import com.adobe.agl.impl.Utility;

public class ByteArrayWrapper
implements Comparable {
    public byte[] bytes;
    public int size;

    public ByteArrayWrapper ensureCapacity(int capacity) {
        if (this.bytes == null || this.bytes.length < capacity) {
            byte[] newbytes = new byte[capacity];
            ByteArrayWrapper.copyBytes(this.bytes, 0, newbytes, 0, this.size);
            this.bytes = newbytes;
        }
        return this;
    }

    public final ByteArrayWrapper set(byte[] src, int start, int limit) {
        this.size = 0;
        this.append(src, start, limit);
        return this;
    }

    public final ByteArrayWrapper append(byte[] src, int start, int limit) {
        int len = limit - start;
        this.ensureCapacity(this.size + len);
        ByteArrayWrapper.copyBytes(src, start, this.bytes, this.size, len);
        this.size += len;
        return this;
    }

    public final byte[] releaseBytes() {
        byte[] result = this.bytes;
        this.bytes = null;
        this.size = 0;
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                result.append(" ");
            }
            result.append(Utility.hex(this.bytes[i] & 0xFF, 2));
        }
        return result.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        try {
            ByteArrayWrapper that = (ByteArrayWrapper)other;
            if (this.size != that.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.bytes[i] == that.bytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        int result = this.bytes.length;
        for (int i = 0; i < this.size; ++i) {
            result = 37 * result + this.bytes[i];
        }
        return result;
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        ByteArrayWrapper that = (ByteArrayWrapper)other;
        int minSize = this.size < that.size ? this.size : that.size;
        for (int i = 0; i < minSize; ++i) {
            if (this.bytes[i] == that.bytes[i]) continue;
            return (this.bytes[i] & 0xFF) - (that.bytes[i] & 0xFF);
        }
        return this.size - that.size;
    }

    private static final void copyBytes(byte[] src, int srcoff, byte[] tgt, int tgtoff, int length) {
        if (length < 64) {
            int i = srcoff;
            int n = tgtoff;
            while (--length >= 0) {
                tgt[n] = src[i];
                ++i;
                ++n;
            }
        } else {
            System.arraycopy(src, srcoff, tgt, tgtoff, length);
        }
    }
}

