/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.impl.NormalizerImpl;
import com.adobe.agl.text.UCharacterIterator;
import com.adobe.agl.text.UTF16;
import com.adobe.agl.text.UnicodeSet;
import com.adobe.agl.util.VersionInfo;

public final class Normalizer
implements Cloneable {
    private char[] buffer;
    private UCharacterIterator text;
    public static final Mode NONE = new Mode(1);
    public static final Mode NFD = new NFDMode(2);
    public static final Mode NFKD = new NFKDMode(3);
    public static final Mode NFC;
    public static final Mode DEFAULT;
    public static final Mode NFKC;
    public static final Mode FCD;
    public static final Mode NO_OP;
    public static final Mode COMPOSE;
    public static final Mode COMPOSE_COMPAT;
    public static final Mode DECOMP;
    public static final Mode DECOMP_COMPAT;
    public static final QuickCheckResult NO;
    public static final QuickCheckResult YES;
    public static final QuickCheckResult MAYBE;

    public Object clone() {
        try {
            Normalizer copy = (Normalizer)super.clone();
            copy.text = (UCharacterIterator)this.text.clone();
            if (this.buffer != null) {
                copy.buffer = new char[this.buffer.length];
                System.arraycopy(this.buffer, 0, copy.buffer, 0, this.buffer.length);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public static String compose(String str, boolean compat) {
        return Normalizer.compose(str, compat, 0);
    }

    public static String compose(String str, boolean compat, int options) {
        char[] dest = new char[str.length() * 2];
        int destSize = 0;
        char[] src = str.toCharArray();
        UnicodeSet nx = NormalizerImpl.getNX(options);
        options &= 0xFFFFCF00;
        if (compat) {
            options |= 0x1000;
        }
        while ((destSize = NormalizerImpl.compose(src, 0, src.length, dest, 0, dest.length, options, nx)) > dest.length) {
            dest = new char[destSize];
        }
        return new String(dest, 0, destSize);
    }

    public static String decompose(String str, boolean compat) {
        return Normalizer.decompose(str, compat, 0);
    }

    public static String decompose(String str, boolean compat, int options) {
        char[] dest = new char[str.length() * 3];
        int[] trailCC = new int[1];
        int destSize = 0;
        UnicodeSet nx = NormalizerImpl.getNX(options);
        while ((destSize = NormalizerImpl.decompose(str.toCharArray(), 0, str.length(), dest, 0, dest.length, compat, trailCC, nx)) > dest.length) {
            dest = new char[destSize];
        }
        return new String(dest, 0, destSize);
    }

    private static String makeFCD(String src, int options) {
        int srcLen = src.length();
        char[] dest = new char[3 * srcLen];
        int length = 0;
        UnicodeSet nx = NormalizerImpl.getNX(options);
        while ((length = NormalizerImpl.makeFCD(src.toCharArray(), 0, srcLen, dest, 0, dest.length, nx)) > dest.length) {
            dest = new char[length];
        }
        return new String(dest, 0, length);
    }

    public static String normalize(String str, Mode mode, int options) {
        return mode.normalize(str, options);
    }

    public static String normalize(String src, Mode mode) {
        return Normalizer.normalize(src, mode, 0);
    }

    public static String normalize(int char32, Mode mode) {
        return Normalizer.normalize(UTF16.valueOf(char32), mode, 0);
    }

    public static QuickCheckResult quickCheck(String source, Mode mode, int options) {
        return mode.quickCheck(source.toCharArray(), 0, source.length(), true, NormalizerImpl.getNX(options));
    }

    public static int compare(char[] s1, int s1Start, int s1Limit, char[] s2, int s2Start, int s2Limit, int options) {
        return Normalizer.internalCompare(s1, s1Start, s1Limit, s2, s2Start, s2Limit, options);
    }

    public static int compare(String s1, String s2, int options) {
        return Normalizer.compare(s1.toCharArray(), 0, s1.length(), s2.toCharArray(), 0, s2.length(), options);
    }

    public static boolean isNFSkippable(int c, Mode mode) {
        return mode.isNFSkippable(c);
    }

    private static int internalCompare(char[] s1, int s1Start, int s1Limit, char[] s2, int s2Start, int s2Limit, int options) {
        Mode mode;
        char[] fcd1 = new char[300];
        char[] fcd2 = new char[300];
        if (s1 == null || s1Start < 0 || s1Limit < 0 || s2 == null || s2Start < 0 || s2Limit < 0 || s1Limit < s1Start || s2Limit < s2Start) {
            throw new IllegalArgumentException();
        }
        UnicodeSet nx = NormalizerImpl.getNX(options >> 20);
        int result = 0;
        if (((options |= 0x80000) & 1) > 0) {
            mode = NFD;
            options &= 0xFFFDFFFF;
        } else {
            mode = FCD;
        }
        if ((options & 0x20000) == 0) {
            char[] dest;
            boolean isFCD2;
            boolean isFCD1 = YES == mode.quickCheck(s1, s1Start, s1Limit, true, nx);
            boolean bl = isFCD2 = YES == mode.quickCheck(s2, s2Start, s2Limit, true, nx);
            if (!isFCD1) {
                int fcdLen1 = mode.normalize(s1, 0, s1.length, fcd1, 0, fcd1.length, nx);
                if (fcdLen1 > fcd1.length) {
                    dest = new char[fcdLen1];
                    fcdLen1 = mode.normalize(s1, 0, s1.length, dest, 0, dest.length, nx);
                    s1 = dest;
                } else {
                    s1 = fcd1;
                }
                s1Limit = fcdLen1;
                s1Start = 0;
            }
            if (!isFCD2) {
                int fcdLen2 = mode.normalize(s2, s2Start, s2Limit, fcd2, 0, fcd2.length, nx);
                if (fcdLen2 > fcd2.length) {
                    dest = new char[fcdLen2];
                    fcdLen2 = mode.normalize(s2, s2Start, s2Limit, dest, 0, dest.length, nx);
                    s2 = dest;
                } else {
                    s2 = fcd2;
                }
                s2Limit = fcdLen2;
                s2Start = 0;
            }
        }
        result = NormalizerImpl.cmpEquivFold(s1, s1Start, s1Limit, s2, s2Start, s2Limit, options);
        return result;
    }

    static VersionInfo getUnicodeVersion() {
        return NormalizerImpl.getUnicodeVersion();
    }

    static {
        DEFAULT = NFC = new NFCMode(4);
        NFKC = new NFKCMode(5);
        FCD = new FCDMode(6);
        NO_OP = NONE;
        COMPOSE = NFC;
        COMPOSE_COMPAT = NFKC;
        DECOMP = NFD;
        DECOMP_COMPAT = NFKD;
        NO = new QuickCheckResult(0);
        YES = new QuickCheckResult(1);
        MAYBE = new QuickCheckResult(2);
    }

    public static final class QuickCheckResult {
        private QuickCheckResult(int value) {
        }
    }

    private static final class FCDMode
    extends Mode {
        private FCDMode(int value) {
            super(value);
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            return NormalizerImpl.makeFCD(src, srcStart, srcLimit, dest, destStart, destLimit, nx);
        }

        protected String normalize(String src, int options) {
            return Normalizer.makeFCD(src, options);
        }

        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.checkFCD(src, start, limit, nx) ? YES : NO;
        }

        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.getFCD16(c) > 1;
        }
    }

    private static final class NFKCMode
    extends Mode {
        private NFKCMode(int value) {
            super(value);
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            return NormalizerImpl.compose(src, srcStart, srcLimit, dest, destStart, destLimit, 4096, nx);
        }

        protected String normalize(String src, int options) {
            return Normalizer.compose(src, true, options);
        }

        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(7), 34, 4096, allowMaybe, nx);
        }

        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65474L);
        }
    }

    private static final class NFCMode
    extends Mode {
        private NFCMode(int value) {
            super(value);
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            return NormalizerImpl.compose(src, srcStart, srcLimit, dest, destStart, destLimit, 0, nx);
        }

        protected String normalize(String src, int options) {
            return Normalizer.compose(src, false, options);
        }

        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(6), 17, 0, allowMaybe, nx);
        }

        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65473L);
        }
    }

    private static final class NFKDMode
    extends Mode {
        private NFKDMode(int value) {
            super(value);
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            int[] trailCC = new int[1];
            return NormalizerImpl.decompose(src, srcStart, srcLimit, dest, destStart, destLimit, true, trailCC, nx);
        }

        protected String normalize(String src, int options) {
            return Normalizer.decompose(src, true);
        }

        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(9), 8, 4096, allowMaybe, nx);
        }

        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65288L);
        }
    }

    private static final class NFDMode
    extends Mode {
        private NFDMode(int value) {
            super(value);
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            int[] trailCC = new int[1];
            return NormalizerImpl.decompose(src, srcStart, srcLimit, dest, destStart, destLimit, false, trailCC, nx);
        }

        protected String normalize(String src, int options) {
            return Normalizer.decompose(src, false);
        }

        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            return NormalizerImpl.quickCheck(src, start, limit, NormalizerImpl.getFromIndexesArr(8), 4, 0, allowMaybe, nx);
        }

        protected boolean isNFSkippable(int c) {
            return NormalizerImpl.isNFSkippable(c, this, 65284L);
        }
    }

    public static class Mode {
        private Mode(int value) {
        }

        protected int normalize(char[] src, int srcStart, int srcLimit, char[] dest, int destStart, int destLimit, UnicodeSet nx) {
            int srcLen = srcLimit - srcStart;
            int destLen = destLimit - destStart;
            if (srcLen > destLen) {
                return srcLen;
            }
            System.arraycopy(src, srcStart, dest, destStart, srcLen);
            return srcLen;
        }

        protected String normalize(String src, int options) {
            return src;
        }

        protected QuickCheckResult quickCheck(char[] src, int start, int limit, boolean allowMaybe, UnicodeSet nx) {
            if (allowMaybe) {
                return MAYBE;
            }
            return NO;
        }

        protected boolean isNFSkippable(int c) {
            return true;
        }
    }
}

