/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.text;

import com.adobe.agl.text.RawCollationKey;

public final class CollationKey
implements Comparable {
    private byte[] m_key_;
    private String m_source_;
    private int m_hashCode_;
    private int m_length_;

    public CollationKey(String source, RawCollationKey key) {
        this.m_source_ = source;
        this.m_key_ = key.releaseBytes();
        this.m_hashCode_ = 0;
        this.m_length_ = -1;
    }

    public String getSourceString() {
        return this.m_source_;
    }

    public int compareTo(CollationKey target) {
        int i = 0;
        int r;
        int l;
        while ((l = this.m_key_[i] & 0xFF) >= (r = target.m_key_[i] & 0xFF)) {
            if (l > r) {
                return 1;
            }
            if (l == 0) {
                return 0;
            }
            ++i;
        }
        return -1;
    }

    public int compareTo(Object obj) {
        return this.compareTo((CollationKey)obj);
    }

    public boolean equals(Object target) {
        if (!(target instanceof CollationKey)) {
            return false;
        }
        return this.equals((CollationKey)target);
    }

    public boolean equals(CollationKey target) {
        if (this == target) {
            return true;
        }
        if (target == null) {
            return false;
        }
        CollationKey other = target;
        int i = 0;
        while (true) {
            if (this.m_key_[i] != other.m_key_[i]) {
                return false;
            }
            if (this.m_key_[i] == 0) break;
            ++i;
        }
        return true;
    }

    public int hashCode() {
        if (this.m_hashCode_ == 0) {
            if (this.m_key_ == null) {
                this.m_hashCode_ = 1;
            } else {
                int size = this.m_key_.length >> 1;
                StringBuffer key = new StringBuffer(size);
                int i = 0;
                while (this.m_key_[i] != 0 && this.m_key_[i + 1] != 0) {
                    key.append((char)(this.m_key_[i] << 8 | this.m_key_[i + 1]));
                    i += 2;
                }
                if (this.m_key_[i] != 0) {
                    key.append((char)(this.m_key_[i] << 8));
                }
                this.m_hashCode_ = key.toString().hashCode();
            }
        }
        return this.m_hashCode_;
    }
}

