/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.agl.impl;

import com.adobe.agl.impl.ICUResourceBundle;
import com.adobe.agl.impl.ICUResourceBundleReader;
import com.adobe.agl.util.ULocale;
import com.adobe.agl.util.UResourceBundle;
import com.adobe.agl.util.UResourceBundleIterator;
import com.adobe.agl.util.UResourceTypeMismatchException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.MissingResourceException;

class ICUResourceBundleImpl {

    static final class ResourceTable32
    extends ICUResourceBundle {
        protected UResourceBundle handleGetImpl(String resKey, HashMap table, UResourceBundle requested, int[] index, boolean[] isAlias) {
            int offset = ResourceTable32.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable32.getIntOffset(1);
            index[0] = this.findKey(this.size, currentOffset, this, resKey);
            if (index[0] == -1) {
                throw new MissingResourceException("Could not find resource ", ICUResourceBundleReader.getFullName(this.baseName, this.localeID), resKey);
            }
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable32.getIntOffset(this.size) + ResourceTable32.getIntOffset(index[0]));
            String path = this.isTopLevel ? resKey : this.resPath + "/" + resKey;
            return this.createBundleObject(resKey, resOffset, path, table, requested, this, isAlias);
        }

        public int getOffset(int currentOffset, int index) {
            return ICUResourceBundle.getInt(this.rawData, currentOffset + ResourceTable32.getIntOffset(index));
        }

        protected UResourceBundle handleGetImpl(int index, HashMap table, UResourceBundle requested, boolean[] isAlias) {
            if (this.size <= 0) {
                return null;
            }
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ResourceTable32.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable32.getIntOffset(1) + ResourceTable32.getIntOffset(index);
            int betterOffset = this.getOffset(currentOffset, 0);
            String itemKey = ResourceTable32.RES_GET_KEY(this.rawData, betterOffset).toString();
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable32.getIntOffset(this.size));
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return this.createBundleObject(itemKey, resOffset, path, table, requested, this, isAlias);
        }

        private int countItems() {
            int offset = ResourceTable32.RES_GET_OFFSET(this.resource);
            int value = ICUResourceBundle.getInt(this.rawData, offset);
            return value;
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable32(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String resKey, String resourcePath, long resOffset, ICUResourceBundle bundle, boolean topLevel) {
            if (bundle != null) {
                ResourceTable32.assign(this, bundle);
            }
            this.key = resKey;
            this.resource = resOffset;
            this.isTopLevel = topLevel;
            this.size = this.countItems();
            this.resPath = resourcePath;
            this.createLookupCache();
        }

        ResourceTable32(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }

    static final class ResourceTable
    extends ICUResourceBundle {
        protected UResourceBundle handleGetImpl(String resKey, HashMap table, UResourceBundle requested, int[] index, boolean[] isAlias) {
            if (this.size <= 0) {
                return null;
            }
            int offset = ResourceTable.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable.getCharOffset(1);
            index[0] = this.findKey(this.size, currentOffset, this, resKey);
            if (index[0] == -1) {
                return null;
            }
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable.getCharOffset(this.size + (~this.size & 1)) + ResourceTable.getIntOffset(index[0]));
            String path = this.isTopLevel ? resKey : this.resPath + "/" + resKey;
            return this.createBundleObject(resKey, resOffset, path, table, requested, this, isAlias);
        }

        public int getOffset(int currentOffset, int index) {
            return ResourceTable.getChar(this.rawData, currentOffset + ResourceTable.getCharOffset(index));
        }

        protected UResourceBundle handleGetImpl(int index, HashMap table, UResourceBundle requested, boolean[] isAlias) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ResourceTable.RES_GET_OFFSET(this.resource);
            int currentOffset = offset + ResourceTable.getCharOffset(1);
            int betterOffset = this.getOffset(currentOffset, index);
            String itemKey = ResourceTable.RES_GET_KEY(this.rawData, betterOffset).toString();
            long resOffset = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, currentOffset += ResourceTable.getCharOffset(this.size + (~this.size & 1)) + ResourceTable.getIntOffset(index));
            String path = this.isTopLevel ? itemKey : this.resPath + "/" + itemKey;
            return this.createBundleObject(itemKey, resOffset, path, table, requested, this, isAlias);
        }

        private int countItems() {
            int offset = ResourceTable.RES_GET_OFFSET(this.resource);
            char value = ResourceTable.getChar(this.rawData, offset);
            return value;
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle) {
            this(key, resPath, resource, bundle, false);
        }

        ResourceTable(ICUResourceBundleReader reader, String baseName, String localeID, ClassLoader loader) {
            this.rawData = reader.getData();
            this.rootResource = 0xFFFFFFFFL & (long)reader.getRootResource();
            this.noFallback = reader.getNoFallback();
            this.baseName = baseName;
            this.localeID = localeID;
            this.ulocale = new ULocale(localeID);
            this.loader = loader;
            this.initialize(null, "", this.rootResource, null, this.isTopLevel);
        }

        void initialize(String resKey, String resourcePath, long resOffset, ICUResourceBundle bundle, boolean topLevel) {
            if (bundle != null) {
                ResourceTable.assign(this, bundle);
            }
            this.key = resKey;
            this.resource = resOffset;
            this.isTopLevel = topLevel;
            this.size = this.countItems();
            this.resPath = resourcePath;
            this.createLookupCache();
        }

        ResourceTable(String key, String resPath, long resource, ICUResourceBundle bundle, boolean isTopLevel) {
            this.initialize(key, resPath, resource, bundle, isTopLevel);
        }
    }

    static final class ResourceIntVector
    extends ICUResourceBundle {
        private int[] value;

        public int[] getIntVector() {
            return this.value;
        }

        private int[] getValue() {
            int offset = ResourceIntVector.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int intOffset = offset + ResourceIntVector.getIntOffset(1);
            int[] val = new int[length];
            for (int i = 0; i < length; ++i) {
                val[i] = ICUResourceBundle.getInt(this.rawData, intOffset + ResourceIntVector.getIntOffset(i));
            }
            return val;
        }

        ResourceIntVector(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceIntVector.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.size = 1;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceString
    extends ICUResourceBundle {
        private String value;

        public String getString() {
            return this.value;
        }

        ResourceString(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceString.assign(this, bundle);
            this.value = this.getStringValue(resource);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceInt
    extends ICUResourceBundle {
        ResourceInt(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceInt.assign(this, bundle);
            this.key = key;
            this.resource = resource;
            this.resPath = resPath;
        }
    }

    static final class ResourceBinary
    extends ICUResourceBundle {
        private byte[] value;

        public ByteBuffer getBinary() {
            return ByteBuffer.wrap(this.value);
        }

        private byte[] getValue() {
            int offset = ResourceBinary.RES_GET_OFFSET(this.resource);
            int length = ICUResourceBundle.getInt(this.rawData, offset);
            int byteOffset = offset + ResourceBinary.getIntOffset(1);
            byte[] dst = new byte[length];
            System.arraycopy(this.rawData, byteOffset, dst, 0, length);
            return dst;
        }

        ResourceBinary(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceBinary.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.resPath = resPath;
            this.value = this.getValue();
        }
    }

    static final class ResourceArray
    extends ICUResourceBundle {
        protected String[] handleGetStringArray() {
            String[] strings = new String[this.size];
            UResourceBundleIterator iter = this.getIterator();
            int i = 0;
            while (iter.hasNext()) {
                strings[i++] = iter.next().getString();
            }
            return strings;
        }

        protected UResourceBundle handleGetImpl(String indexStr, HashMap table, UResourceBundle requested, int[] index, boolean[] isAlias) {
            index[0] = ResourceArray.getIndex(indexStr);
            if (index[0] > -1) {
                return this.handleGetImpl(index[0], table, requested, isAlias);
            }
            throw new UResourceTypeMismatchException("Could not get the correct value for index: " + index);
        }

        protected UResourceBundle handleGetImpl(int index, HashMap table, UResourceBundle requested, boolean[] isAlias) {
            if (index > this.size) {
                throw new IndexOutOfBoundsException();
            }
            int offset = ResourceArray.RES_GET_OFFSET(this.resource);
            int itemOffset = offset + ResourceArray.getIntOffset(index + 1);
            long itemResource = 0xFFFFFFFFL & (long)ICUResourceBundle.getInt(this.rawData, itemOffset);
            String path = this.isTopLevel ? Integer.toString(index) : this.resPath + "/" + index;
            return this.createBundleObject(Integer.toString(index), itemResource, path, table, requested, this, isAlias);
        }

        private int countItems() {
            int offset = ResourceArray.RES_GET_OFFSET(this.resource);
            int value = ResourceArray.getInt(this.rawData, offset);
            return value;
        }

        ResourceArray(String key, String resPath, long resource, ICUResourceBundle bundle) {
            ResourceArray.assign(this, bundle);
            this.resource = resource;
            this.key = key;
            this.size = this.countItems();
            this.resPath = resPath;
            this.createLookupCache();
        }
    }
}

