/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideModuleImporter;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import com.adobe.aemds.guide.utils.GuideUtils;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueDataMerger {
    protected static Set<String> blackListGuideStateKeys = new HashSet<String>(Arrays.asList("fd:rules", "layout", "fd:scripts"));
    protected Logger logger = LoggerFactory.getLogger(KeyValueDataMerger.class);
    protected JSONObject guideJSON;
    protected CustomJSONWriter jsonWriter;
    protected StringWriter stringWriter;
    protected String bindProperty;
    protected GuideModuleImporter guideModuleImporter;
    protected Map<String, Object> moduleParameter;
    private long uidCounter = 1L;

    public KeyValueDataMerger(JSONObject guideJson, Map<String, Object> params) {
        this.guideJSON = guideJson;
        this.stringWriter = new StringWriter();
        this.jsonWriter = new CustomJSONWriter(this.stringWriter);
        this.moduleParameter = params;
        if (params != null) {
            this.guideModuleImporter = (GuideModuleImporter)params.get(GuideModuleImporter.class.getName());
        }
    }

    public JSONObject merge() throws GuideException {
        try {
            this.jsonWriter.object();
            this.mergeJSONObject("root", this.guideJSON);
            this.jsonWriter.endObject();
            return new JSONObject(this.stringWriter.toString());
        }
        catch (XPathExpressionException e) {
            if (e.getCause() instanceof TransformerException && "Empty expression!".equals(e.getCause().getMessage())) {
                throw new GuideException("It might be that Unbound repeatable panels are present in AF.This is not supported for adaptive forms using the XFA form template or XSD.", e);
            }
            throw new GuideException("Invalid X Path", e);
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
    }

    public void updateMergedJson(JSONObject jsonObject, String guideNodeClass) throws Exception {
    }

    protected void updateJsonValue(JSONObject jsonObject, String value) throws Exception {
        if (value == null) {
            if (jsonObject.has("_value")) {
                value = jsonObject.getString("_value");
            } else if (jsonObject.optBoolean("defaultToCurrentDate")) {
                value = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            }
        }
        if (StringUtils.isNotEmpty(value)) {
            this.jsonWriter.key("_value").value(value);
        }
    }

    protected void moduleMergeJson(JSONObject jsonObject, String guideNodeClass) throws Exception {
    }

    protected void mergeJSONObject(String objectKey, JSONObject jsonObject) throws Exception {
        String guideNodeClass = null;
        guideNodeClass = this.addGuideNodeClass(jsonObject);
        this.addValue(jsonObject, guideNodeClass);
        Iterator<String> keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (blackListGuideStateKeys.contains(key)) continue;
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                this.jsonWriter.key(key).object();
                this.mergeJSONObject(key, (JSONObject)value);
                this.jsonWriter.endObject();
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            this.logger.trace("Found an json array in guide node structure. Ignoring this key: " + key);
        }
        this.moduleMergeJson(jsonObject, guideNodeClass);
    }

    protected String addGuideNodeClass(JSONObject jsonObject) throws Exception {
        String guideNodeClass = null;
        if (jsonObject.has("guideNodeClass")) {
            guideNodeClass = jsonObject.getString("guideNodeClass");
            this.jsonWriter.key("guideNodeClass").value(guideNodeClass);
        }
        return guideNodeClass;
    }

    protected void setCompositeFieldBindRef(JSONObject jsonObject, String bindPath) throws JSONException, Exception {
        JSONObject itemsObj = jsonObject.getJSONObject("items");
        JSONArray itemsArr = itemsObj.toJSONArray(itemsObj.names());
        for (int i = 0; i < itemsArr.length(); ++i) {
            String name;
            JSONObject item = itemsArr.optJSONObject(i);
            if (item == null || JSONObject.NULL.equals(item) || !StringUtils.isNotBlank(name = item.optString("name", ""))) continue;
            String bindRef = "";
            bindRef = StringUtils.startsWith(bindPath, "/") ? bindPath + "/" + name : "/" + bindPath + "/" + name;
            item.put(this.bindProperty, bindRef);
        }
    }

    protected void addValue(JSONObject jsonObject, String guideNodeClass) throws Exception {
        String name = "";
        if (jsonObject.has("name")) {
            name = jsonObject.getString("name");
            this.jsonWriter.key("name").value(name);
            if (GuideUtils.isGuideFieldModel(guideNodeClass) || "guideCompositeFieldItem".equals(guideNodeClass)) {
                this.updateMergedJson(jsonObject, guideNodeClass);
            } else if (StringUtils.equals(guideNodeClass, "guideTextDraw") && jsonObject.opt("documentFragmentVariables") instanceof JSONArray) {
                JSONArray textVariables = jsonObject.optJSONArray("documentFragmentVariables");
                this.jsonWriter.key("documentFragmentVariables").array();
                for (int i = 0; i < textVariables.length(); ++i) {
                    if (!(textVariables.opt(i) instanceof JSONObject)) continue;
                    JSONObject textVariable = textVariables.optJSONObject(i);
                    this.jsonWriter.object();
                    this.jsonWriter.key("variableId").value(textVariable.optString("variableId"));
                    this.updateMergedJson(textVariables.optJSONObject(i), guideNodeClass);
                    this.jsonWriter.endObject();
                }
                this.jsonWriter.endArray();
            }
        }
    }

    protected String getUniqueKey(String objectKey, JSONObject jsonObject) throws JSONException {
        String name = StringUtils.isNotBlank(objectKey) ? objectKey : jsonObject.optString("name", "");
        return name + this.uidCounter++;
    }
}

