/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.model.FormSubmitInfo;
import com.adobe.aemds.guide.service.external.PortalRecordInfo;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.XMLUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class GuideSubmitUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideSubmitUtils.class);
    public static final String REQUEST_ATTR_PDF_NAME = "pdfName";
    public static final String REQUEST_ATTR_REDIRECT_PARAMETER_MAP = "redirectParameters";
    public static final String REQ_ATTR_FORWARD_PATH = "forward.path";
    public static final String REQ_ATTR_FORWARD_OPTIONS = "forward.options";
    public static final String REQ_ATTR_GUIDE_SUBMIT_OPTIONS = "submit.options";

    public static void setForwardPath(SlingHttpServletRequest req, String path, String selector, String suffix) {
        req.setAttribute(REQ_ATTR_FORWARD_PATH, path);
        if (selector != null || suffix != null) {
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            if (selector != null) {
                options.setReplaceSelectors(selector);
            }
            if (suffix != null) {
                options.setReplaceSuffix(suffix);
            }
            req.setAttribute(REQ_ATTR_FORWARD_OPTIONS, options);
        }
    }

    public static void setRedirectUrl(SlingHttpServletRequest req, String redirectUrl) {
        req.setAttribute(":redirect", redirectUrl);
    }

    public static String getUserID(SlingHttpServletRequest request) {
        String userId = request.getResourceResolver().adaptTo(Session.class).getUserID();
        int index = userId.lastIndexOf(58);
        if (index > 0 && index + 1 < userId.length()) {
            userId = userId.substring(index + 1);
        }
        return userId;
    }

    public static Resource getParentResource(Resource resource, String jcrPrimaryType) {
        Resource parentResource = resource;
        String parentResourceType = null;
        if (resource == null) {
            return null;
        }
        if (jcrPrimaryType.isEmpty()) {
            return resource.getParent();
        }
        do {
            if ((parentResource = parentResource.getParent()) == null) continue;
            ValueMap properties = parentResource.adaptTo(ValueMap.class);
            parentResourceType = properties.get("jcr:primaryType", "");
        } while (!jcrPrimaryType.equals(parentResourceType));
        return parentResource;
    }

    public static Map<String, String> getRedirectParameters(SlingHttpServletRequest request) {
        HashMap<String, String> redirectParameters = (HashMap<String, String>)request.getAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP);
        if (redirectParameters == null) {
            redirectParameters = new HashMap<String, String>();
        }
        if (!redirectParameters.containsKey("owner")) {
            redirectParameters.put("owner", GuideSubmitUtils.getUserID(request));
        }
        if (!redirectParameters.containsKey("status")) {
            redirectParameters.put("status", "Submitted");
        }
        return redirectParameters;
    }

    private static void populateMap(JSONObject data, Map<String, String> map) throws JSONException {
        Iterator<String> keys = data.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (data.get(key) instanceof JSONObject) {
                GuideSubmitUtils.populateMap((JSONObject)data.get(key), map);
                continue;
            }
            map.put(key, data.getString(key));
        }
    }

    public static String getNameOfCompositeFieldFromChildResource(@Nonnull Resource resource) {
        String name = null;
        Resource parent = resource.getParent();
        if (parent != null && StringUtils.equals(parent.getName(), "items") && (parent = parent.getParent()) != null) {
            for (String compositeResourceType : GuideConstants.GUIDE_COMPOSITE_FIELD_RESOURCE_TYPES) {
                if (!parent.isResourceType(compositeResourceType)) continue;
                name = parent.getValueMap().get("name", "");
                break;
            }
        }
        return name;
    }

    public static Map<String, String> getGuideValueMap(FormSubmitInfo formSubmitInfo) {
        PortalRecordInfo portalRecordInfo;
        HashMap<String, String> guideValueMap = null;
        String data = formSubmitInfo.getData();
        if ("application/json".equals(formSubmitInfo.getContentType())) {
            guideValueMap = new HashMap();
            try {
                JSONObject dataJson = new JSONObject(data);
                JSONObject afDataJson = dataJson.getJSONObject("afData");
                JSONObject unboundDataJson = afDataJson.getJSONObject("afUnboundData");
                JSONObject boundDataJson = afDataJson.getJSONObject("afBoundData");
                if (unboundDataJson != null) {
                    GuideSubmitUtils.populateMap(unboundDataJson, guideValueMap);
                }
                if (boundDataJson != null) {
                    GuideSubmitUtils.populateMap(boundDataJson, guideValueMap);
                }
            }
            catch (JSONException e) {
                logger.error("Failed to retrieve data from submit data JSON.", e);
            }
        } else {
            Document document = XMLUtils.strToDoc(data);
            guideValueMap = XMLUtils.getDataMap(document);
        }
        if (guideValueMap == null) {
            guideValueMap = new HashMap();
        }
        if ((portalRecordInfo = formSubmitInfo.getPortalRecordInfo()) != null) {
            if (StringUtils.isNotEmpty(portalRecordInfo.getSubmitID())) {
                guideValueMap.put("submitID", portalRecordInfo.getSubmitID());
            }
            if (StringUtils.isNotEmpty(portalRecordInfo.getSubmitLink())) {
                guideValueMap.put("submitLink", portalRecordInfo.getSubmitLink());
            }
        }
        return guideValueMap;
    }

    public static Map<String, String> getMappedFieldParameters(String[] fieldParameterMapping) {
        HashMap<String, String> mappedFieldParameters = new HashMap<String, String>();
        if (fieldParameterMapping != null) {
            for (String param : fieldParameterMapping) {
                String fieldName;
                String[] map = StringUtils.split(param, "=");
                String mappedParam = fieldName = map[0].trim();
                if (map.length == 2) {
                    mappedParam = map[1].trim();
                }
                mappedFieldParameters.put(fieldName, mappedParam);
            }
        }
        return mappedFieldParameters;
    }

    public static void setRedirectParameters(SlingHttpServletRequest request, Map<String, String> value) {
        request.setAttribute(REQUEST_ATTR_REDIRECT_PARAMETER_MAP, value);
    }

    public static String getReqAttrPdfName(SlingHttpServletRequest request) {
        return (String)request.getAttribute(REQUEST_ATTR_PDF_NAME);
    }

    public static String addContextPath(String url, String contextPath) {
        if (StringUtils.isNotBlank(url)) {
            if (url.matches("^(https?)://.+")) {
                return url;
            }
            if (StringUtils.isNotBlank(contextPath) && !StringUtils.startsWith(url, contextPath) && StringUtils.startsWith(url, "/")) {
                url = contextPath + url;
            }
        }
        return url;
    }
}

