/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.transformer.api.ResourcePropertyTransformer;
import com.adobe.aemds.guide.utils.GuideContainerThreadLocal;
import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import com.adobe.aemds.guide.utils.GuideSubmitUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.XMLUtils;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.xml.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldNameResolverForData
implements ResourcePropertyTransformer {
    private final Logger logger = LoggerFactory.getLogger(FieldNameResolverForData.class);
    private final String schemaRoot;
    private final Map<String, String> fieldParamMap;
    private final Map<String, String> mappedParameters;
    private final Document document;
    private final XPath xPath;
    private final Element boundData;
    private final Element unboundData;

    public FieldNameResolverForData(String data, String dataType, String[] fieldNames, String schemaRoot) {
        this.schemaRoot = schemaRoot;
        this.mappedParameters = new HashMap<String, String>();
        this.fieldParamMap = GuideSubmitUtils.getMappedFieldParameters(fieldNames);
        if ("application/json".equals(dataType)) {
            try {
                JSONObject dataJson = new JSONObject(data);
                if (!dataJson.has("afData")) {
                    JSONObject wrappedJson;
                    dataJson = wrappedJson = new JSONObject().put("data", dataJson);
                }
                data = XML.toString(dataJson);
            }
            catch (JSONException e) {
                this.logger.error("Failed to retrieve data from submit data JSON.", e);
            }
        }
        this.document = XMLUtils.strToDoc(data);
        this.xPath = XPathFactory.newInstance().newXPath();
        this.boundData = XMLUtils.getBoundDataXmlElement(this.document);
        this.unboundData = XMLUtils.getUnboundDataXmlElement(this.document);
    }

    @Override
    public JSONObject transform(Resource resource, String parentSOM) throws JSONException {
        String guideNodeClass;
        String resourceName;
        if (this.fieldParamMap.isEmpty()) {
            return null;
        }
        ValueMap properties = resource.getValueMap();
        JSONObject formObject = new JSONObject(properties);
        String name = properties.get("name", "");
        switch (resourceName = resource.getName()) {
            case "layout": 
            case "items": {
                return formObject;
            }
        }
        switch (guideNodeClass = properties.get("guideNodeClass", "")) {
            case "guidePanel": 
            case "guideTable": 
            case "guideTableRow": 
            case "": {
                return formObject;
            }
        }
        if (this.fieldParamMap.containsKey(name)) {
            String value = "";
            String bindRef = properties.get("bindRef", "");
            String dataSom = properties.get("dataSom", "");
            bindRef = this.resolveBindRef(bindRef);
            try {
                Node node = null;
                if (StringUtils.isNotEmpty(bindRef)) {
                    if (StringUtils.isNotEmpty(dataSom)) {
                        dataSom = dataSom.replaceFirst("xfa\\[0\\]\\.", "").replaceAll("\\[\\s*\\d+\\s*\\]", "").replaceAll("\\.", "/");
                        String xPathExpression = XMLUtils.getRelativeXpath(dataSom, this.schemaRoot);
                        node = (Node)this.xPath.evaluate(xPathExpression, this.boundData, XPathConstants.NODE);
                    } else {
                        bindRef = StringUtils.replace(bindRef, "/text()", "");
                        String xPathExpression = XMLUtils.getRelativeXpath(bindRef, this.schemaRoot);
                        node = (Node)this.xPath.evaluate(xPathExpression, this.boundData, XPathConstants.NODE);
                    }
                } else {
                    String nameOfCompositeField = GuideSubmitUtils.getNameOfCompositeFieldFromChildResource(resource);
                    node = StringUtils.isNotBlank(nameOfCompositeField) ? (Node)this.xPath.evaluate(nameOfCompositeField + "/" + name, this.unboundData, XPathConstants.NODE) : (Node)this.xPath.evaluate(name, this.unboundData, XPathConstants.NODE);
                }
                if (node != null) {
                    value = node.getTextContent();
                }
            }
            catch (XPathExpressionException e) {
                this.logger.error("Failed to get data corresponding to field " + name, e);
            }
            this.mappedParameters.put(this.fieldParamMap.get(name), value);
            this.fieldParamMap.remove(name);
        }
        return formObject;
    }

    public Map<String, String> getMappedParameters() {
        return this.mappedParameters;
    }

    private String resolveBindRef(String bindRef) {
        GuideFragmentHolder guideFragmentHolder = null;
        try {
            guideFragmentHolder = GuideContainerThreadLocal.getGuideFragmentHolder();
            if (guideFragmentHolder != null) {
                String bindRefPrefixForFragment = guideFragmentHolder.getBindRefPrefixForFragment();
                String fragmentRoot = guideFragmentHolder.getFragmentModelRoot();
                bindRef = GuideUtils.manipulateBindRefForFragments(bindRefPrefixForFragment, bindRef, fragmentRoot);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to get fragment holder", e);
        }
        return bindRef;
    }
}

