/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.GuideConstants;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class ExpEditorUtils {
    public static JSONObject getEventsObject(JsonNode scriptsNode) throws JSONException {
        JSONArray scriptArray = new JSONArray();
        JSONObject eventsObj = new JSONObject();
        if (scriptsNode != null) {
            Iterator<Map.Entry<String, JsonNode>> scriptsIterator = scriptsNode.fields();
            while (scriptsIterator.hasNext()) {
                Map.Entry<String, JsonNode> script = scriptsIterator.next();
                String key = script.getKey();
                String eventModel = ExpEditorUtils.getScriptModel(script.getValue().asText(), key);
                String eventProperty = ExpEditorUtils.getEventProperty(key);
                scriptArray.put(eventModel);
                eventsObj.put(eventProperty, scriptArray);
            }
        }
        return eventsObj;
    }

    public static String getScriptModel(String script, String eventName) {
        String scriptModel = null;
        if (StringUtils.isNotBlank(script) && StringUtils.isNotBlank(eventName)) {
            script = StringEscapeUtils.escapeEcmaScript(script);
            scriptModel = String.format("{\"script\":{\"content\":\"%s\",\"event\":\"%s\"},\"nodeName\":\"SCRIPTMODEL\",\"version\":1,\"enabled\":true}", script, eventName);
        }
        return scriptModel;
    }

    public static String getEventProperty(String eventName) {
        String secureEventProperty = null;
        if (StringUtils.isNotBlank(eventName)) {
            secureEventProperty = GuideConstants.SECURE_EVENT_PROPERTY_MAPPING.get(eventName);
        }
        return secureEventProperty;
    }
}

