/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.transformer.impl;

import com.adobe.aemds.guide.transformer.api.ResourcePropertyTransformer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FDMRuleResourcePropertyTransformer
implements ResourcePropertyTransformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> bindRefToAFNameMap = new HashMap<String, String>();

    public Map<String, String> getBindRefToAFNameMap() {
        return this.bindRefToAFNameMap;
    }

    @Override
    public JSONObject transform(Resource resource, String parentSOM) throws JSONException {
        JSONObject obj = new JSONObject();
        ValueMap props = resource.adaptTo(ValueMap.class);
        String name = props.get("name", null);
        String bindRef = props.get("bindRef", null);
        if (StringUtils.isNotBlank(parentSOM) && StringUtils.isNotBlank(name)) {
            name = StringUtils.join(parentSOM, ".", name);
        }
        if (StringUtils.isNotEmpty(bindRef)) {
            this.bindRefToAFNameMap.put(bindRef, name);
        }
        obj.put("SOM", name);
        return obj;
    }
}

