/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.themes;

import com.adobe.aemds.guide.themes.model.Theme;
import com.adobe.aemds.guide.utils.GuideThemeUtils;
import java.util.List;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourcemerger.api.ResourceMergerService;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service(value={SlingPostProcessor.class})
public class ThemePostProcessor
implements SlingPostProcessor {
    private Logger log = LoggerFactory.getLogger(ThemePostProcessor.class);
    @Reference
    private ResourceMergerService resourceMergerService;

    @Override
    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        if (this.accepts(request)) {
            ResourceResolver resolver = request.getResourceResolver();
            Session session = resolver.adaptTo(Session.class);
            String themePath = request.getParameter("themePath");
            if (themePath != null) {
                Resource themeResource = resolver.resolve(themePath);
                Theme theme = themeResource.adaptTo(Theme.class);
                GuideThemeUtils themeUtils = new GuideThemeUtils();
                GuideThemeUtils.saveThemeCSS(theme, resolver, this.resourceMergerService);
            } else {
                String formPath = request.getParameter("formPath");
                Resource resource = request.getResource();
                GuideThemeUtils.saveInlineCSS(resource, formPath, this.resourceMergerService);
            }
        }
    }

    protected boolean accepts(SlingHttpServletRequest request) {
        return "af:saveStyleOperation".equals(request.getParameter(":operation")) || "af:copyStyleOperation".equals(request.getParameter(":operation"));
    }

    protected void bindResourceMergerService(ResourceMergerService resourceMergerService) {
        this.resourceMergerService = resourceMergerService;
    }

    protected void unbindResourceMergerService(ResourceMergerService resourceMergerService) {
        if (this.resourceMergerService == resourceMergerService) {
            this.resourceMergerService = null;
        }
    }
}

