/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.theme.model.impl;

import com.adobe.aemds.guide.themes.model.ThemeClientLib;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={Resource.class}, adapters={ThemeClientLib.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class ThemeClientLibImpl
implements ThemeClientLib {
    private static final Logger logger = LoggerFactory.getLogger(ThemeClientLibImpl.class);
    @Inject
    @Named(value="css/theme.css/jcr:content/jcr:data")
    private InputStream cssFileStream;
    @Inject
    private String[] categories;
    @Inject
    private String[] dependencies;
    private final Resource resource;

    public ThemeClientLibImpl(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getCss() {
        String fileContents = null;
        try {
            fileContents = IOUtils.toString(this.cssFileStream);
        }
        catch (IOException e) {
            logger.error("Unable to read CSS from theme client lib", e);
        }
        return fileContents;
    }

    @Override
    public String getCategory() {
        if (this.categories != null && this.categories.length > 0) {
            return this.categories[0];
        }
        return "";
    }

    @Override
    public String getBaseCategory() {
        if (this.dependencies != null && this.dependencies.length > 0) {
            return this.dependencies[0];
        }
        return "";
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }
}

