/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.theme.model.impl;

import com.adobe.aemds.guide.themes.model.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={Resource.class}, adapters={Selector.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL)
public class SelectorImpl
implements Selector {
    private final Resource resource;
    public ValueMap selectorProperties;

    public SelectorImpl(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getId() {
        return this.resource.getName();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public ValueMap getSelectorAllProperties() {
        if (this.selectorProperties == null) {
            this.selectorProperties = this.resource.adaptTo(ValueMap.class);
        }
        return this.selectorProperties;
    }

    @Override
    public Set<String> getBreakpointsIdSet() {
        HashSet<String> breakpointIdSet = new HashSet<String>();
        if (this.selectorProperties == null) {
            this.selectorProperties = this.resource.adaptTo(ValueMap.class);
        }
        for (String propertyName : this.selectorProperties.keySet()) {
            String breakpointId;
            if (!propertyName.contains("#") || breakpointIdSet.contains(breakpointId = propertyName.substring(0, propertyName.indexOf("#")))) continue;
            breakpointIdSet.add(breakpointId);
        }
        return breakpointIdSet;
    }

    @Override
    public HashSet<String> getMaskedPropertiesSet(String breakpointName, String stateName) {
        ValueMap selectorProperties = this.getSelectorAllProperties();
        String maskPropertyName = breakpointName + "#" + stateName + "#" + "mask";
        List<Object> maskedPropertiesList = new ArrayList();
        if (selectorProperties.get(maskPropertyName) != null) {
            maskedPropertiesList = Arrays.asList((String[])selectorProperties.get(maskPropertyName));
        }
        HashSet<String> maskedPropertiesSet = new HashSet<String>(maskedPropertiesList);
        return maskedPropertiesSet;
    }

    @Override
    public List<String> getStylePropertyNames(String breakpointName) {
        ArrayList<String> breakpointStates = new ArrayList<String>();
        for (String propertyName : this.getSelectorAllProperties().keySet()) {
            if (!propertyName.startsWith(breakpointName) || propertyName.endsWith("#ui") || propertyName.endsWith("#mask")) continue;
            breakpointStates.add(propertyName);
        }
        return breakpointStates;
    }

    @Override
    public List<String> getCssPropertiesList(String breakpointName, String stateName) {
        ValueMap selectorProperties = this.getSelectorAllProperties();
        String cssPropertyName = breakpointName + "#" + stateName;
        List<String> cssPropertiesList = new ArrayList<String>();
        if (selectorProperties.get(cssPropertyName) != null) {
            cssPropertiesList = Arrays.asList((String[])selectorProperties.get(cssPropertyName));
        }
        return cssPropertiesList;
    }
}

